import { IComponentApi, BackendComponentApiBase } from "@mendix/component-framework";
import { UISpec } from "../main";
import { DialogState, DialogInfo } from "../model/dialogs";
/**
 * API for showing modal dialogs.
 */
export interface IDialogApi extends IComponentApi {
    _apiId: "mendix.DialogApi";
    /**
     * Displays a modal dialog to the user.
     *
     * The UI entrypoint of the dialog is specified in the `uiSpec` parameter.
     * This entrypoint is passed a unique identifier for the dialog in the `dialogId`
     * query string parameter.
     * The `dialogId` can be used to identify the dialog when calling the {@link update},
     * {@link close}, or {@link closeWithResult} methods.
     *
     * @typeParam TResult - The type of the result expected from the modal dialog.
     * @param dialogInfo - An object containing information about the modal dialog,
     *                     including its configuration and behavior.
     * @param uiSpec - The UI specification for rendering the modal dialog.
     * @returns A promise that resolves with the result of the modal dialog when it is closed.
     *          The result can be of any type, depending on the value passed by the UI when it
     *          calls {@link closeWithResult}.
     *          If the dialog is closed by clicking the close button ('X') in the title bar,
     *          the promise resolves with the value `null`.
     */
    showModal(dialogInfo: DialogInfo, uiSpec: UISpec): Promise<unknown | null>;
    /**
     * Updates the state of an open modal dialog.
     *
     * @param dialogId - The unique identifier of the modal dialog to update.
     *                   This ID is passed to the dialog UI in the `dialogId` query string parameter.
     * @param dialogState - An object containing the state to update for the modal dialog.
     */
    update(dialogId: string, dialogState: DialogState): Promise<void>;
    /**
     * Closes an open modal dialog. This method should be called from inside the dialog UI itself.
     * When this method is used to close the dialog, the result of the dialog will be `null`.
     *
     * @param dialogId - The unique identifier of the modal dialog to update.
     *                   This ID is passed to the dialog UI in the `dialogId` query string parameter.
     */
    close(dialogId: string): Promise<void>;
    /**
     * Closes an open modal dialog. This method should be called from inside the dialog UI itself.
     * The result of the dialog will be the value passed to this method.
     *
     * @param dialogId - The unique identifier of the modal dialog to update.
     *                   This ID is passed to the dialog UI in the `dialogId` query string parameter.
     * @param result - The result to return when the modal dialog is closed.
     */
    closeWithResult(dialogId: string, result: unknown): Promise<void>;
}
export declare class DialogApi extends BackendComponentApiBase implements IDialogApi {
    get _apiId(): "mendix.DialogApi";
    private openDialogs;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
    showModal(dialogInfo: DialogInfo, uiSpec: UISpec): Promise<unknown | null>;
    update(dialogId: string, dialogState: DialogState): Promise<void>;
    close(dialogId: string): Promise<void>;
    closeWithResult(dialogId: string, result: unknown): Promise<void>;
}
