import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { Menu } from "../model/menu";
/**
 * Interface for Context Menu API.
 */
export interface IContextMenuApi extends IComponentApi<ContextMenuApiEventMap> {
    /**
     * Unique identifier for the Context Menu API.
     */
    _apiId: "mendix.ContextMenuApi";
    /**
     * Shows the context menu with the given menu items at the specified point.
     * @param menuItems - The menu items to be displayed in the context menu.
     * @param point - The point where the context menu should be displayed.
     */
    showContextMenu(menuItems: Menu[], point?: Point): void;
}
/**
 * Event map for the Context Menu API.
 * This map defines the events that the Context Menu API can emit and the data associated with each event.
 */
export type ContextMenuApiEventMap = {
    /**
     * Event triggered when a context menu item is activated.
     * The event data contains the unique identifier of the activated menu item.
     * @event
     * @property {string} menuId - The unique identifier of the activated menu item.
     */
    contextMenuItemActivated: {
        menuId: string;
    };
    /**
     * Event triggered when text is loaded from the clipboard.
     * The event data contains the text that was loaded from the clipboard.
     * @event
     * @property {string} text - The text that was loaded from the clipboard.
     */
    textFromClipboardLoaded: {
        text: string;
    };
};
/**
 * Represents a point on the screen with x and y coordinates.
 */
export type Point = {
    x: number;
    y: number;
};
/**
 * Implementation of the Context Menu API.
 */
export declare class ContextMenuApi extends BackendComponentApiBase<ContextMenuApiEventMap> implements IContextMenuApi {
    get _apiId(): "mendix.ContextMenuApi";
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
    /**
     * Shows the context menu with the given menu items at the specified point.
     * If the point is not provided, the context menu will be displayed at the current mouse position.
     * @param menuItems - The menu items to be displayed in the context menu.
     * @param point - The point where the context menu should be displayed.
     */
    showContextMenu(menuItems: Menu[], point?: Point): void;
}
