import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
/**
 * Interface for Clipboard API.
 */
export interface IClipboardApi extends IComponentApi {
    /**
     * Unique identifier for the Clipboard API.
     */
    _apiId: "mendix.ClipboardApi";
    /**
     * Writes the given text to the clipboard.
     * @param text - The text to be written to the clipboard.
     */
    write(text: string): void;
    /**
     * Reads the text from the clipboard.
     * @returns A promise that resolves to the text read from the clipboard.
     */
    read(): Promise<string>;
    /**
     * Checks if the clipboard is empty.
     * @returns A promise that resolves to a boolean indicating whether the clipboard is empty.
     */
    isEmpty(): Promise<boolean>;
}
/**
 * Implementation of the Clipboard API.
 */
export declare class ClipboardApi extends BackendComponentApiBase implements IClipboardApi {
    get _apiId(): "mendix.ClipboardApi";
    private clipboardRequestIds;
    /**
     * Writes the given text to the clipboard.
     * @param text - The text to be written to the clipboard.
     */
    write(text: string): void;
    /**
     * Reads the text from the clipboard.
     * @returns A promise that resolves to the text read from the clipboard.
     */
    read(): Promise<string>;
    /**
     * Checks if the clipboard is empty.
     * @returns A promise that resolves to a boolean indicating whether the clipboard is empty.
     */
    isEmpty(): Promise<boolean>;
    handleMessageFromBackend: (message: string, data: unknown) => boolean;
}
