import { ComponentApiBase, IComponentApi } from "@mendix/component-framework";
/**
 * API for working with the files in the app directory.
 */
export interface IAppFilesApi extends IComponentApi {
    _apiId: "mendix.AppFilesApi";
    /**
     * Retrieves the content of a file at the specified path.
     *
     * @param path The relative path of the file to retrieve.
     * @returns A promise that resolves with the content of the file.
     */
    getFile(path: string): Promise<string>;
    /**
     * Uploads content to a file at the specified path.
     *
     * @param path The relative path of the file to upload content to.
     * @param content The content to upload to the file.
     * @returns A promise that resolves when the file has been uploaded.
     */
    putFile(path: string, content: string): Promise<void>;
    /**
     * Deletes the file at the specified path.
     *
     * @param path The relative path of the file to delete.
     * @returns A promise that resolves when the file has been deleted.
     */
    deleteFile(path: string): Promise<void>;
}
export declare class AppFilesApi extends ComponentApiBase implements IAppFilesApi {
    _apiId: "mendix.AppFilesApi";
    getFile(path: string): Promise<string>;
    deleteFile(path: string): Promise<void>;
    putFile(path: string, content: string): Promise<void>;
}
