import { IComponentApi, ComponentApiBase } from "@mendix/component-framework";
import { AssociationIds, EntityIds, SheetAssociation, WorkBookColumnTypes, WorkBookData } from "@mendix/data-import-lib/index";
import { BaseEditorAPI } from "@mendix/ide-framework/interop/BaseEditorAPI";
import { IDataImporterApi } from "./IDataImporterApi";
export type GenerateDomainModelRequestData = {
    workBookData: WorkBookData;
    workBookColumnTypes: WorkBookColumnTypes;
    associations: SheetAssociation[];
};
export type GenerateDomainModelResponseData = GenerateDomainModelRequestData & {
    entityIds: EntityIds;
    associationIds: AssociationIds;
    moduleName: string;
};
export type GenerateDatabaseRequestData = GenerateDomainModelResponseData;
export type GenerateDatabaseResponseData = {
    dataSizeBeforeZipping: number;
    dataSizeAfterZipping: number;
};
type DataImporterApiEventMap = {};
export interface IDataImporterComponentApi extends IComponentApi<DataImporterApiEventMap> {
    _apiId: "mendix.DataImporterApi";
    generateDatabase(requestData: GenerateDatabaseRequestData): Promise<GenerateDatabaseResponseData>;
}
export declare class DataImporterComponentApi extends ComponentApiBase<DataImporterApiEventMap> implements IDataImporterComponentApi {
    get _apiId(): "mendix.DataImporterApi";
    generateDatabase(requestData: GenerateDatabaseRequestData): Promise<GenerateDatabaseResponseData>;
}
export declare class DataImporterApi extends BaseEditorAPI implements IDataImporterApi {
    generateDomainModel(requestData: GenerateDomainModelRequestData): Promise<GenerateDomainModelResponseData>;
    generateDatabase(requestData: GenerateDatabaseRequestData): Promise<GenerateDatabaseResponseData>;
    generateOverviewPages(): Promise<void>;
    cancel(): Promise<void>;
    success(): Promise<void>;
    openLink(link: string): Promise<void>;
}
export {};
