import { BackendComponentApiBase, IComponentApi } from "@mendix/component-framework";
import { ConnectorKitApiIds } from "../constants/ConnectorKitApiIds";
type ConnectorKitApiEventMap = {
    templateFileContentReceived: {
        data: string;
    };
};
export interface IConnectorKitApi extends IComponentApi<ConnectorKitApiEventMap> {
    _apiId: typeof ConnectorKitApiIds.ConnectorKitApi;
    getTemplateFileContent(relativeFilePath: string): Promise<string>;
}
export declare class ConnectorKitApi extends BackendComponentApiBase<ConnectorKitApiEventMap> implements IConnectorKitApi {
    get _apiId(): "mendix.ConnectorKitApi";
    getTemplateFileContent(relativeFilePath: string): Promise<string>;
    handleMessageFromBackend: (command: string, data: unknown) => boolean;
}
export {};
