export type DiscoverApiMessage = {
    type: "discover";
    apiId: string;
};
export type ProvideApiMessage = {
    type: "provide";
    apiId: string;
};
export type InvokeMethodMessage = {
    type: "invokeMethod";
    invocationId: string;
    apiId: string;
    methodName: string;
    args: unknown[];
    callbacks: ApiCallback[];
};
export type InvokeCallbackMessage = {
    type: "invokeCallback";
    invocationId: string;
    apiId: string;
    callbackId: string;
    args: unknown[];
};
export type ApiCallback = {
    callbackId: string;
    parameterIndex: number;
};
export type KeepAliveMessage = {
    type: "keepAlive";
    invocationId: string;
};
export type RespondMessage = {
    type: "respond";
    invocationId: string;
    success: boolean;
    returnValue: unknown;
    error: unknown;
};
export type NotifyMessage = {
    type: "notify";
    apiId: string;
    eventName: string;
    payload: object;
};
export type ComponentMessage = DiscoverApiMessage | ProvideApiMessage | InvokeMethodMessage | InvokeCallbackMessage | KeepAliveMessage | RespondMessage | NotifyMessage;
//# sourceMappingURL=ComponentMessageBusEvents.d.ts.map