import { EventManager } from "../helpers/EventManager";
import { ProvideApiMessage, DiscoverApiMessage, InvokeMethodMessage, KeepAliveMessage, NotifyMessage, RespondMessage, ApiCallback, InvokeCallbackMessage } from "./ComponentMessageBusEvents";
export type ComponentMessageBusEventMap = {
    discover: DiscoverApiMessage;
    provide: ProvideApiMessage;
    invokeMethod: InvokeMethodMessage;
    invokeCallback: InvokeCallbackMessage;
    keepAlive: KeepAliveMessage;
    respond: RespondMessage;
    notify: NotifyMessage;
};
export declare class ComponentMessageBus extends EventManager<ComponentMessageBusEventMap> {
    /** A channel that allows broadcasting messages within the whole browser to all pages on the same origin (so to other webviews). */
    private channel;
    private isClosed;
    constructor();
    sendApiDiscovery(apiId: string): void;
    sendProvidedApi(apiId: string): void;
    sendMethodInvocation(invocationId: string, apiId: string, methodName: string, args: unknown[], callbacks: ApiCallback[]): void;
    sendCallbackInvocation(invocationId: string, apiId: string, callbackId: string, args: unknown[]): void;
    sendKeepAlive(invocationId: string): void;
    sendResponse(invocationId: string, success: boolean, returnValue: unknown, error: unknown): void;
    sendEvent(apiId: string, eventName: string, payload: object): void;
    close(): void;
    private broadcastMessage;
    private handleIncomingMessage;
}
//# sourceMappingURL=ComponentMessageBus.d.ts.map