import { IComponentApi } from "../ComponentApi";
import { Logger } from "../helpers/logger";
import { ComponentMessageBus } from "../messagebus/ComponentMessageBus";
import { ApiCallback } from "../messagebus/ComponentMessageBusEvents";
import { ComponentFrameworkOptions } from "./ComponentFrameworkOptions";
export declare class RemoteApiInvoker {
    private readonly logger;
    private readonly messageBus;
    /** Map of invocation ID -> pending remote invocation */
    private remoteInvocations;
    private remoteInvocationTimeoutMS;
    constructor(logger: Logger, messageBus: ComponentMessageBus);
    initialize(options?: ComponentFrameworkOptions): void;
    invokeRemoteApiMethod<TApi extends IComponentApi>(apiId: TApi["_apiId"], methodName: string, args: unknown[], callbacks: ApiCallback[]): Promise<unknown>;
    invokeRemoteApiFacadeCallback<TApi extends IComponentApi>(apiId: TApi["_apiId"], callbackId: string, args: unknown[]): Promise<unknown>;
    private registerInvocationTimeout;
    private handleKeepAliveEvent;
    private handleRespondEvent;
}
//# sourceMappingURL=RemoteApiInvoker.d.ts.map