import { IComponentApi } from "../ComponentApi";
import { Logger } from "../helpers/logger";
import { ComponentMessageBus } from "../messagebus/ComponentMessageBus";
import { FunctionInvocationHandler } from "./FunctionInvocationHandler";
import { RemoteApiInvoker } from "./RemoteApiInvoker";
export declare class LocalApiRegistry {
    private readonly logger;
    private readonly messageBus;
    private readonly remoteApiInvoker;
    private readonly functionInvocationHandler;
    /** Map of API ID -> local API implementation added in {@link registerApi} */
    private readonly localComponentApis;
    constructor(logger: Logger, messageBus: ComponentMessageBus, remoteApiInvoker: RemoteApiInvoker, functionInvocationHandler: FunctionInvocationHandler);
    hasApi(apiId: string): boolean;
    registerApi(apiId: string, componentApi: IComponentApi): void;
    invokeLocalApiMethod(apiId: string, methodName: string, args: unknown[]): Promise<unknown>;
    private handleInvokeMethodEvent;
}
//# sourceMappingURL=LocalApiRegistry.d.ts.map