import { IComponentApi } from "../ComponentApi";
/**
 * The component framework allows TypeScript components to communicate using well-defined APIs.
 *
 * APIs are TypeScript interfaces that meet certain requirements:
 *
 * - It implements {@link IComponentApi} and has a unique {@link IComponentApi["_apiId"]} property,
 * - It only contains methods that return Promises, of which both the parameters and the return type are serializable values,
 * - It can raise events, of which the event args are serializable.
 */
export interface IComponentFramework {
    /**
     * Obtain an implementation of the API with the specified API ID.
     *
     * The implementation can either be a "local" object (same web context), or a facade for a remote object (different web context).
     *
     * The component framework ensures that method calls and events are propagated to remote objects.
     *
     * @param apiId The unique identifier of the API.
     */
    getApi<TApi extends IComponentApi>(apiId: TApi["_apiId"]): TApi;
    /**
     * Register an API with the component framework.
     * This allows other components to consume this API.
     *
     * If this is the singleton host, other remote component frameworks will be able to remotely call this API.
     *
     * @param apiId The unique identifier of the API.
     * @param componentApi An object implementing the API.
     */
    registerApi<TApi extends IComponentApi>(apiId: TApi["_apiId"], componentApi: TApi): void;
}
//# sourceMappingURL=IComponentFramework.d.ts.map