import { Logger } from "../helpers/logger";
import { ComponentMessageBus } from "../messagebus/ComponentMessageBus";
import { ComponentFrameworkOptions } from "./ComponentFrameworkOptions";
export declare class FunctionInvocationHandler {
    private readonly logger;
    private readonly messageBus;
    private remoteInvocationKeepAliveMS;
    constructor(logger: Logger, messageBus: ComponentMessageBus);
    initialize(options?: ComponentFrameworkOptions): void;
    /**
     * Invokes a function (method or callback), sending keepAlive messages if it takes too long, and sends the response or error.
     */
    invokeWithKeepAliveAndRespond(invocationId: string, fn: (...args: unknown[]) => Promise<unknown>, args: unknown[], logPrefix: string): Promise<void>;
}
//# sourceMappingURL=FunctionInvocationHandler.d.ts.map