import { IComponentApi } from "../ComponentApi";
import { ComponentFrameworkOptions } from "./ComponentFrameworkOptions";
import { IComponentFramework } from "./IComponentFramework";
export declare class ComponentFramework implements IComponentFramework {
    private readonly logger;
    private readonly messageBus;
    private readonly remoteApiInvoker;
    private readonly functionInvocationHandler;
    private readonly localApiRegistry;
    private readonly apiResolver;
    private readonly apiFacadeRegistry;
    /** Whether this component framework can host APIs that can be used remotely by other component frameworks. */
    private isApiHost;
    constructor(options?: ComponentFrameworkOptions);
    initialize(options?: ComponentFrameworkOptions): void;
    [Symbol.dispose](): void;
    getApi<TApi extends IComponentApi>(apiId: TApi["_apiId"]): TApi;
    registerApi<TApi extends IComponentApi>(apiId: TApi["_apiId"], componentApi: TApi): void;
}
//# sourceMappingURL=ComponentFramework.d.ts.map