import { Logger } from "../helpers/logger";
import { ComponentMessageBus } from "../messagebus/ComponentMessageBus";
import { ComponentFrameworkOptions } from "./ComponentFrameworkOptions";
import { LocalApiRegistry } from "./LocalApiRegistry";
export declare class ApiResolver {
    private readonly logger;
    private readonly messageBus;
    private readonly localApiRegistry;
    /** Map of API ID -> Promise for resolving the API in the API facade */
    private readonly resolveApiPromises;
    private apiDiscoveryRetryMS;
    private apiDiscoveryMaxAttempts;
    constructor(logger: Logger, messageBus: ComponentMessageBus, localApiRegistry: LocalApiRegistry);
    initialize(options?: ComponentFrameworkOptions): void;
    resolveApi(apiId: string): Promise<void>;
    private resolveApiAsPromise;
    private getProvidedApiListenerAsPromise;
    private handleDiscoverEvent;
}
//# sourceMappingURL=ApiResolver.d.ts.map