import { IComponentApi } from "../ComponentApi";
import { Logger } from "../helpers/logger";
import { ComponentMessageBus } from "../messagebus/ComponentMessageBus";
import { ApiResolver } from "./ApiResolver";
import { FunctionInvocationHandler } from "./FunctionInvocationHandler";
import { LocalApiRegistry } from "./LocalApiRegistry";
import { RemoteApiInvoker } from "./RemoteApiInvoker";
export declare class ApiFacadeRegistry {
    private readonly logger;
    private readonly messageBus;
    private readonly localApiRegistry;
    private readonly remoteApiInvoker;
    private readonly functionInvocationHandler;
    private readonly apiResolver;
    /** Map of API ID -> API facade returned from {@link getApi} */
    private readonly apiFacades;
    constructor(logger: Logger, messageBus: ComponentMessageBus, localApiRegistry: LocalApiRegistry, remoteApiInvoker: RemoteApiInvoker, functionInvocationHandler: FunctionInvocationHandler, apiResolver: ApiResolver);
    getApiFacade<TApi extends IComponentApi>(apiId: TApi["_apiId"]): TApi;
    private invokeApiMethod;
    private handleInvokeCallbackEvent;
    notifyEventListeners(apiId: string, eventType: string, eventArgs: object): void;
    private sendEvent;
    private handleNotifyEvent;
}
//# sourceMappingURL=ApiFacadeRegistry.d.ts.map