import { EventManager } from "../helpers/EventManager";
import { Logger } from "../helpers/logger";
import { ApiImplementation } from "./ApiImplementation";
export type ApiFacade = {
    /** This is a facade for the component API. */
    componentApi: ApiImplementation;
    /** The event emitter is used to emit the events to the API consumers. */
    eventEmitter: ApiFacadeEventEmitter;
    /** A map of callback IDs to their corresponding local callback functions. */
    callbacks: Map<string, ApiFacadeCallback>;
};
export type ApiFacadeCallback = (...args: unknown[]) => Promise<unknown>;
export declare function buildApiFacade(logger: Logger, apiId: string, invokeApiMethod: (callbacks: Map<string, ApiFacadeCallback>, apiId: string, methodName: string, args: unknown[]) => Promise<unknown>): ApiFacade;
declare class ApiFacadeEventEmitter extends EventManager<{
    [eventType: string]: object;
}> {
    emitEventFromApi(eventType: string, eventArgs: object): void;
}
export {};
//# sourceMappingURL=ApiFacade.d.ts.map