import { EventManager, IEventManager } from "./helpers/EventManager";
/**
 * Every component API must implement this interface, which is usually done by inheriting from {@link ComponentApiBase}.
 *
 * This interface exists because APIs can be distributed by an interface alone (that inherits from this one), where the inplementation
 * can live in another web context and is thus unknown.
 *
 * @typeParam EventMap An object type that represents the events that this API can emit (keys) and the shape of their event args (types).
 */
export interface IComponentApi<EventMap extends Record<string, object> = {}> extends IEventManager<EventMap> {
    /**
     * Unique identifier that can be used to register or retrieve a specific API.
     *
     * Example: mendix.EditorsAPI, mycompany.MyFunkyAPI
     */
    readonly _apiId: string;
}
/**
 * Base class for every component API.
 *
 * @typeParam EventMap An object type that represents the events that this API can emit (keys) and the shape of their event args (types).
 */
export declare abstract class ComponentApiBase<EventMap extends Record<string, object> = {}> extends EventManager<EventMap> implements IComponentApi<EventMap> {
    abstract get _apiId(): string;
}
//# sourceMappingURL=ComponentApi.d.ts.map