import { MessageBus } from "@mendix/wef-transportation";
import { ComponentApiBase } from "./ComponentApi";
/**
 * Base class for every component API with backend (C#) communication.
 *
 * @param EventMap An object type that represents the events that this API can emit (keys) and the shape of their event args (types).
 */
export declare abstract class BackendComponentApiBase<EventMap extends Record<string, object> = {}> extends ComponentApiBase<EventMap> {
    private backendMessageBus;
    readonly dispose: () => void;
    constructor(backendMessageBus: MessageBus);
    /**
     * Special method to prevent typescript from complaining when using the value in the constructor
     */
    private getApiId;
    protected postMessageToBackend(message: string, data?: Record<string, unknown>): void;
    private delegateMessage;
    protected handleMessageFromBackend?: (message: string, data: unknown) => boolean | Promise<boolean>;
}
//# sourceMappingURL=BackendComponentApiBase.d.ts.map