/**
 * Plugin to only write the changed files to the output bundle
 * @returns 
 */
export default function onlyWriteChanged() {
    const fileHashes = new Map();

    return {
        name: "rollup-plugin-mendix-only-write-changed",

        generateBundle(_, bundle) {
            if (!this.meta.watchMode) return;

            for (const fileName in bundle) {
                const bundleContent = bundle[fileName]?.code;

                if (!bundleContent?.length) continue;

                // Generate hash for the content of the file in the bundle
                const bundleHash = createHash(bundleContent);

                if (fileHashes.get(fileName) === bundleHash) {
                    // File content has not changed, delete from bundle
                    delete bundle[fileName];
                } else {
                    fileHashes.set(fileName, bundleHash);
                }
            }
        },
    };
}

// As we don't use the hash for encryption purposes, we use a Fowler-Noll-Vo hash function which is speedy.
function createHash(str) {
    let hash = 2166136261;

    for (let i = 0; i < str.length; i++) {
        hash ^= str.charCodeAt(i);
        hash += (hash << 1) + (hash << 4) + (hash << 7) + (hash << 8) + (hash << 24);
    }

    return hash >>> 0;
}
