import fs from "fs/promises";
import path from "path";
import { glob } from "glob";

const mendixCopy = (options) => {
    if (!options || !options.sources || !Array.isArray(options.sources)) {
        throw new Error("Invalid options provided.");
    }

    return {
        name: "rollup-plugin-mendix-copy",
        async generateBundle() {
            // Loop through each source configuration
            for (const source of options.sources) {
                if (!source.folder || !source.include) {
                    throw new Error("Invalid target structure provided.");
                }

                const excludeExtensions =
                    source.exclude?.map((extension) => extension.toLowerCase()) || [];

                // Find matching files using glob
                const results = await glob(source.include, {
                    cwd: source.folder,
                    nodir: true,
                    ignore: {
                        // Exclude files based on extension
                        ignored: (p) => excludeExtensions.includes(path.extname(p.name).toLowerCase()),
                    },
                });

                // Process each file: read its content and emit it as an asset
                for (const file of results) {
                    const src = path.join(source.folder, file);
                    const fileContent = await fs.readFile(src);
                    const emittedFileName = path.posix.normalize(file);

                    this.emitFile({
                        type: "asset",
                        fileName: emittedFileName,
                        originalFileName: src,
                        source: fileContent,
                    });
                }
            }
        },
    };
};

export default mendixCopy;
