import { deleteAsync } from 'del';
export default function del(options = {}) {
    const { hook = 'buildStart', runOnce = false, targets = [], verbose = false, ...delOptions } = options;
    let deleted = false;
    return {
        name: 'delete',
        // eslint-disable-next-line perfectionist/sort-objects
        [hook]: async () => {
            if (runOnce && deleted) {
                return;
            }
            const paths = await deleteAsync(targets, delOptions);
            if (verbose || delOptions.dryRun) {
                const message = delOptions.dryRun
                    ? `Expected files and folders to be deleted: ${paths.length}`
                    : `Deleted files and folders: ${paths.length}`;
                console.log(message);
                if (paths.length) {
                    paths.forEach((path) => {
                        console.log(path);
                    });
                }
            }
            // eslint-disable-next-line require-atomic-updates
            deleted = true;
        }
    };
}
