/**
* @flow strict-local
*/

"use strict";

import type { ViewProps } from "../View/ViewPropTypes";

const React = require("react");
const View = require("../View/View");
const TextInput = require("../TextInput/TextInput");
const TextInputEventEmitter = require("../TextInput/TextInputEventEmitter");

const TopLevelView: React.AbstractComponent<ViewProps, React.ElementRef<typeof View>> = React.forwardRef(
    (props: ViewProps, forwardedRef) => {
        return (
            <View onStartShouldSetResponderCapture={(e) => {
                if (TextInput.State.currentlyFocusedInput() !== e.target) {
                        TextInputEventEmitter.emit("tapOutside");
                }
                return false;
            }}
                {...props}
            >
                {props.children}
            </View>
        );
    }
);

View.displayName = "TopLevelView";

module.exports = TopLevelView;