import React, { forwardRef } from 'react';
import { tagMessage } from '../../../utils';
export const Wrap = /*#__PURE__*/forwardRef(({
  children
}, ref) => {
  try {
    var _Object$getPrototypeO;

    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const child = React.Children.only(children);
    const isRNSVGNode = ((_Object$getPrototypeO = Object.getPrototypeOf(child === null || child === void 0 ? void 0 : child.type)) === null || _Object$getPrototypeO === void 0 ? void 0 : _Object$getPrototypeO.name) === 'WebShape';

    if (isRNSVGNode) {
      const clone = /*#__PURE__*/React.cloneElement(child, {
        ref
      }, // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
      child.props.children);
      return clone;
    }

    return /*#__PURE__*/React.createElement("div", {
      ref: ref,
      style: {
        display: 'contents'
      }
    }, child);
  } catch (e) {
    throw new Error(tagMessage(`GestureDetector got more than one view as a child. If you want the gesture to work on multiple views, wrap them with a common parent and attach the gesture to that view.`));
  }
}); // On web we never take a path with Reanimated,
// therefore we can simply export Wrap

export const AnimatedWrap = Wrap;
//# sourceMappingURL=Wrap.web.js.map