"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overlay = Overlay;
var _reactNative = require("react-native");
var _jsxRuntime = require("react/jsx-runtime");
function Overlay({
  open,
  onPress,
  style,
  accessibilityLabel = 'Close drawer',
  ...rest
}) {
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    ...rest,
    style: [styles.overlay, {
      opacity: open ? 1 : 0,
      pointerEvents: open ? 'auto' : 'none'
    }, style],
    accessibilityElementsHidden: !open,
    importantForAccessibility: open ? 'auto' : 'no-hide-descendants',
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Pressable, {
      onPress: onPress,
      style: [styles.pressable, {
        pointerEvents: open ? 'auto' : 'none'
      }],
      accessibilityRole: "button",
      accessibilityLabel: accessibilityLabel
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  overlay: {
    ..._reactNative.StyleSheet.absoluteFillObject,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    // Disable touch highlight on mobile Safari.
    // WebkitTapHighlightColor must be used outside of StyleSheet.create because react-native-web will omit the property.
    // @ts-expect-error: WebkitTapHighlightColor is web only
    WebkitTapHighlightColor: 'transparent',
    transition: 'opacity 0.3s'
  },
  pressable: {
    flex: 1
  }
});
//# sourceMappingURL=Overlay.js.map