"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Drawer = Drawer;
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _useLatestCallback = _interopRequireDefault(require("use-latest-callback"));
var _DrawerProgressContext = require("../utils/DrawerProgressContext.js");
var _getDrawerWidth = require("../utils/getDrawerWidth.js");
var _useFakeSharedValue = require("../utils/useFakeSharedValue.js");
var _Overlay = require("./Overlay");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Drawer({
  layout: customLayout,
  direction = 'ltr',
  drawerPosition = direction === 'rtl' ? 'right' : 'left',
  drawerStyle,
  drawerType = 'front',
  onClose,
  onTransitionStart,
  onTransitionEnd,
  open,
  overlayStyle,
  overlayAccessibilityLabel,
  renderDrawerContent,
  children,
  style
}) {
  const windowDimensions = (0, _reactNative.useWindowDimensions)();
  const layout = customLayout ?? windowDimensions;
  const drawerWidth = (0, _getDrawerWidth.getDrawerWidth)({
    layout,
    drawerStyle
  });
  const progress = (0, _useFakeSharedValue.useFakeSharedValue)(open ? 1 : 0);
  React.useEffect(() => {
    progress.value = open ? 1 : 0;
  }, [open, progress]);
  const drawerRef = React.useRef(null);
  const onTransitionStartLatest = (0, _useLatestCallback.default)(() => {
    onTransitionStart?.(open === false);
  });
  const onTransitionEndLatest = (0, _useLatestCallback.default)(() => {
    onTransitionEnd?.(open === false);
  });
  React.useEffect(() => {
    const element = drawerRef.current;
    element?.addEventListener('transitionstart', onTransitionStartLatest);
    element?.addEventListener('transitionend', onTransitionEndLatest);
    return () => {
      element?.removeEventListener('transitionstart', onTransitionStartLatest);
      element?.removeEventListener('transitionend', onTransitionEndLatest);
    };
  }, [onTransitionEndLatest, onTransitionStartLatest]);
  const isOpen = drawerType === 'permanent' ? true : open;
  const isRight = drawerPosition === 'right';
  let translateX = 0;

  // The drawer stays in place at open position when `drawerType` is `back`
  if (open || drawerType === 'back') {
    if (direction === 'rtl') {
      translateX = drawerPosition === 'left' ? drawerWidth - layout.width : 0;
    } else {
      translateX = drawerPosition === 'left' ? 0 : layout.width - drawerWidth;
    }
  } else {
    if (direction === 'rtl') {
      translateX = drawerPosition === 'left' ? -layout.width : drawerWidth;
    } else {
      translateX = drawerPosition === 'left' ? -drawerWidth : layout.width;
    }
  }
  const drawerAnimatedStyle = drawerType !== 'permanent' ? {
    transition: 'transform 0.3s',
    transform: [{
      translateX
    }]
  } : null;
  const contentAnimatedStyle = drawerType !== 'permanent' ? {
    transition: 'transform 0.3s',
    transform: [{
      translateX: open ?
      // The screen content stays in place when `drawerType` is `front`
      drawerType === 'front' ? 0 : drawerWidth * (drawerPosition === 'left' ? 1 : -1) : 0
    }]
  } : null;
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: [styles.container, style],
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_DrawerProgressContext.DrawerProgressContext.Provider, {
      value: progress,
      children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
        style: [styles.main, {
          flexDirection: drawerType === 'permanent' ? isRight && direction === 'ltr' || !isRight && direction === 'rtl' ? 'row' : 'row-reverse' : 'row'
        }],
        children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
          style: [styles.content, contentAnimatedStyle],
          children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
            accessibilityElementsHidden: isOpen && drawerType !== 'permanent',
            importantForAccessibility: isOpen && drawerType !== 'permanent' ? 'no-hide-descendants' : 'auto',
            style: styles.content,
            children: children
          }), drawerType !== 'permanent' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_Overlay.Overlay, {
            open: open,
            progress: progress,
            onPress: () => onClose(),
            style: overlayStyle,
            accessibilityLabel: overlayAccessibilityLabel
          }) : null]
        }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          ref: drawerRef,
          style: [styles.drawer, {
            width: drawerWidth,
            position: drawerType === 'permanent' ? 'relative' : 'absolute',
            zIndex: drawerType === 'back' ? -1 : 0
          }, drawerAnimatedStyle, drawerStyle],
          children: renderDrawerContent()
        })]
      })
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  container: {
    flex: 1
  },
  drawer: {
    top: 0,
    bottom: 0,
    maxWidth: '100%',
    backgroundColor: 'white'
  },
  content: {
    flex: 1
  },
  main: {
    flex: 1
  }
});
//# sourceMappingURL=Drawer.js.map