"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFakeSharedValue = useFakeSharedValue;
var React = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FakeSharedValue {
  _listeners = new Map();
  constructor(value) {
    this._value = value;
  }
  addListener(id, listener) {
    this._listeners.set(id, listener);
  }
  removeListener(id) {
    this._listeners.delete(id);
  }
  modify(modifier) {
    this.value = modifier !== undefined ? modifier(this.value) : this.value;
  }
  get() {
    return this.value;
  }
  set(value) {
    this.value = value;
  }
  set value(value) {
    this._value = value;
    for (const listener of this._listeners.values()) {
      listener(value);
    }
  }
  get value() {
    return this._value;
  }
  _isReanimatedSharedValue = true;
}

/**
 * Compatibility layer for `useDrawerProgress` with `react-native-reanimated`
 */
function useFakeSharedValue(value) {
  const sharedValue = React.useRef(null);
  if (sharedValue.current === null) {
    sharedValue.current = new FakeSharedValue(value);
  }
  return sharedValue.current;
}
//# sourceMappingURL=useFakeSharedValue.js.map