import{Big}from"big.js";import{j as getAttributeType,k as getAttributeEnumerationType}from"./ChJoRR9k.js";import{e as ensure,A as AssertionError,c as crash}from"./D_wx3dK9.js";import{b as available}from"./DMKwwHAr.js";const knownEnumerations=new Map;function addEnumerations(enumerations){Object.entries(enumerations).forEach((([e,enumerationValue])=>{knownEnumerations.has(e)||knownEnumerations.set(e,enumerationValue)}))}function translateEnumeration(enumeration,value){const knownOption=ensure(knownEnumerations.get(enumeration)).find((([option])=>option===value));return knownOption?knownOption[1]:value}function getEnumerationOptions(enumeration){return ensure(knownEnumerations.get(enumeration)).map((([option])=>option))}function clientToAttributeValue(value,type){if(null!==value)switch(type){case"DateTime":return new Date(value);case"AutoNumber":return new Big(value);default:return value}}function attributeToClientValue(value){return void 0===value?null:value instanceof Date?value.getTime():value}function runtimeValueToAttributeValue(runtimeValue,type){return clientToAttributeValue(runtimeValueToClientValue(runtimeValue,type),type)}function attributeValueToRuntimeValue(attributeValue){return clientToRuntimeValue(attributeToClientValue(attributeValue))}function runtimeValueToClientValue(value,type){if(null===value)return null;switch(type){case"Integer":case"Long":case"Decimal":return new Big(value);case"Date":case"DateTime":return value;case"Boolean":return Boolean(value);case"ObjectReferenceSet":return Array.isArray(value)&&value.length>0?value:null;default:return String(value)}}function assertIsAttributeValue(value,entity,attribute){const type=getAttributeType(entity,attribute);if(!type)throw new AssertionError(`Attribute ${attribute} is not accessible.`);"Enum"===type?function(condition){if(!condition)throw new AssertionError(`Value ${value} is not assignable to attribute of type ${type}.`)}(void 0===value||"string"==typeof value&&getEnumerationOptions(getAttributeEnumerationType(entity,attribute)).includes(value)):assertIsNonEnumValue(value,type)}function assertIsVariableValue(value,type,enumerationId){if(!type)throw new AssertionError("Value type is not valid.");"Enum"===type?function(condition){if(!condition)throw new AssertionError(`Value ${value} is not assignable to variable of type ${type}.`)}(void 0===value||"string"==typeof value&&!!enumerationId&&getEnumerationOptions(enumerationId).includes(value)):assertIsNonEnumValue(value,type,!1,"Variable")}function assertIsNonEnumValue(value,type,allowUndefinedRefSets=!1,assertionValueType="Attribute"){switch(type){case"String":case"ObjectReference":case"HashString":return assertIs("string"==typeof value||null==value);case"ObjectReferenceSet":return assertIs(Array.isArray(value)&&value.every((v=>"string"==typeof v))||null==value&&allowUndefinedRefSets);case"Boolean":return assertIs("boolean"==typeof value);case"DateTime":return assertIs(null==value||value instanceof Date&&!isNaN(value.getTime()));case"Integer":case"Long":case"Decimal":return assertIs(value instanceof Big||null==value);default:throw new AssertionError(`${assertionValueType} type ${type} is not supported.`)}function assertIs(condition){if(!condition)throw new AssertionError(`Value '${value}' is not assignable to ${assertionValueType.toLowerCase()} of type ${type}.`)}}function clientToRuntimeValue(value){return value instanceof Big?value.toString():value}function anyToClientValue(value,type){if(null==value)return"ObjectReferenceSet"===type?[]:null;switch(type){case"Boolean":return Boolean(value);case"Decimal":case"Integer":case"Long":return new Big(value);case"DateTime":return Number(value);case"ObjectReference":if(Array.isArray(value))throw new Error("Trying to set single object reference to multiple values");return value.toString();case"ObjectReferenceSet":if(!Array.isArray(value))throw new Error("Trying to set object reference set to single value");return value.map((guid=>guid.toString()));default:return String(value)}}function assertIsPositiveInteger(value){if("number"==typeof value&&value>=0&&Math.floor(value)===value)return!0;throw new AssertionError(`Value ${value} should be a positive integer.`)}function assertIsBoolean(value){if("boolean"==typeof value)return!0;throw new AssertionError(`Value ${value} should be a boolean.`)}function runtimeValueToArgument(value,type){if(null!==value)return Array.isArray(value)?value.length?{guids:value}:void 0:"ObjectReference"===type?{guid:"string"==typeof value?value:crash()}:{value:value}}function attributeValueToActionArgument(value,kind){switch(kind){case"object":return{id:value};case"list":return{ids:value};case"primitive":return{primitive:value}}}function actionArgumentToWidgetVariable(actionArgument){if(actionArgument)return"object"in actionArgument?available(actionArgument.object):"id"in actionArgument?actionArgument.id:"ids"in actionArgument?actionArgument.ids:"primitive"in actionArgument?actionArgument.primitive:crash()}function attributeValueToRuntimeArgument(value,kind){switch(kind){case"object":return{guid:value};case"list":return{guids:value};case"primitive":return{value:attributeValueToRuntimeValue(value)}}}export{attributeValueToActionArgument as a,actionArgumentToWidgetVariable as b,attributeValueToRuntimeArgument as c,attributeValueToRuntimeValue as d,clientToAttributeValue as e,assertIsNonEnumValue as f,assertIsPositiveInteger as g,assertIsBoolean as h,getEnumerationOptions as i,assertIsVariableValue as j,attributeToClientValue as k,assertIsAttributeValue as l,anyToClientValue as m,clientToRuntimeValue as n,runtimeValueToAttributeValue as o,runtimeValueToArgument as p,addEnumerations as q,runtimeValueToClientValue as r,translateEnumeration as t};
