import Big from"big.js";import{d as deepEqual}from"../CF3f8JjG.js";import{f as freezeExpression,d as dataSourceIdSymbol,i as isFilterable,g as getAttributeInfoById,a as getAssociationInfoById,b as isLiteralExpression,c as getAttributeTypeById,e as getAssociationTypeById,h as getEnumUniverseById,j as isFilterCondition,k as isValueExpression,l as isAttributeExpression,m as isAssociationExpression}from"../CNO9G7wa.js";import{g as getDataSourceId,i as isObjectItem,a as isObjectItemArray}from"../hlWZOpx4.js";import{d as unique,A as AssertionError,c as crash,e as ensure}from"../D_wx3dK9.js";import"../DighN41N.js";import"../B1iMrXCs.js";import"../B1284HK7.js";import"react";function attribute(attributeId){return function(attributeId){if(!function(attributeId){if("string"!=typeof attributeId)return!1;return void 0!==getAttributeInfoById(attributeId)}(attributeId))throw new AssertionError(`Argument of function "attribute" is not a valid attribute id: ${attributeId}`);if(!isFilterable(attributeId))throw new AssertionError(`Argument of function "attribute" is not a filterable attribute id: ${attributeId}`)}(attributeId),freezeExpression({type:"attribute",attributeId:attributeId})}function literal(value){const valueType=function(value){const type=typeof value;switch(type){case"boolean":case"string":case"undefined":return type;case"object":if(value instanceof Big)return"Numeric";if(value instanceof Date)return"DateTime";if(isObjectItem(value))return"Reference";if(isObjectItemArray(value)){if(0===value.length)throw new AssertionError('Argument of function "literal" cannot be an empty array, use empty() instead.');return"ReferenceSet"}}throw new AssertionError(`Argument of function "literal" is not a valid literal value: ${value}`)}(value),literalValue=function(value,valueType){switch(valueType){case"Reference":const item=value;return{value:item.id,[dataSourceIdSymbol]:getDataSourceId(item)};case"ReferenceSet":const items=value,dataSourceIds=items.map(getDataSourceId);if(unique(dataSourceIds).length>1)throw new AssertionError('Argument of function "literal" cannot contain object items from multiple data sources');return{value:Object.freeze(items.map((v=>v.id))),[dataSourceIdSymbol]:dataSourceIds[0]};default:return{value:Object.freeze(value)}}}(value,valueType);return freezeExpression({type:"literal",...literalValue,valueType:valueType})}function empty(){return literal(void 0)}function association(associationId){return function(associationId){if(!function(associationId){if("string"!=typeof associationId)return!1;return void 0!==getAssociationInfoById(associationId)}(associationId))throw new AssertionError(`Argument of function "association" is not a valid association id: ${associationId}`);if(!isFilterable(associationId))throw new AssertionError(`Argument of function "association" is not a filterable association id: ${associationId}`)}(associationId),freezeExpression({type:"association",associationId:associationId})}function and(...args){return assertAtLeastTwoArguments("and",args),assertValidFilterConditions("and",args),multiaryFunction("and",...args)}function or(...args){return assertAtLeastTwoArguments("or",args),assertValidFilterConditions("or",args),multiaryFunction("or",...args)}function not(arg){return assertValidFilterCondition("not",arg),function(functionName,arg){return functionExpression(functionName,{arg:arg})}("not",arg)}function equals(arg1,arg2){return assertValidValueExpression("equals",arg1,0),assertValidValueExpression("equals",arg2,1),assertCompatibleValueTypes("equals",arg1,arg2),assertValidEnumTypes("equals",arg1,arg2),assertValidReferenceSets("equals",arg1,arg2),binaryFunction("=",arg1,arg2)}function notEqual(arg1,arg2){return assertValidValueExpression("notEqual",arg1,0),assertValidValueExpression("notEqual",arg2,1),assertCompatibleValueTypes("notEqual",arg1,arg2),assertValidEnumTypes("notEqual",arg1,arg2),assertValidReferenceSets("notEqual",arg1,arg2),binaryFunction("!=",arg1,arg2)}const allowedOrderedComparisonTypes=["string","Numeric","DateTime"];function greaterThan(arg1,arg2){return assertValidValueExpression("greaterThan",arg1,0),assertValidValueExpression("greaterThan",arg2,1),assertCompatibleValueTypes("greaterThan",arg1,arg2,allowedOrderedComparisonTypes),binaryFunction(">",arg1,arg2)}function lessThan(arg1,arg2){return assertValidValueExpression("lessThan",arg1,0),assertValidValueExpression("lessThan",arg2,1),assertCompatibleValueTypes("lessThan",arg1,arg2,allowedOrderedComparisonTypes),binaryFunction("<",arg1,arg2)}function greaterThanOrEqual(arg1,arg2){return assertValidValueExpression("greaterThanOrEqual",arg1,0),assertValidValueExpression("greaterThanOrEqual",arg2,1),assertCompatibleValueTypes("greaterThanOrEqual",arg1,arg2,allowedOrderedComparisonTypes),binaryFunction(">=",arg1,arg2)}function lessThanOrEqual(arg1,arg2){return assertValidValueExpression("lessThanOrEqual",arg1,0),assertValidValueExpression("lessThanOrEqual",arg2,1),assertCompatibleValueTypes("lessThanOrEqual",arg1,arg2,allowedOrderedComparisonTypes),binaryFunction("<=",arg1,arg2)}const allowedStringFunctionAttributeTypes=["String","Integer","Long","Decimal","AutoNumber"];function contains(arg1,arg2){switch(assertValidExpression("attribute or association expression",(expr=>isAttributeExpression(expr)||isAssociationExpression(expr)),"contains",arg1,0),assertValidLiteralExpression("contains",arg2,1),arg1.type){case"association":assertExpectedType("contains",0,getAssociationType(arg1.associationId),["ReferenceSet"]),assertExpectedType("contains",1,getValueType(arg2),["Reference","ReferenceSet"]),assertCompatibleDataSources("contains",arg1,arg2);break;case"attribute":assertExpectedType("contains",0,getAttributeType(arg1.attributeId),allowedStringFunctionAttributeTypes),assertExpectedType("contains",1,getValueType(arg2),["string"]);break;default:crash()}return binaryFunction("contains",arg1,arg2)}function startsWith(arg1,arg2){return assertValidAttributeExpression("startsWith",arg1,0),assertValidLiteralExpression("startsWith",arg2,1),assertExpectedType("startsWith",0,getAttributeType(arg1.attributeId),allowedStringFunctionAttributeTypes),assertExpectedType("startsWith",1,getValueType(arg2),["string"]),binaryFunction("starts-with",arg1,arg2)}function endsWith(arg1,arg2){return assertValidAttributeExpression("endsWith",arg1,0),assertValidLiteralExpression("endsWith",arg2,1),assertExpectedType("endsWith",0,getAttributeType(arg1.attributeId),allowedStringFunctionAttributeTypes),assertExpectedType("endsWith",1,getValueType(arg2),["string"]),binaryFunction("ends-with",arg1,arg2)}function dayEquals(arg1,arg2){return assertValidAttributeExpression("dayEquals",arg1,0),assertValidLiteralExpression("dayEquals",arg2,1),assertCompatibleValueTypes("dayEquals",arg1,arg2,["DateTime"]),binaryFunction("day:=",arg1,arg2)}function dayNotEqual(arg1,arg2){return assertValidAttributeExpression("dayNotEqual",arg1,0),assertValidLiteralExpression("dayNotEqual",arg2,1),assertCompatibleValueTypes("dayNotEqual",arg1,arg2,["DateTime"]),binaryFunction("day:!=",arg1,arg2)}function dayGreaterThan(arg1,arg2){return assertValidAttributeExpression("dayGreaterThan",arg1,0),assertValidLiteralExpression("dayGreaterThan",arg2,1),assertCompatibleValueTypes("dayGreaterThan",arg1,arg2,["DateTime"]),binaryFunction("day:>",arg1,arg2)}function dayLessThan(arg1,arg2){return assertValidAttributeExpression("dayLessThan",arg1,0),assertValidLiteralExpression("dayLessThan",arg2,1),assertCompatibleValueTypes("dayLessThan",arg1,arg2,["DateTime"]),binaryFunction("day:<",arg1,arg2)}function dayGreaterThanOrEqual(arg1,arg2){return assertValidAttributeExpression("dayGreaterThanOrEqual",arg1,0),assertValidLiteralExpression("dayGreaterThanOrEqual",arg2,1),assertCompatibleValueTypes("dayGreaterThanOrEqual",arg1,arg2,["DateTime"]),binaryFunction("day:>=",arg1,arg2)}function dayLessThanOrEqual(arg1,arg2){return assertValidAttributeExpression("dayLessThanOrEqual",arg1,0),assertValidLiteralExpression("dayLessThanOrEqual",arg2,1),assertCompatibleValueTypes("dayLessThanOrEqual",arg1,arg2,["DateTime"]),binaryFunction("day:<=",arg1,arg2)}function binaryFunction(functionName,arg1,arg2){return functionExpression(functionName,{arg1:arg1,arg2:arg2})}function multiaryFunction(functionName,...args){return functionExpression(functionName,{args:Object.freeze(args)})}function functionExpression(functionName,args){return freezeExpression({type:"function",name:functionName,...args})}function assertAtLeastTwoArguments(functionName,args){if(args.length<2)throw new AssertionError(`The "${functionName}" function requires at least two arguments.`)}function assertValidFilterConditions(functionName,args){args.forEach(((arg,i)=>assertValidFilterCondition(functionName,arg,i)))}function assertValidFilterCondition(functionName,arg,index){assertValidExpression("filter condition",isFilterCondition,functionName,arg,index)}function assertValidValueExpression(functionName,arg,index){assertValidExpression("value expression",isValueExpression,functionName,arg,index)}function assertValidAttributeExpression(functionName,arg,index){assertValidExpression("attribute expression",isAttributeExpression,functionName,arg,index)}function assertValidLiteralExpression(functionName,arg,index){assertValidExpression("literal expression",isLiteralExpression,functionName,arg,index)}function assertValidExpression(description,predicate,functionName,arg,index){const argument=void 0!==index?`Argument #${index}`:"Argument";if(null==arg)throw new AssertionError(`${argument} of function "${functionName}" cannot be ${arg}`);if(!predicate(arg))throw new AssertionError(`${argument} of function "${functionName}" is not a valid ${description}`)}function assertCompatibleValueTypes(functionName,arg1,arg2,expectedTypes=[]){const type1=getValueType(arg1),type2=getValueType(arg2);if(assertExpectedType(functionName,0,type1,expectedTypes),assertExpectedType(functionName,1,type2,expectedTypes),type1!==type2&&"undefined"!==type1&&"undefined"!==type2)throw new AssertionError(`The arguments of function "${functionName}" have incompatible types (${type1} != ${type2}).`);assertCompatibleDataSources(functionName,arg1,arg2)}function assertCompatibleDataSources(functionName,arg1,arg2){const dataSourceId1=getSelectableObjectsId(arg1),dataSourceId2=getSelectableObjectsId(arg2);if(dataSourceId1!==dataSourceId2&&void 0!==dataSourceId1&&void 0!==dataSourceId2)throw new AssertionError(`The arguments of function "${functionName}" are incompatible, because they are not referring to objects from the same data source.`)}function assertValidReferenceSets(functionName,arg1,arg2){if(assertNoReferenceSetLiteral(functionName,0,arg1),assertNoReferenceSetLiteral(functionName,1,arg2),isReferenceSetAssociation(arg1)&&isReferenceSetAssociation(arg2))throw new AssertionError(`The arguments of function "${functionName}" cannot both be reference set associations.`)}function assertNoReferenceSetLiteral(functionName,index,arg){if(isLiteralExpression(arg)&&"ReferenceSet"===arg.valueType)throw new AssertionError(`Argument #${index} of function "${functionName}" cannot be a reference set literal, only empty().`)}function isReferenceSetAssociation(arg1){return"association"===arg1.type&&"ReferenceSet"===getAssociationType(arg1.associationId)}function assertValidEnumTypes(functionName,arg1,arg2){const enumUniverse1=isEnumAttribute(arg1)?getEnumUniverse(arg1.attributeId):void 0,enumUniverse2=isEnumAttribute(arg2)?getEnumUniverse(arg2.attributeId):void 0;if(void 0===enumUniverse1&&void 0===enumUniverse2)return;if(void 0!==enumUniverse1&&void 0!==enumUniverse2){if(!deepEqual(enumUniverse1,enumUniverse2)){const universe1=`[${enumUniverse1.join(", ")}]`,universe2=`[${enumUniverse2.join(", ")}]`;throw new AssertionError(`Arguments of function "${functionName}" are incompatible enum attributes (${universe1} != ${universe2}).`)}return}const enumUniverse=enumUniverse1??enumUniverse2;function checkEnumLiteral(index,arg){if("literal"!==arg.type)return;const literalValue=arg.value;if(void 0!==literalValue&&!enumUniverse.includes(literalValue)){const universe=`[${enumUniverse.join(", ")}]`;throw new AssertionError(`Argument #${index} of function "${functionName}" has an invalid enum literal value (${literalValue} != ${universe}).`)}}checkEnumLiteral(0,arg1),checkEnumLiteral(1,arg2)}function assertExpectedType(functionName,index,actual,expected){if(0!==expected.length&&!expected.includes(actual)){const expectedString=1===expected.length?expected[0]:`[${expected.join(", ")}]`;throw new AssertionError(`Argument #${index} of function "${functionName}" has an incompatible type (${actual} != ${expectedString}).`)}}function getValueType(expression){switch(expression.type){case"attribute":return function(attributeId){const attributeType=getAttributeType(attributeId);switch(attributeType){case"Boolean":return"boolean";case"DateTime":return"DateTime";case"AutoNumber":case"Integer":case"Long":case"Decimal":return"Numeric";case"Enum":case"String":case"HashString":return"string";case"Binary":case"EnumSet":case"ObjectReference":case"ObjectReferenceSet":throw new AssertionError("Unsupported attribute type: "+attributeType)}}(expression.attributeId);case"literal":return expression.valueType;case"association":return getAssociationType(expression.associationId)}}function getSelectableObjectsId(expression){switch(expression.type){case"attribute":return;case"literal":return expression[dataSourceIdSymbol];case"association":return getAssociationInfoById(expression.associationId)?.selectableObjectsId}}function getAttributeType(attributeId){return ensure(getAttributeTypeById(attributeId))}function getAssociationType(associationId){return ensure(getAssociationTypeById(associationId))}function isEnumAttribute(arg){return"attribute"===arg.type&&"Enum"===getAttributeType(arg.attributeId)}function getEnumUniverse(attributeId){return ensure(getEnumUniverseById(attributeId))}export{and,association,attribute,contains,dayEquals,dayGreaterThan,dayGreaterThanOrEqual,dayLessThan,dayLessThanOrEqual,dayNotEqual,empty,endsWith,equals,greaterThan,greaterThanOrEqual,lessThan,lessThanOrEqual,literal,not,notEqual,or,startsWith};
