import Big from"big.js";import{d as deepEqual}from"./CF3f8JjG.js";import{e as ensure,c as crash,A as AssertionError}from"./D_wx3dK9.js";import{s as ensureAttributeId,g as getAttributeInfoById,c as getAttributeTypeById}from"./CNO9G7wa.js";function conditionalExpression(condition,then,elseExpr){return{type:"conditional",condition:condition,then:then,else:elseExpr}}function functionExpression(name,arg1,arg2){return{type:"function",name:name,parameters:void 0===arg2?[arg1]:[arg1,arg2]}}function literalExpression(value){return{type:"literal",value:value}}function literalNumericExpression(value){return{type:"literalNumeric",value:value}}function variableExpression(variableName,attribute){return void 0!==attribute?{type:"variable",variable:variableName,path:attribute}:{type:"variable",variable:variableName}}const attributeIdToSortingFlag={};function registerSortingAttribute(attributeId,sortable){attributeIdToSortingFlag[attributeId]=sortable}function ensureValidAttribute(attributeId){const attributeInfo=getAttributeInfoById(attributeId),sortable=attributeIdToSortingFlag[attributeId];if(void 0===attributeInfo||void 0===sortable)throw new AssertionError(`Sort order item: invalid attribute id '${attributeId}'`);return{attributePath:attributeInfo.attributePath,sortable:sortable}}function convertToSortSpecs(sortInstructions){return sortInstructions.map((s=>[ensureValidAttribute(s[0]).attributePath,s[1]]))}function convertToSortInstructions(sortSpecs,dataSourceId){return sortSpecs.map((s=>{const attributeId=ensureAttributeId(s[0],dataSourceId);return registerSortingAttribute(attributeId,!0),[attributeId,s[1]]}))}function convertSortInstructionToExpression(sortInstruction){const attributePath=ensure(getAttributeInfoById(sortInstruction[0])).attributePath,attributeType=ensure(getAttributeTypeById(sortInstruction[0])),attributePathExpression=variableExpression("currentObject",attributePath);return"String"===attributeType?functionExpression("toLowerCase",attributePathExpression):attributePathExpression}function getCompareFunction(sortOrder){return function(item1,item2){let compareResult=0;for(let i=0;i<sortOrder.length&&0===compareResult;i++){const sortValue1=item1.sortValues[i],sortValue2=item2.sortValues[i],sortInstruction=ensure(sortOrder[i]),factor="asc"===sortInstruction[1]?1:-1;if(sortValue1===sortValue2)continue;if(void 0===sortValue1||""===sortValue1){compareResult=factor;break}if(void 0===sortValue2||""===sortValue2){compareResult=-factor;break}switch(ensure(getAttributeTypeById(sortInstruction[0]))){case"AutoNumber":compareResult=Big(sortValue1).cmp(Big(sortValue2));break;case"String":case"Enum":case"HashString":compareResult=sortValue1>sortValue2?1:-1;break;case"Long":case"Integer":case"Decimal":sortValue1 instanceof Big&&sortValue2 instanceof Big||crash(),compareResult=sortValue1.cmp(sortValue2);break;case"DateTime":sortValue1 instanceof Date&&sortValue2 instanceof Date||crash(),compareResult=sortValue1.getTime()>sortValue2.getTime()?1:-1;break;case"Boolean":compareResult=sortValue1?1:-1;break;default:crash()}compareResult*=factor}if(0===compareResult){const factor="asc"===ensure(sortOrder[0])[1]?1:-1;compareResult=item1.mxObject.getGuid()>item2.mxObject.getGuid()?factor:-factor}return compareResult}}function equalSortInstructions(a,b){return deepEqual(a,b)}function assertIsValidSortOrder(options,dataSourceId){if(void 0===options)return!0;if(!Array.isArray(options))throw new AssertionError("Sort order: must be array");return options.forEach((o=>function(sortItem){if(!Array.isArray(sortItem)||2!==sortItem.length)throw new AssertionError("Sort order item: must be an array with 2 elements");const[id,dir]=sortItem;if(!function(id){return ensureValidAttribute(id).sortable}(id))throw new AssertionError(`Sort order item: attribute with id '${id}' is not sortable`);if(getAttributeInfoById(id).dataSourceId!==dataSourceId)throw new AssertionError(`Sort order item: attribute with id '${id}' is linked to a different data source`);if("asc"!==dir&&"desc"!==dir)throw new AssertionError(`Sort order item: sort direction must be 'asc' or 'desc'. Got: '${dir}'`)}(o))),!0}export{assertIsValidSortOrder as a,conditionalExpression as b,convertSortInstructionToExpression as c,literalExpression as d,equalSortInstructions as e,functionExpression as f,getCompareFunction as g,convertToSortInstructions as h,convertToSortSpecs as i,literalNumericExpression as l,registerSortingAttribute as r,variableExpression as v};
