import{V as ValidationError,D as DescribedError}from"./2WW7glmp.js";import{g as getSession}from"./Cta-OvjQ.js";import{g as getUI}from"./DlmX1Pqa.js";import{A as AssertionError,m as mapValues,c as crash,e as ensure}from"./D_wx3dK9.js";import{o as handleError}from"./DMKwwHAr.js";import{g as getData,a as onlineData,m as methodToPromise,o as offlineData}from"./BdJSoYCn.js";import{t as toRuntimeArguments,d as toNanoflowArguments}from"./CJhMfmGP.js";import{n as nanoflowEngine}from"./CodIrb3G.js";import{c as cancelChanges}from"./6Bs1nd4y.js";import{j as toNumber,k as evaluateActionExpression}from"./C6y83v65.js";import{g as getByGuid,a as getByGuids}from"./BJNnJLMR.js";import{t as translate}from"./DNKYy4Rk.js";import{L as LogManager}from"./DecP5gSw.js";async function synchronize(){const ui=getUI(),progressId=ui.showProgress(void 0,!0);try{await getData().synchronizeOffline()}finally{ui.hideProgress(progressId)}}async function getUnsavedObjects(currentForm){return await methodToPromise(currentForm,"publish","submit"),await methodToPromise(currentForm,"publish","commit"),currentForm.getSubmitObjects()}async function openPage(modelerConfig,clientConfig,actionArguments){const[pageParameters,parameters]=function(actionArguments){const pageParameters={},otherArguments={};return Object.keys(actionArguments).forEach((k=>{k.startsWith(PARAMETER_ARGUMENT_PREFIX)?pageParameters["$"+k.substring(PARAMETER_ARGUMENT_PREFIX.length)]=actionArguments[k]:otherArguments[k]=actionArguments[k]})),[pageParameters,otherArguments]}(actionArguments);let pageArguments=[{}];for(const[name,value]of Object.entries(pageParameters))if(value){if("object"in value)pageArguments.forEach((p=>p[name]=value.object));else if("objects"in value){if(1!==pageArguments.length)throw new AssertionError("Multiple parameters with multiple objects are not supported");const args=pageArguments[0];pageArguments=value.objects.map((o=>({...args,[name]:o})))}else if("id"in value){const object=await getByGuid(value.id);pageArguments.forEach((p=>p[name]=object))}else if("ids"in value)throw new AssertionError("Parameters with multi-selection are not supported")}else pageArguments.forEach((p=>p[name]=void 0));clientConfig.abortOnClientValidations&&await clientConfig.currentForm.triggerValidation(),clientConfig.abortOnServerValidations&&await methodToPromise(getData(),"validate",clientConfig.currentForm.getSubmitObjects());const formsOpened=await Promise.all(pageArguments.map((async function(args){let specializedSettings;if(modelerConfig.specializations){const object=args[modelerConfig.specializations.argument];specializedSettings=object?modelerConfig.specializations.pageSettings[object.getEntity()]:void 0}const settings=specializedSettings??modelerConfig,title=settings.title?await evaluateActionExpression(settings.title,parameters)??"":void 0,numberOfPagesToClose=modelerConfig.numberOfPagesToClose?toNumber(await evaluateActionExpression(modelerConfig.numberOfPagesToClose,parameters)):void 0,formParameters=settings.params?mapValues(settings.params,(p=>args[p]?.getGuid())):mapValues(args,(o=>o?.getGuid()));return getUI().openForm2(settings.name,formParameters,title,clientConfig.currentForm,{...settings,formParams:clientConfig.formParams},numberOfPagesToClose)})));return pageArguments.length>1?formsOpened:formsOpened[0]}const PARAMETER_ARGUMENT_PREFIX="param$";const logger=LogManager.get().getLogger();async function openLink(config,parameter){const url="addressAttribute"in config?await methodToPromise(ensure(parameter),"fetch",config.addressAttribute):config.address,validUrl=function(schema,url){if(null==url)return void logger.error("Attempted to open missing link URL");switch(schema){case"email":return`mailto:${escape(url)}`;case"call":return`tel:${escape(url)}`;case"text":return`sms:${escape(url)}`;default:const normalizedUrl=url.trim().toLowerCase();return normalizedUrl.startsWith("javascript:")||normalizedUrl.startsWith("vbscript:")||normalizedUrl.startsWith("data:")?void logger.error("Attempted to open invalid link URL",url):url}}(config.schema,url);void 0!==validUrl&&("web"===config.schema?window.open(validUrl,"_blank","noopener"):window.open(validUrl,"_self"))}function executeAction(action,clientConfig,actionArguments,callback,errorHandler){const session=getSession();function getObject(args){return"$object"in args&&args.$object?"object"in args.$object?args.$object.object:crash():void 0}function handleError$1(e){errorHandler?errorHandler(e):e instanceof ValidationError||handleError(e)}session.hasSomeRole(action.config.allowedRoles)?async function(){switch(action.type){case"callMicroflow":return async function(modelerConfig,clientConfig,actionArguments){const ui=getUI(),confirmation=modelerConfig.confirmation;if(confirmation&&!await new Promise((resolve=>ui.confirmation({cancel:confirmation.cancel,proceed:confirmation.proceed,content:confirmation.question,handler:()=>resolve(!0),onCancel:()=>resolve(!1)}))))return;if(clientConfig.beforeExecuteAction&&clientConfig.beforeExecuteAction(),clientConfig.abortOnClientValidations)switch(modelerConfig.validate){case"node":if(!clientConfig.widgetIsValid)throw new ValidationError;break;case"view":await clientConfig.currentForm.triggerValidation()}const progressId=modelerConfig.progress?ui.showProgress(modelerConfig.progress.message,modelerConfig.progress.modal):void 0;try{await methodToPromise(clientConfig.currentForm,"publish","submit");const validationGuids=clientConfig.abortOnServerValidations?clientConfig.currentForm.getSubmitObjects().map((mxobj=>mxobj.getGuid())):[];mx.isOffline()?await offlineData().executeMicroflow(modelerConfig.operationId,toRuntimeArguments(actionArguments),clientConfig.currentForm,validationGuids,Boolean(modelerConfig.async)):await onlineData().executeMicroflow(modelerConfig.operationId,toRuntimeArguments(actionArguments),clientConfig.currentForm,validationGuids,Boolean(modelerConfig.async))}finally{void 0!==progressId&&ui.hideProgress(progressId)}}(action.config,clientConfig,actionArguments);case"callNanoflow":return async function(modelerConfig,clientConfig,actionArguments){clientConfig.beforeExecuteAction&&clientConfig.beforeExecuteAction(),clientConfig.abortOnClientValidations&&await clientConfig.currentForm.triggerValidation(),await methodToPromise(clientConfig.currentForm,"publish","submit"),await nanoflowEngine.execute(modelerConfig.nanoflow,await toNanoflowArguments(actionArguments),clientConfig.currentForm)}(action.config,clientConfig,actionArguments);case"cancelChanges":return cancelChanges(action.config,clientConfig);case"closePage":return async function(modelerConfig,{currentForm:currentForm},parameters){const numberOfPagesToClose=modelerConfig.numberOfPagesToClose?toNumber(await evaluateActionExpression(modelerConfig.numberOfPagesToClose,parameters)):1;if(numberOfPagesToClose<1)throw new AssertionError(`The number of pages to close evaluated to ${numberOfPagesToClose}. It must be at least 1.`);return currentForm.closePage(numberOfPagesToClose)}(action.config,clientConfig,actionArguments);case"doNothing":return;case"openLink":return openLink(action.config,getObject(actionArguments));case"openPage":return openPage(action.config,clientConfig,actionArguments).then((()=>{}));case"saveChanges":return async function(config,{currentForm:currentForm}){await currentForm.triggerValidation(),currentForm.setSuspend(!0);try{const objectsToCommit=await getUnsavedObjects(currentForm);mx.isOffline()?await new Promise(((resolve,reject)=>{getData().commit({mxobjs:objectsToCommit,callback:resolve,error:reject})})):await onlineData().executeObjectAction(config.operationId,"commit",objectsToCommit);try{config.syncAutomatically&&await synchronize()}finally{config.closePage&&await methodToPromise(currentForm,"close")}}finally{currentForm.setSuspend(!1)}}(action.config,clientConfig);case"signOut":return async function(){getSession().isGuest()||(getUI().showProgress(void 0,!0),mx.logout())}();case"synchronize":return synchronize();case"deleteObject":return async function(config,{currentForm:currentForm},parameter){let objects;if(parameter)if("object"in parameter)objects=[parameter.object];else if("objects"in parameter)objects=parameter.objects;else if("id"in parameter)objects=await getByGuids([parameter.id]);else{if(!("ids"in parameter))throw new AssertionError;objects=await getByGuids(parameter.ids)}else objects=[];const confirmation=translate(objects.length>1?"mxui.widget.DataGrid":"mxui.sys.UI","confirm_delete",objects.length.toString()),ui=getUI();if(await new Promise((resolve=>ui.confirmation({content:confirmation,handler:()=>{resolve(!0)},onCancel:()=>{resolve(!1)}})))){currentForm.setSuspend(!0);try{mx.isOffline()?await offlineData().delete(objects):config.operationId&&await onlineData().executeObjectAction(config.operationId,"delete",objects),config.closePage&&await methodToPromise(currentForm,"close")}finally{currentForm.setSuspend(!1)}}}(action.config,clientConfig,actionArguments.$object);case"createObject":return async function(modelerConfig,clientConfig,{$object:$object,...parameters}){const parameter=$object?"object"in $object?$object.object:crash():void 0;if("association"in modelerConfig&&void 0===parameter)throw new AssertionError;const ui=getUI(),pid=ui.showProgress("",!1);try{let mxObject;mxObject=mx.isOffline(modelerConfig.entity)?await offlineData().create(modelerConfig.entity):await onlineData().createObject(modelerConfig.entity,modelerConfig.operationId),modelerConfig.association&&mxObject.addReference(modelerConfig.association,parameter.getGuid()),await openPage({...modelerConfig.pageSettings,numberOfPagesToClose:modelerConfig.numberOfPagesToClose},clientConfig,{[modelerConfig.objectParameter]:{object:mxObject},...parameters})}finally{ui.hideProgress(pid)}}(action.config,clientConfig,actionArguments);case"callExternalAction":return async function(config,{currentForm:currentForm},actionObject){config.commit&&await currentForm.triggerValidation(),config.closePage&&currentForm.setSuspend(!0);try{const confirmation=config.confirmation;if(confirmation&&!await new Promise((resolve=>getUI().confirmation({cancel:confirmation.cancel,proceed:confirmation.proceed,content:confirmation.question,handler:()=>resolve(!0),onCancel:()=>resolve(!1)}))))return;const objectsToCommit=config.commit?await getUnsavedObjects(currentForm):[];await onlineData().executeExternalAction(config.operationId,actionObject,objectsToCommit),config.closePage&&await methodToPromise(currentForm,"close")}finally{currentForm.setSuspend(!1)}}(action.config,clientConfig,ensure(getObject(actionArguments)));default:throw new AssertionError}}().then(callback,handleError$1):session.isGuest()?getUI().showLogin():handleError$1(new DescribedError("Unable to execute action because you do not have sufficient permissions."))}export{executeAction as e};
