import{r as requiredArgs,t as toDate,a as toInteger,_ as _typeof}from"./BOqbOrqk.js";import{l as locale,g as getLocale,a as getDateFnsLocale}from"./CWy7-DrR.js";function addMilliseconds(dirtyDate,dirtyAmount){requiredArgs(2,arguments);var timestamp=toDate(dirtyDate).getTime(),amount=toInteger(dirtyAmount);return new Date(timestamp+amount)}var defaultOptions={};function getDefaultOptions(){return defaultOptions}function startOfWeek(dirtyDate,options){var _ref,_ref2,_ref3,_options$weekStartsOn,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(1,arguments);var defaultOptions=getDefaultOptions(),weekStartsOn=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$weekStartsOn=null==options?void 0:options.weekStartsOn)&&void 0!==_options$weekStartsOn?_options$weekStartsOn:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.weekStartsOn)&&void 0!==_ref3?_ref3:defaultOptions.weekStartsOn)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.weekStartsOn)&&void 0!==_ref?_ref:0);if(!(weekStartsOn>=0&&weekStartsOn<=6))throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");var date=toDate(dirtyDate),day=date.getDay(),diff=(day<weekStartsOn?7:0)+day-weekStartsOn;return date.setDate(date.getDate()-diff),date.setHours(0,0,0,0),date}function getTimezoneOffsetInMilliseconds(date){var utcDate=new Date(Date.UTC(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours(),date.getMinutes(),date.getSeconds(),date.getMilliseconds()));return utcDate.setUTCFullYear(date.getFullYear()),date.getTime()-utcDate.getTime()}function isValid(dirtyDate){if(requiredArgs(1,arguments),!function(value){return requiredArgs(1,arguments),value instanceof Date||"object"===_typeof(value)&&"[object Date]"===Object.prototype.toString.call(value)}(dirtyDate)&&"number"!=typeof dirtyDate)return!1;var date=toDate(dirtyDate);return!isNaN(Number(date))}function subMilliseconds(dirtyDate,dirtyAmount){return requiredArgs(2,arguments),addMilliseconds(dirtyDate,-toInteger(dirtyAmount))}function startOfUTCISOWeek(dirtyDate){requiredArgs(1,arguments);var date=toDate(dirtyDate),day=date.getUTCDay(),diff=(day<1?7:0)+day-1;return date.setUTCDate(date.getUTCDate()-diff),date.setUTCHours(0,0,0,0),date}function getUTCISOWeekYear(dirtyDate){requiredArgs(1,arguments);var date=toDate(dirtyDate),year=date.getUTCFullYear(),fourthOfJanuaryOfNextYear=new Date(0);fourthOfJanuaryOfNextYear.setUTCFullYear(year+1,0,4),fourthOfJanuaryOfNextYear.setUTCHours(0,0,0,0);var startOfNextYear=startOfUTCISOWeek(fourthOfJanuaryOfNextYear),fourthOfJanuaryOfThisYear=new Date(0);fourthOfJanuaryOfThisYear.setUTCFullYear(year,0,4),fourthOfJanuaryOfThisYear.setUTCHours(0,0,0,0);var startOfThisYear=startOfUTCISOWeek(fourthOfJanuaryOfThisYear);return date.getTime()>=startOfNextYear.getTime()?year+1:date.getTime()>=startOfThisYear.getTime()?year:year-1}function getUTCISOWeek(dirtyDate){requiredArgs(1,arguments);var date=toDate(dirtyDate),diff=startOfUTCISOWeek(date).getTime()-function(dirtyDate){requiredArgs(1,arguments);var year=getUTCISOWeekYear(dirtyDate),fourthOfJanuary=new Date(0);return fourthOfJanuary.setUTCFullYear(year,0,4),fourthOfJanuary.setUTCHours(0,0,0,0),startOfUTCISOWeek(fourthOfJanuary)}(date).getTime();return Math.round(diff/6048e5)+1}function startOfUTCWeek(dirtyDate,options){var _ref,_ref2,_ref3,_options$weekStartsOn,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(1,arguments);var defaultOptions=getDefaultOptions(),weekStartsOn=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$weekStartsOn=null==options?void 0:options.weekStartsOn)&&void 0!==_options$weekStartsOn?_options$weekStartsOn:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.weekStartsOn)&&void 0!==_ref3?_ref3:defaultOptions.weekStartsOn)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.weekStartsOn)&&void 0!==_ref?_ref:0);if(!(weekStartsOn>=0&&weekStartsOn<=6))throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");var date=toDate(dirtyDate),day=date.getUTCDay(),diff=(day<weekStartsOn?7:0)+day-weekStartsOn;return date.setUTCDate(date.getUTCDate()-diff),date.setUTCHours(0,0,0,0),date}function getUTCWeekYear(dirtyDate,options){var _ref,_ref2,_ref3,_options$firstWeekCon,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(1,arguments);var date=toDate(dirtyDate),year=date.getUTCFullYear(),defaultOptions=getDefaultOptions(),firstWeekContainsDate=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$firstWeekCon=null==options?void 0:options.firstWeekContainsDate)&&void 0!==_options$firstWeekCon?_options$firstWeekCon:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.firstWeekContainsDate)&&void 0!==_ref3?_ref3:defaultOptions.firstWeekContainsDate)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.firstWeekContainsDate)&&void 0!==_ref?_ref:1);if(!(firstWeekContainsDate>=1&&firstWeekContainsDate<=7))throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");var firstWeekOfNextYear=new Date(0);firstWeekOfNextYear.setUTCFullYear(year+1,0,firstWeekContainsDate),firstWeekOfNextYear.setUTCHours(0,0,0,0);var startOfNextYear=startOfUTCWeek(firstWeekOfNextYear,options),firstWeekOfThisYear=new Date(0);firstWeekOfThisYear.setUTCFullYear(year,0,firstWeekContainsDate),firstWeekOfThisYear.setUTCHours(0,0,0,0);var startOfThisYear=startOfUTCWeek(firstWeekOfThisYear,options);return date.getTime()>=startOfNextYear.getTime()?year+1:date.getTime()>=startOfThisYear.getTime()?year:year-1}function getUTCWeek(dirtyDate,options){requiredArgs(1,arguments);var date=toDate(dirtyDate),diff=startOfUTCWeek(date,options).getTime()-function(dirtyDate,options){var _ref,_ref2,_ref3,_options$firstWeekCon,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(1,arguments);var defaultOptions=getDefaultOptions(),firstWeekContainsDate=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$firstWeekCon=null==options?void 0:options.firstWeekContainsDate)&&void 0!==_options$firstWeekCon?_options$firstWeekCon:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.firstWeekContainsDate)&&void 0!==_ref3?_ref3:defaultOptions.firstWeekContainsDate)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.firstWeekContainsDate)&&void 0!==_ref?_ref:1),year=getUTCWeekYear(dirtyDate,options),firstWeek=new Date(0);return firstWeek.setUTCFullYear(year,0,firstWeekContainsDate),firstWeek.setUTCHours(0,0,0,0),startOfUTCWeek(firstWeek,options)}(date,options).getTime();return Math.round(diff/6048e5)+1}function addLeadingZeros(number,targetLength){for(var sign=number<0?"-":"",output=Math.abs(number).toString();output.length<targetLength;)output="0"+output;return sign+output}var formatters$1_y=function(date,token){var signedYear=date.getUTCFullYear(),year=signedYear>0?signedYear:1-signedYear;return addLeadingZeros("yy"===token?year%100:year,token.length)},formatters$1_M=function(date,token){var month=date.getUTCMonth();return"M"===token?String(month+1):addLeadingZeros(month+1,2)},formatters$1_d=function(date,token){return addLeadingZeros(date.getUTCDate(),token.length)},formatters$1_h=function(date,token){return addLeadingZeros(date.getUTCHours()%12||12,token.length)},formatters$1_H=function(date,token){return addLeadingZeros(date.getUTCHours(),token.length)},formatters$1_m=function(date,token){return addLeadingZeros(date.getUTCMinutes(),token.length)},formatters$1_s=function(date,token){return addLeadingZeros(date.getUTCSeconds(),token.length)},formatters$1_S=function(date,token){var numberOfDigits=token.length,milliseconds=date.getUTCMilliseconds();return addLeadingZeros(Math.floor(milliseconds*Math.pow(10,numberOfDigits-3)),token.length)},dayPeriodEnum_midnight="midnight",dayPeriodEnum_noon="noon",dayPeriodEnum_morning="morning",dayPeriodEnum_afternoon="afternoon",dayPeriodEnum_evening="evening",dayPeriodEnum_night="night",formatters={G:function(date,token,localize){var era=date.getUTCFullYear()>0?1:0;switch(token){case"G":case"GG":case"GGG":return localize.era(era,{width:"abbreviated"});case"GGGGG":return localize.era(era,{width:"narrow"});default:return localize.era(era,{width:"wide"})}},y:function(date,token,localize){if("yo"===token){var signedYear=date.getUTCFullYear(),year=signedYear>0?signedYear:1-signedYear;return localize.ordinalNumber(year,{unit:"year"})}return formatters$1_y(date,token)},Y:function(date,token,localize,options){var signedWeekYear=getUTCWeekYear(date,options),weekYear=signedWeekYear>0?signedWeekYear:1-signedWeekYear;return"YY"===token?addLeadingZeros(weekYear%100,2):"Yo"===token?localize.ordinalNumber(weekYear,{unit:"year"}):addLeadingZeros(weekYear,token.length)},R:function(date,token){return addLeadingZeros(getUTCISOWeekYear(date),token.length)},u:function(date,token){return addLeadingZeros(date.getUTCFullYear(),token.length)},Q:function(date,token,localize){var quarter=Math.ceil((date.getUTCMonth()+1)/3);switch(token){case"Q":return String(quarter);case"QQ":return addLeadingZeros(quarter,2);case"Qo":return localize.ordinalNumber(quarter,{unit:"quarter"});case"QQQ":return localize.quarter(quarter,{width:"abbreviated",context:"formatting"});case"QQQQQ":return localize.quarter(quarter,{width:"narrow",context:"formatting"});default:return localize.quarter(quarter,{width:"wide",context:"formatting"})}},q:function(date,token,localize){var quarter=Math.ceil((date.getUTCMonth()+1)/3);switch(token){case"q":return String(quarter);case"qq":return addLeadingZeros(quarter,2);case"qo":return localize.ordinalNumber(quarter,{unit:"quarter"});case"qqq":return localize.quarter(quarter,{width:"abbreviated",context:"standalone"});case"qqqqq":return localize.quarter(quarter,{width:"narrow",context:"standalone"});default:return localize.quarter(quarter,{width:"wide",context:"standalone"})}},M:function(date,token,localize){var month=date.getUTCMonth();switch(token){case"M":case"MM":return formatters$1_M(date,token);case"Mo":return localize.ordinalNumber(month+1,{unit:"month"});case"MMM":return localize.month(month,{width:"abbreviated",context:"formatting"});case"MMMMM":return localize.month(month,{width:"narrow",context:"formatting"});default:return localize.month(month,{width:"wide",context:"formatting"})}},L:function(date,token,localize){var month=date.getUTCMonth();switch(token){case"L":return String(month+1);case"LL":return addLeadingZeros(month+1,2);case"Lo":return localize.ordinalNumber(month+1,{unit:"month"});case"LLL":return localize.month(month,{width:"abbreviated",context:"standalone"});case"LLLLL":return localize.month(month,{width:"narrow",context:"standalone"});default:return localize.month(month,{width:"wide",context:"standalone"})}},w:function(date,token,localize,options){var week=getUTCWeek(date,options);return"wo"===token?localize.ordinalNumber(week,{unit:"week"}):addLeadingZeros(week,token.length)},I:function(date,token,localize){var isoWeek=getUTCISOWeek(date);return"Io"===token?localize.ordinalNumber(isoWeek,{unit:"week"}):addLeadingZeros(isoWeek,token.length)},d:function(date,token,localize){return"do"===token?localize.ordinalNumber(date.getUTCDate(),{unit:"date"}):formatters$1_d(date,token)},D:function(date,token,localize){var dayOfYear=function(dirtyDate){requiredArgs(1,arguments);var date=toDate(dirtyDate),timestamp=date.getTime();date.setUTCMonth(0,1),date.setUTCHours(0,0,0,0);var difference=timestamp-date.getTime();return Math.floor(difference/864e5)+1}(date);return"Do"===token?localize.ordinalNumber(dayOfYear,{unit:"dayOfYear"}):addLeadingZeros(dayOfYear,token.length)},E:function(date,token,localize){var dayOfWeek=date.getUTCDay();switch(token){case"E":case"EE":case"EEE":return localize.day(dayOfWeek,{width:"abbreviated",context:"formatting"});case"EEEEE":return localize.day(dayOfWeek,{width:"narrow",context:"formatting"});case"EEEEEE":return localize.day(dayOfWeek,{width:"short",context:"formatting"});default:return localize.day(dayOfWeek,{width:"wide",context:"formatting"})}},e:function(date,token,localize,options){var dayOfWeek=date.getUTCDay(),localDayOfWeek=(dayOfWeek-options.weekStartsOn+8)%7||7;switch(token){case"e":return String(localDayOfWeek);case"ee":return addLeadingZeros(localDayOfWeek,2);case"eo":return localize.ordinalNumber(localDayOfWeek,{unit:"day"});case"eee":return localize.day(dayOfWeek,{width:"abbreviated",context:"formatting"});case"eeeee":return localize.day(dayOfWeek,{width:"narrow",context:"formatting"});case"eeeeee":return localize.day(dayOfWeek,{width:"short",context:"formatting"});default:return localize.day(dayOfWeek,{width:"wide",context:"formatting"})}},c:function(date,token,localize,options){var dayOfWeek=date.getUTCDay(),localDayOfWeek=(dayOfWeek-options.weekStartsOn+8)%7||7;switch(token){case"c":return String(localDayOfWeek);case"cc":return addLeadingZeros(localDayOfWeek,token.length);case"co":return localize.ordinalNumber(localDayOfWeek,{unit:"day"});case"ccc":return localize.day(dayOfWeek,{width:"abbreviated",context:"standalone"});case"ccccc":return localize.day(dayOfWeek,{width:"narrow",context:"standalone"});case"cccccc":return localize.day(dayOfWeek,{width:"short",context:"standalone"});default:return localize.day(dayOfWeek,{width:"wide",context:"standalone"})}},i:function(date,token,localize){var dayOfWeek=date.getUTCDay(),isoDayOfWeek=0===dayOfWeek?7:dayOfWeek;switch(token){case"i":return String(isoDayOfWeek);case"ii":return addLeadingZeros(isoDayOfWeek,token.length);case"io":return localize.ordinalNumber(isoDayOfWeek,{unit:"day"});case"iii":return localize.day(dayOfWeek,{width:"abbreviated",context:"formatting"});case"iiiii":return localize.day(dayOfWeek,{width:"narrow",context:"formatting"});case"iiiiii":return localize.day(dayOfWeek,{width:"short",context:"formatting"});default:return localize.day(dayOfWeek,{width:"wide",context:"formatting"})}},a:function(date,token,localize){var dayPeriodEnumValue=date.getUTCHours()/12>=1?"pm":"am";switch(token){case"a":case"aa":return localize.dayPeriod(dayPeriodEnumValue,{width:"abbreviated",context:"formatting"});case"aaa":return localize.dayPeriod(dayPeriodEnumValue,{width:"abbreviated",context:"formatting"}).toLowerCase();case"aaaaa":return localize.dayPeriod(dayPeriodEnumValue,{width:"narrow",context:"formatting"});default:return localize.dayPeriod(dayPeriodEnumValue,{width:"wide",context:"formatting"})}},b:function(date,token,localize){var dayPeriodEnumValue,hours=date.getUTCHours();switch(dayPeriodEnumValue=12===hours?dayPeriodEnum_noon:0===hours?dayPeriodEnum_midnight:hours/12>=1?"pm":"am",token){case"b":case"bb":return localize.dayPeriod(dayPeriodEnumValue,{width:"abbreviated",context:"formatting"});case"bbb":return localize.dayPeriod(dayPeriodEnumValue,{width:"abbreviated",context:"formatting"}).toLowerCase();case"bbbbb":return localize.dayPeriod(dayPeriodEnumValue,{width:"narrow",context:"formatting"});default:return localize.dayPeriod(dayPeriodEnumValue,{width:"wide",context:"formatting"})}},B:function(date,token,localize){var dayPeriodEnumValue,hours=date.getUTCHours();switch(dayPeriodEnumValue=hours>=17?dayPeriodEnum_evening:hours>=12?dayPeriodEnum_afternoon:hours>=4?dayPeriodEnum_morning:dayPeriodEnum_night,token){case"B":case"BB":case"BBB":return localize.dayPeriod(dayPeriodEnumValue,{width:"abbreviated",context:"formatting"});case"BBBBB":return localize.dayPeriod(dayPeriodEnumValue,{width:"narrow",context:"formatting"});default:return localize.dayPeriod(dayPeriodEnumValue,{width:"wide",context:"formatting"})}},h:function(date,token,localize){if("ho"===token){var hours=date.getUTCHours()%12;return 0===hours&&(hours=12),localize.ordinalNumber(hours,{unit:"hour"})}return formatters$1_h(date,token)},H:function(date,token,localize){return"Ho"===token?localize.ordinalNumber(date.getUTCHours(),{unit:"hour"}):formatters$1_H(date,token)},K:function(date,token,localize){var hours=date.getUTCHours()%12;return"Ko"===token?localize.ordinalNumber(hours,{unit:"hour"}):addLeadingZeros(hours,token.length)},k:function(date,token,localize){var hours=date.getUTCHours();return 0===hours&&(hours=24),"ko"===token?localize.ordinalNumber(hours,{unit:"hour"}):addLeadingZeros(hours,token.length)},m:function(date,token,localize){return"mo"===token?localize.ordinalNumber(date.getUTCMinutes(),{unit:"minute"}):formatters$1_m(date,token)},s:function(date,token,localize){return"so"===token?localize.ordinalNumber(date.getUTCSeconds(),{unit:"second"}):formatters$1_s(date,token)},S:function(date,token){return formatters$1_S(date,token)},X:function(date,token,_localize,options){var timezoneOffset=(options._originalDate||date).getTimezoneOffset();if(0===timezoneOffset)return"Z";switch(token){case"X":return formatTimezoneWithOptionalMinutes(timezoneOffset);case"XXXX":case"XX":return formatTimezone(timezoneOffset);default:return formatTimezone(timezoneOffset,":")}},x:function(date,token,_localize,options){var timezoneOffset=(options._originalDate||date).getTimezoneOffset();switch(token){case"x":return formatTimezoneWithOptionalMinutes(timezoneOffset);case"xxxx":case"xx":return formatTimezone(timezoneOffset);default:return formatTimezone(timezoneOffset,":")}},O:function(date,token,_localize,options){var timezoneOffset=(options._originalDate||date).getTimezoneOffset();switch(token){case"O":case"OO":case"OOO":return"GMT"+formatTimezoneShort(timezoneOffset,":");default:return"GMT"+formatTimezone(timezoneOffset,":")}},z:function(date,token,_localize,options){var timezoneOffset=(options._originalDate||date).getTimezoneOffset();switch(token){case"z":case"zz":case"zzz":return"GMT"+formatTimezoneShort(timezoneOffset,":");default:return"GMT"+formatTimezone(timezoneOffset,":")}},t:function(date,token,_localize,options){var originalDate=options._originalDate||date;return addLeadingZeros(Math.floor(originalDate.getTime()/1e3),token.length)},T:function(date,token,_localize,options){return addLeadingZeros((options._originalDate||date).getTime(),token.length)}};function formatTimezoneShort(offset,dirtyDelimiter){var sign=offset>0?"-":"+",absOffset=Math.abs(offset),hours=Math.floor(absOffset/60),minutes=absOffset%60;if(0===minutes)return sign+String(hours);var delimiter=dirtyDelimiter;return sign+String(hours)+delimiter+addLeadingZeros(minutes,2)}function formatTimezoneWithOptionalMinutes(offset,dirtyDelimiter){return offset%60==0?(offset>0?"-":"+")+addLeadingZeros(Math.abs(offset)/60,2):formatTimezone(offset,dirtyDelimiter)}function formatTimezone(offset,dirtyDelimiter){var delimiter=dirtyDelimiter||"",sign=offset>0?"-":"+",absOffset=Math.abs(offset);return sign+addLeadingZeros(Math.floor(absOffset/60),2)+delimiter+addLeadingZeros(absOffset%60,2)}var dateLongFormatter=function(pattern,formatLong){switch(pattern){case"P":return formatLong.date({width:"short"});case"PP":return formatLong.date({width:"medium"});case"PPP":return formatLong.date({width:"long"});default:return formatLong.date({width:"full"})}},timeLongFormatter=function(pattern,formatLong){switch(pattern){case"p":return formatLong.time({width:"short"});case"pp":return formatLong.time({width:"medium"});case"ppp":return formatLong.time({width:"long"});default:return formatLong.time({width:"full"})}},longFormatters={p:timeLongFormatter,P:function(pattern,formatLong){var dateTimeFormat,matchResult=pattern.match(/(P+)(p+)?/)||[],datePattern=matchResult[1],timePattern=matchResult[2];if(!timePattern)return dateLongFormatter(pattern,formatLong);switch(datePattern){case"P":dateTimeFormat=formatLong.dateTime({width:"short"});break;case"PP":dateTimeFormat=formatLong.dateTime({width:"medium"});break;case"PPP":dateTimeFormat=formatLong.dateTime({width:"long"});break;default:dateTimeFormat=formatLong.dateTime({width:"full"})}return dateTimeFormat.replace("{{date}}",dateLongFormatter(datePattern,formatLong)).replace("{{time}}",timeLongFormatter(timePattern,formatLong))}},protectedDayOfYearTokens=["D","DD"],protectedWeekYearTokens=["YY","YYYY"];function isProtectedDayOfYearToken(token){return-1!==protectedDayOfYearTokens.indexOf(token)}function isProtectedWeekYearToken(token){return-1!==protectedWeekYearTokens.indexOf(token)}function throwProtectedError(token,format,input){if("YYYY"===token)throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format,"`) for formatting years to the input `").concat(input,"`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));if("YY"===token)throw new RangeError("Use `yy` instead of `YY` (in `".concat(format,"`) for formatting years to the input `").concat(input,"`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));if("D"===token)throw new RangeError("Use `d` instead of `D` (in `".concat(format,"`) for formatting days of the month to the input `").concat(input,"`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));if("DD"===token)throw new RangeError("Use `dd` instead of `DD` (in `".concat(format,"`) for formatting days of the month to the input `").concat(input,"`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"))}var formattingTokensRegExp$1=/[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g,longFormattingTokensRegExp$1=/P+p+|P+|p+|''|'(''|[^'])+('|$)|./g,escapedStringRegExp$1=/^'([^]*?)'?$/,doubleQuoteRegExp$1=/''/g,unescapedLatinCharacterRegExp$1=/[a-zA-Z]/;function format(dirtyDate,dirtyFormatStr,options){var _ref,_options$locale,_ref2,_ref3,_ref4,_options$firstWeekCon,_options$locale2,_options$locale2$opti,_defaultOptions$local,_defaultOptions$local2,_ref5,_ref6,_ref7,_options$weekStartsOn,_options$locale3,_options$locale3$opti,_defaultOptions$local3,_defaultOptions$local4;requiredArgs(2,arguments);var formatStr=String(dirtyFormatStr),defaultOptions=getDefaultOptions(),locale$1=null!==(_ref=null!==(_options$locale=null==options?void 0:options.locale)&&void 0!==_options$locale?_options$locale:defaultOptions.locale)&&void 0!==_ref?_ref:locale,firstWeekContainsDate=toInteger(null!==(_ref2=null!==(_ref3=null!==(_ref4=null!==(_options$firstWeekCon=null==options?void 0:options.firstWeekContainsDate)&&void 0!==_options$firstWeekCon?_options$firstWeekCon:null==options||null===(_options$locale2=options.locale)||void 0===_options$locale2||null===(_options$locale2$opti=_options$locale2.options)||void 0===_options$locale2$opti?void 0:_options$locale2$opti.firstWeekContainsDate)&&void 0!==_ref4?_ref4:defaultOptions.firstWeekContainsDate)&&void 0!==_ref3?_ref3:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.firstWeekContainsDate)&&void 0!==_ref2?_ref2:1);if(!(firstWeekContainsDate>=1&&firstWeekContainsDate<=7))throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");var weekStartsOn=toInteger(null!==(_ref5=null!==(_ref6=null!==(_ref7=null!==(_options$weekStartsOn=null==options?void 0:options.weekStartsOn)&&void 0!==_options$weekStartsOn?_options$weekStartsOn:null==options||null===(_options$locale3=options.locale)||void 0===_options$locale3||null===(_options$locale3$opti=_options$locale3.options)||void 0===_options$locale3$opti?void 0:_options$locale3$opti.weekStartsOn)&&void 0!==_ref7?_ref7:defaultOptions.weekStartsOn)&&void 0!==_ref6?_ref6:null===(_defaultOptions$local3=defaultOptions.locale)||void 0===_defaultOptions$local3||null===(_defaultOptions$local4=_defaultOptions$local3.options)||void 0===_defaultOptions$local4?void 0:_defaultOptions$local4.weekStartsOn)&&void 0!==_ref5?_ref5:0);if(!(weekStartsOn>=0&&weekStartsOn<=6))throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");if(!locale$1.localize)throw new RangeError("locale must contain localize property");if(!locale$1.formatLong)throw new RangeError("locale must contain formatLong property");var originalDate=toDate(dirtyDate);if(!isValid(originalDate))throw new RangeError("Invalid time value");var utcDate=subMilliseconds(originalDate,getTimezoneOffsetInMilliseconds(originalDate)),formatterOptions={firstWeekContainsDate:firstWeekContainsDate,weekStartsOn:weekStartsOn,locale:locale$1,_originalDate:originalDate};return formatStr.match(longFormattingTokensRegExp$1).map((function(substring){var firstCharacter=substring[0];return"p"===firstCharacter||"P"===firstCharacter?(0,longFormatters[firstCharacter])(substring,locale$1.formatLong):substring})).join("").match(formattingTokensRegExp$1).map((function(substring){if("''"===substring)return"'";var firstCharacter=substring[0];if("'"===firstCharacter)return function(input){var matched=input.match(escapedStringRegExp$1);if(!matched)return input;return matched[1].replace(doubleQuoteRegExp$1,"'")}(substring);var formatter=formatters[firstCharacter];if(formatter)return null!=options&&options.useAdditionalWeekYearTokens||!isProtectedWeekYearToken(substring)||throwProtectedError(substring,dirtyFormatStr,String(dirtyDate)),null!=options&&options.useAdditionalDayOfYearTokens||!isProtectedDayOfYearToken(substring)||throwProtectedError(substring,dirtyFormatStr,String(dirtyDate)),formatter(utcDate,substring,locale$1.localize,formatterOptions);if(firstCharacter.match(unescapedLatinCharacterRegExp$1))throw new RangeError("Format string contains an unescaped latin alphabet character `"+firstCharacter+"`");return substring})).join("")}function assign(target,object){if(null==target)throw new TypeError("assign requires that input parameter not be null or undefined");for(var property in object)Object.prototype.hasOwnProperty.call(object,property)&&(target[property]=object[property]);return target}function _arrayLikeToArray(r,a){(null==a||a>r.length)&&(a=r.length);for(var e=0,n=Array(a);e<a;e++)n[e]=r[e];return n}function _createForOfIteratorHelper(r,e){var t="undefined"!=typeof Symbol&&r[Symbol.iterator]||r["@@iterator"];if(!t){if(Array.isArray(r)||(t=function(r,a){if(r){if("string"==typeof r)return _arrayLikeToArray(r,a);var t={}.toString.call(r).slice(8,-1);return"Object"===t&&r.constructor&&(t=r.constructor.name),"Map"===t||"Set"===t?Array.from(r):"Arguments"===t||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t)?_arrayLikeToArray(r,a):void 0}}(r))||e){t&&(r=t);var _n=0,F=function(){};return{s:F,n:function(){return _n>=r.length?{done:!0}:{done:!1,value:r[_n++]}},e:function(r){throw r},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,a=!0,u=!1;return{s:function(){t=t.call(r)},n:function(){var r=t.next();return a=r.done,r},e:function(r){u=!0,o=r},f:function(){try{a||null==t.return||t.return()}finally{if(u)throw o}}}}function _assertThisInitialized(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function _setPrototypeOf(t,e){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t},_setPrototypeOf(t,e)}function _inherits(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),Object.defineProperty(t,"prototype",{writable:!1}),e&&_setPrototypeOf(t,e)}function _getPrototypeOf(t){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(t){return t.__proto__||Object.getPrototypeOf(t)},_getPrototypeOf(t)}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(t){}return(_isNativeReflectConstruct=function(){return!!t})()}function _createSuper(t){var r=_isNativeReflectConstruct();return function(){var e,o=_getPrototypeOf(t);if(r){var s=_getPrototypeOf(this).constructor;e=Reflect.construct(o,arguments,s)}else e=o.apply(this,arguments);return function(t,e){if(e&&("object"==_typeof(e)||"function"==typeof e))return e;if(void 0!==e)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(t)}(this,e)}}function _classCallCheck(a,n){if(!(a instanceof n))throw new TypeError("Cannot call a class as a function")}function toPropertyKey(t){var i=function(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}(t,"string");return"symbol"==_typeof(i)?i:i+""}function _createClass(e,r,t){return r&&function(e,r){for(var t=0;t<r.length;t++){var o=r[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,toPropertyKey(o.key),o)}}(e.prototype,r),Object.defineProperty(e,"prototype",{writable:!1}),e}function _defineProperty(e,r,t){return(r=toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}var Setter=function(){function Setter(){_classCallCheck(this,Setter),_defineProperty(this,"priority",void 0),_defineProperty(this,"subPriority",0)}return _createClass(Setter,[{key:"validate",value:function(_utcDate,_options){return!0}}]),Setter}(),ValueSetter=function(){_inherits(ValueSetter,Setter);var _super=_createSuper(ValueSetter);function ValueSetter(value,validateValue,setValue,priority,subPriority){var _this;return _classCallCheck(this,ValueSetter),(_this=_super.call(this)).value=value,_this.validateValue=validateValue,_this.setValue=setValue,_this.priority=priority,subPriority&&(_this.subPriority=subPriority),_this}return _createClass(ValueSetter,[{key:"validate",value:function(utcDate,options){return this.validateValue(utcDate,this.value,options)}},{key:"set",value:function(utcDate,flags,options){return this.setValue(utcDate,flags,this.value,options)}}]),ValueSetter}(),DateToSystemTimezoneSetter=function(){_inherits(DateToSystemTimezoneSetter,Setter);var _super2=_createSuper(DateToSystemTimezoneSetter);function DateToSystemTimezoneSetter(){var _this2;_classCallCheck(this,DateToSystemTimezoneSetter);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this2=_super2.call.apply(_super2,[this].concat(args))),"priority",10),_defineProperty(_assertThisInitialized(_this2),"subPriority",-1),_this2}return _createClass(DateToSystemTimezoneSetter,[{key:"set",value:function(date,flags){if(flags.timestampIsSet)return date;var convertedDate=new Date(0);return convertedDate.setFullYear(date.getUTCFullYear(),date.getUTCMonth(),date.getUTCDate()),convertedDate.setHours(date.getUTCHours(),date.getUTCMinutes(),date.getUTCSeconds(),date.getUTCMilliseconds()),convertedDate}}]),DateToSystemTimezoneSetter}(),Parser=function(){function Parser(){_classCallCheck(this,Parser),_defineProperty(this,"incompatibleTokens",void 0),_defineProperty(this,"priority",void 0),_defineProperty(this,"subPriority",void 0)}return _createClass(Parser,[{key:"run",value:function(dateString,token,match,options){var result=this.parse(dateString,token,match,options);return result?{setter:new ValueSetter(result.value,this.validate,this.set,this.priority,this.subPriority),rest:result.rest}:null}},{key:"validate",value:function(_utcDate,_value,_options){return!0}}]),Parser}(),EraParser=function(){_inherits(EraParser,Parser);var _super=_createSuper(EraParser);function EraParser(){var _this;_classCallCheck(this,EraParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",140),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["R","u","t","T"]),_this}return _createClass(EraParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"G":case"GG":case"GGG":return match.era(dateString,{width:"abbreviated"})||match.era(dateString,{width:"narrow"});case"GGGGG":return match.era(dateString,{width:"narrow"});default:return match.era(dateString,{width:"wide"})||match.era(dateString,{width:"abbreviated"})||match.era(dateString,{width:"narrow"})}}},{key:"set",value:function(date,flags,value){return flags.era=value,date.setUTCFullYear(value,0,1),date.setUTCHours(0,0,0,0),date}}]),EraParser}(),numericPatterns_month=/^(1[0-2]|0?\d)/,numericPatterns_date=/^(3[0-1]|[0-2]?\d)/,numericPatterns_dayOfYear=/^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,numericPatterns_week=/^(5[0-3]|[0-4]?\d)/,numericPatterns_hour23h=/^(2[0-3]|[0-1]?\d)/,numericPatterns_hour24h=/^(2[0-4]|[0-1]?\d)/,numericPatterns_hour11h=/^(1[0-1]|0?\d)/,numericPatterns_hour12h=/^(1[0-2]|0?\d)/,numericPatterns_minute=/^[0-5]?\d/,numericPatterns_second=/^[0-5]?\d/,numericPatterns_singleDigit=/^\d/,numericPatterns_twoDigits=/^\d{1,2}/,numericPatterns_threeDigits=/^\d{1,3}/,numericPatterns_fourDigits=/^\d{1,4}/,numericPatterns_anyDigitsSigned=/^-?\d+/,numericPatterns_singleDigitSigned=/^-?\d/,numericPatterns_twoDigitsSigned=/^-?\d{1,2}/,numericPatterns_threeDigitsSigned=/^-?\d{1,3}/,numericPatterns_fourDigitsSigned=/^-?\d{1,4}/,timezonePatterns_basicOptionalMinutes=/^([+-])(\d{2})(\d{2})?|Z/,timezonePatterns_basic=/^([+-])(\d{2})(\d{2})|Z/,timezonePatterns_basicOptionalSeconds=/^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,timezonePatterns_extended=/^([+-])(\d{2}):(\d{2})|Z/,timezonePatterns_extendedOptionalSeconds=/^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/;function mapValue(parseFnResult,mapFn){return parseFnResult?{value:mapFn(parseFnResult.value),rest:parseFnResult.rest}:parseFnResult}function parseNumericPattern(pattern,dateString){var matchResult=dateString.match(pattern);return matchResult?{value:parseInt(matchResult[0],10),rest:dateString.slice(matchResult[0].length)}:null}function parseTimezonePattern(pattern,dateString){var matchResult=dateString.match(pattern);return matchResult?"Z"===matchResult[0]?{value:0,rest:dateString.slice(1)}:{value:("+"===matchResult[1]?1:-1)*(36e5*(matchResult[2]?parseInt(matchResult[2],10):0)+6e4*(matchResult[3]?parseInt(matchResult[3],10):0)+1e3*(matchResult[5]?parseInt(matchResult[5],10):0)),rest:dateString.slice(matchResult[0].length)}:null}function parseAnyDigitsSigned(dateString){return parseNumericPattern(numericPatterns_anyDigitsSigned,dateString)}function parseNDigits(n,dateString){switch(n){case 1:return parseNumericPattern(numericPatterns_singleDigit,dateString);case 2:return parseNumericPattern(numericPatterns_twoDigits,dateString);case 3:return parseNumericPattern(numericPatterns_threeDigits,dateString);case 4:return parseNumericPattern(numericPatterns_fourDigits,dateString);default:return parseNumericPattern(new RegExp("^\\d{1,"+n+"}"),dateString)}}function parseNDigitsSigned(n,dateString){switch(n){case 1:return parseNumericPattern(numericPatterns_singleDigitSigned,dateString);case 2:return parseNumericPattern(numericPatterns_twoDigitsSigned,dateString);case 3:return parseNumericPattern(numericPatterns_threeDigitsSigned,dateString);case 4:return parseNumericPattern(numericPatterns_fourDigitsSigned,dateString);default:return parseNumericPattern(new RegExp("^-?\\d{1,"+n+"}"),dateString)}}function dayPeriodEnumToHours(dayPeriod){switch(dayPeriod){case"morning":return 4;case"evening":return 17;case"pm":case"noon":case"afternoon":return 12;default:return 0}}function normalizeTwoDigitYear(twoDigitYear,currentYear){var result,isCommonEra=currentYear>0,absCurrentYear=isCommonEra?currentYear:1-currentYear;if(absCurrentYear<=50)result=twoDigitYear||100;else{var rangeEnd=absCurrentYear+50;result=twoDigitYear+100*Math.floor(rangeEnd/100)-(twoDigitYear>=rangeEnd%100?100:0)}return isCommonEra?result:1-result}function isLeapYearIndex(year){return year%400==0||year%4==0&&year%100!=0}var YearParser=function(){_inherits(YearParser,Parser);var _super=_createSuper(YearParser);function YearParser(){var _this;_classCallCheck(this,YearParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",130),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","u","w","I","i","e","c","t","T"]),_this}return _createClass(YearParser,[{key:"parse",value:function(dateString,token,match){var valueCallback=function(year){return{year:year,isTwoDigitYear:"yy"===token}};switch(token){case"y":return mapValue(parseNDigits(4,dateString),valueCallback);case"yo":return mapValue(match.ordinalNumber(dateString,{unit:"year"}),valueCallback);default:return mapValue(parseNDigits(token.length,dateString),valueCallback)}}},{key:"validate",value:function(_date,value){return value.isTwoDigitYear||value.year>0}},{key:"set",value:function(date,flags,value){var currentYear=date.getUTCFullYear();if(value.isTwoDigitYear){var normalizedTwoDigitYear=normalizeTwoDigitYear(value.year,currentYear);return date.setUTCFullYear(normalizedTwoDigitYear,0,1),date.setUTCHours(0,0,0,0),date}var year="era"in flags&&1!==flags.era?1-value.year:value.year;return date.setUTCFullYear(year,0,1),date.setUTCHours(0,0,0,0),date}}]),YearParser}(),LocalWeekYearParser=function(){_inherits(LocalWeekYearParser,Parser);var _super=_createSuper(LocalWeekYearParser);function LocalWeekYearParser(){var _this;_classCallCheck(this,LocalWeekYearParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",130),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","R","u","Q","q","M","L","I","d","D","i","t","T"]),_this}return _createClass(LocalWeekYearParser,[{key:"parse",value:function(dateString,token,match){var valueCallback=function(year){return{year:year,isTwoDigitYear:"YY"===token}};switch(token){case"Y":return mapValue(parseNDigits(4,dateString),valueCallback);case"Yo":return mapValue(match.ordinalNumber(dateString,{unit:"year"}),valueCallback);default:return mapValue(parseNDigits(token.length,dateString),valueCallback)}}},{key:"validate",value:function(_date,value){return value.isTwoDigitYear||value.year>0}},{key:"set",value:function(date,flags,value,options){var currentYear=getUTCWeekYear(date,options);if(value.isTwoDigitYear){var normalizedTwoDigitYear=normalizeTwoDigitYear(value.year,currentYear);return date.setUTCFullYear(normalizedTwoDigitYear,0,options.firstWeekContainsDate),date.setUTCHours(0,0,0,0),startOfUTCWeek(date,options)}var year="era"in flags&&1!==flags.era?1-value.year:value.year;return date.setUTCFullYear(year,0,options.firstWeekContainsDate),date.setUTCHours(0,0,0,0),startOfUTCWeek(date,options)}}]),LocalWeekYearParser}(),ISOWeekYearParser=function(){_inherits(ISOWeekYearParser,Parser);var _super=_createSuper(ISOWeekYearParser);function ISOWeekYearParser(){var _this;_classCallCheck(this,ISOWeekYearParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",130),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["G","y","Y","u","Q","q","M","L","w","d","D","e","c","t","T"]),_this}return _createClass(ISOWeekYearParser,[{key:"parse",value:function(dateString,token){return parseNDigitsSigned("R"===token?4:token.length,dateString)}},{key:"set",value:function(_date,_flags,value){var firstWeekOfYear=new Date(0);return firstWeekOfYear.setUTCFullYear(value,0,4),firstWeekOfYear.setUTCHours(0,0,0,0),startOfUTCISOWeek(firstWeekOfYear)}}]),ISOWeekYearParser}(),ExtendedYearParser=function(){_inherits(ExtendedYearParser,Parser);var _super=_createSuper(ExtendedYearParser);function ExtendedYearParser(){var _this;_classCallCheck(this,ExtendedYearParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",130),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["G","y","Y","R","w","I","i","e","c","t","T"]),_this}return _createClass(ExtendedYearParser,[{key:"parse",value:function(dateString,token){return parseNDigitsSigned("u"===token?4:token.length,dateString)}},{key:"set",value:function(date,_flags,value){return date.setUTCFullYear(value,0,1),date.setUTCHours(0,0,0,0),date}}]),ExtendedYearParser}(),QuarterParser=function(){_inherits(QuarterParser,Parser);var _super=_createSuper(QuarterParser);function QuarterParser(){var _this;_classCallCheck(this,QuarterParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",120),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","q","M","L","w","I","d","D","i","e","c","t","T"]),_this}return _createClass(QuarterParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"Q":case"QQ":return parseNDigits(token.length,dateString);case"Qo":return match.ordinalNumber(dateString,{unit:"quarter"});case"QQQ":return match.quarter(dateString,{width:"abbreviated",context:"formatting"})||match.quarter(dateString,{width:"narrow",context:"formatting"});case"QQQQQ":return match.quarter(dateString,{width:"narrow",context:"formatting"});default:return match.quarter(dateString,{width:"wide",context:"formatting"})||match.quarter(dateString,{width:"abbreviated",context:"formatting"})||match.quarter(dateString,{width:"narrow",context:"formatting"})}}},{key:"validate",value:function(_date,value){return value>=1&&value<=4}},{key:"set",value:function(date,_flags,value){return date.setUTCMonth(3*(value-1),1),date.setUTCHours(0,0,0,0),date}}]),QuarterParser}(),StandAloneQuarterParser=function(){_inherits(StandAloneQuarterParser,Parser);var _super=_createSuper(StandAloneQuarterParser);function StandAloneQuarterParser(){var _this;_classCallCheck(this,StandAloneQuarterParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",120),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","Q","M","L","w","I","d","D","i","e","c","t","T"]),_this}return _createClass(StandAloneQuarterParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"q":case"qq":return parseNDigits(token.length,dateString);case"qo":return match.ordinalNumber(dateString,{unit:"quarter"});case"qqq":return match.quarter(dateString,{width:"abbreviated",context:"standalone"})||match.quarter(dateString,{width:"narrow",context:"standalone"});case"qqqqq":return match.quarter(dateString,{width:"narrow",context:"standalone"});default:return match.quarter(dateString,{width:"wide",context:"standalone"})||match.quarter(dateString,{width:"abbreviated",context:"standalone"})||match.quarter(dateString,{width:"narrow",context:"standalone"})}}},{key:"validate",value:function(_date,value){return value>=1&&value<=4}},{key:"set",value:function(date,_flags,value){return date.setUTCMonth(3*(value-1),1),date.setUTCHours(0,0,0,0),date}}]),StandAloneQuarterParser}(),MonthParser=function(){_inherits(MonthParser,Parser);var _super=_createSuper(MonthParser);function MonthParser(){var _this;_classCallCheck(this,MonthParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"incompatibleTokens",["Y","R","q","Q","L","w","I","D","i","e","c","t","T"]),_defineProperty(_assertThisInitialized(_this),"priority",110),_this}return _createClass(MonthParser,[{key:"parse",value:function(dateString,token,match){var valueCallback=function(value){return value-1};switch(token){case"M":return mapValue(parseNumericPattern(numericPatterns_month,dateString),valueCallback);case"MM":return mapValue(parseNDigits(2,dateString),valueCallback);case"Mo":return mapValue(match.ordinalNumber(dateString,{unit:"month"}),valueCallback);case"MMM":return match.month(dateString,{width:"abbreviated",context:"formatting"})||match.month(dateString,{width:"narrow",context:"formatting"});case"MMMMM":return match.month(dateString,{width:"narrow",context:"formatting"});default:return match.month(dateString,{width:"wide",context:"formatting"})||match.month(dateString,{width:"abbreviated",context:"formatting"})||match.month(dateString,{width:"narrow",context:"formatting"})}}},{key:"validate",value:function(_date,value){return value>=0&&value<=11}},{key:"set",value:function(date,_flags,value){return date.setUTCMonth(value,1),date.setUTCHours(0,0,0,0),date}}]),MonthParser}(),StandAloneMonthParser=function(){_inherits(StandAloneMonthParser,Parser);var _super=_createSuper(StandAloneMonthParser);function StandAloneMonthParser(){var _this;_classCallCheck(this,StandAloneMonthParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",110),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","q","Q","M","w","I","D","i","e","c","t","T"]),_this}return _createClass(StandAloneMonthParser,[{key:"parse",value:function(dateString,token,match){var valueCallback=function(value){return value-1};switch(token){case"L":return mapValue(parseNumericPattern(numericPatterns_month,dateString),valueCallback);case"LL":return mapValue(parseNDigits(2,dateString),valueCallback);case"Lo":return mapValue(match.ordinalNumber(dateString,{unit:"month"}),valueCallback);case"LLL":return match.month(dateString,{width:"abbreviated",context:"standalone"})||match.month(dateString,{width:"narrow",context:"standalone"});case"LLLLL":return match.month(dateString,{width:"narrow",context:"standalone"});default:return match.month(dateString,{width:"wide",context:"standalone"})||match.month(dateString,{width:"abbreviated",context:"standalone"})||match.month(dateString,{width:"narrow",context:"standalone"})}}},{key:"validate",value:function(_date,value){return value>=0&&value<=11}},{key:"set",value:function(date,_flags,value){return date.setUTCMonth(value,1),date.setUTCHours(0,0,0,0),date}}]),StandAloneMonthParser}();var LocalWeekParser=function(){_inherits(LocalWeekParser,Parser);var _super=_createSuper(LocalWeekParser);function LocalWeekParser(){var _this;_classCallCheck(this,LocalWeekParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",100),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","R","u","q","Q","M","L","I","d","D","i","t","T"]),_this}return _createClass(LocalWeekParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"w":return parseNumericPattern(numericPatterns_week,dateString);case"wo":return match.ordinalNumber(dateString,{unit:"week"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=1&&value<=53}},{key:"set",value:function(date,_flags,value,options){return startOfUTCWeek(function(dirtyDate,dirtyWeek,options){requiredArgs(2,arguments);var date=toDate(dirtyDate),week=toInteger(dirtyWeek),diff=getUTCWeek(date,options)-week;return date.setUTCDate(date.getUTCDate()-7*diff),date}(date,value,options),options)}}]),LocalWeekParser}();var ISOWeekParser=function(){_inherits(ISOWeekParser,Parser);var _super=_createSuper(ISOWeekParser);function ISOWeekParser(){var _this;_classCallCheck(this,ISOWeekParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",100),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","Y","u","q","Q","M","L","w","d","D","e","c","t","T"]),_this}return _createClass(ISOWeekParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"I":return parseNumericPattern(numericPatterns_week,dateString);case"Io":return match.ordinalNumber(dateString,{unit:"week"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=1&&value<=53}},{key:"set",value:function(date,_flags,value){return startOfUTCISOWeek(function(dirtyDate,dirtyISOWeek){requiredArgs(2,arguments);var date=toDate(dirtyDate),isoWeek=toInteger(dirtyISOWeek),diff=getUTCISOWeek(date)-isoWeek;return date.setUTCDate(date.getUTCDate()-7*diff),date}(date,value))}}]),ISOWeekParser}(),DAYS_IN_MONTH=[31,28,31,30,31,30,31,31,30,31,30,31],DAYS_IN_MONTH_LEAP_YEAR=[31,29,31,30,31,30,31,31,30,31,30,31],DateParser=function(){_inherits(DateParser,Parser);var _super=_createSuper(DateParser);function DateParser(){var _this;_classCallCheck(this,DateParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"subPriority",1),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","q","Q","w","I","D","i","e","c","t","T"]),_this}return _createClass(DateParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"d":return parseNumericPattern(numericPatterns_date,dateString);case"do":return match.ordinalNumber(dateString,{unit:"date"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(date,value){var isLeapYear=isLeapYearIndex(date.getUTCFullYear()),month=date.getUTCMonth();return isLeapYear?value>=1&&value<=DAYS_IN_MONTH_LEAP_YEAR[month]:value>=1&&value<=DAYS_IN_MONTH[month]}},{key:"set",value:function(date,_flags,value){return date.setUTCDate(value),date.setUTCHours(0,0,0,0),date}}]),DateParser}(),DayOfYearParser=function(){_inherits(DayOfYearParser,Parser);var _super=_createSuper(DayOfYearParser);function DayOfYearParser(){var _this;_classCallCheck(this,DayOfYearParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"subpriority",1),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["Y","R","q","Q","M","L","w","I","d","E","i","e","c","t","T"]),_this}return _createClass(DayOfYearParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"D":case"DD":return parseNumericPattern(numericPatterns_dayOfYear,dateString);case"Do":return match.ordinalNumber(dateString,{unit:"date"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(date,value){return isLeapYearIndex(date.getUTCFullYear())?value>=1&&value<=366:value>=1&&value<=365}},{key:"set",value:function(date,_flags,value){return date.setUTCMonth(0,value),date.setUTCHours(0,0,0,0),date}}]),DayOfYearParser}();function setUTCDay(dirtyDate,dirtyDay,options){var _ref,_ref2,_ref3,_options$weekStartsOn,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(2,arguments);var defaultOptions=getDefaultOptions(),weekStartsOn=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$weekStartsOn=null==options?void 0:options.weekStartsOn)&&void 0!==_options$weekStartsOn?_options$weekStartsOn:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.weekStartsOn)&&void 0!==_ref3?_ref3:defaultOptions.weekStartsOn)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.weekStartsOn)&&void 0!==_ref?_ref:0);if(!(weekStartsOn>=0&&weekStartsOn<=6))throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");var date=toDate(dirtyDate),day=toInteger(dirtyDay),diff=((day%7+7)%7<weekStartsOn?7:0)+day-date.getUTCDay();return date.setUTCDate(date.getUTCDate()+diff),date}var DayParser=function(){_inherits(DayParser,Parser);var _super=_createSuper(DayParser);function DayParser(){var _this;_classCallCheck(this,DayParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["D","i","e","c","t","T"]),_this}return _createClass(DayParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"E":case"EE":case"EEE":return match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"});case"EEEEE":return match.day(dateString,{width:"narrow",context:"formatting"});case"EEEEEE":return match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"});default:return match.day(dateString,{width:"wide",context:"formatting"})||match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"})}}},{key:"validate",value:function(_date,value){return value>=0&&value<=6}},{key:"set",value:function(date,_flags,value,options){return(date=setUTCDay(date,value,options)).setUTCHours(0,0,0,0),date}}]),DayParser}(),LocalDayParser=function(){_inherits(LocalDayParser,Parser);var _super=_createSuper(LocalDayParser);function LocalDayParser(){var _this;_classCallCheck(this,LocalDayParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","R","u","q","Q","M","L","I","d","D","E","i","c","t","T"]),_this}return _createClass(LocalDayParser,[{key:"parse",value:function(dateString,token,match,options){var valueCallback=function(value){var wholeWeekDays=7*Math.floor((value-1)/7);return(value+options.weekStartsOn+6)%7+wholeWeekDays};switch(token){case"e":case"ee":return mapValue(parseNDigits(token.length,dateString),valueCallback);case"eo":return mapValue(match.ordinalNumber(dateString,{unit:"day"}),valueCallback);case"eee":return match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"});case"eeeee":return match.day(dateString,{width:"narrow",context:"formatting"});case"eeeeee":return match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"});default:return match.day(dateString,{width:"wide",context:"formatting"})||match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"})}}},{key:"validate",value:function(_date,value){return value>=0&&value<=6}},{key:"set",value:function(date,_flags,value,options){return(date=setUTCDay(date,value,options)).setUTCHours(0,0,0,0),date}}]),LocalDayParser}(),StandAloneLocalDayParser=function(){_inherits(StandAloneLocalDayParser,Parser);var _super=_createSuper(StandAloneLocalDayParser);function StandAloneLocalDayParser(){var _this;_classCallCheck(this,StandAloneLocalDayParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","R","u","q","Q","M","L","I","d","D","E","i","e","t","T"]),_this}return _createClass(StandAloneLocalDayParser,[{key:"parse",value:function(dateString,token,match,options){var valueCallback=function(value){var wholeWeekDays=7*Math.floor((value-1)/7);return(value+options.weekStartsOn+6)%7+wholeWeekDays};switch(token){case"c":case"cc":return mapValue(parseNDigits(token.length,dateString),valueCallback);case"co":return mapValue(match.ordinalNumber(dateString,{unit:"day"}),valueCallback);case"ccc":return match.day(dateString,{width:"abbreviated",context:"standalone"})||match.day(dateString,{width:"short",context:"standalone"})||match.day(dateString,{width:"narrow",context:"standalone"});case"ccccc":return match.day(dateString,{width:"narrow",context:"standalone"});case"cccccc":return match.day(dateString,{width:"short",context:"standalone"})||match.day(dateString,{width:"narrow",context:"standalone"});default:return match.day(dateString,{width:"wide",context:"standalone"})||match.day(dateString,{width:"abbreviated",context:"standalone"})||match.day(dateString,{width:"short",context:"standalone"})||match.day(dateString,{width:"narrow",context:"standalone"})}}},{key:"validate",value:function(_date,value){return value>=0&&value<=6}},{key:"set",value:function(date,_flags,value,options){return(date=setUTCDay(date,value,options)).setUTCHours(0,0,0,0),date}}]),StandAloneLocalDayParser}();var ISODayParser=function(){_inherits(ISODayParser,Parser);var _super=_createSuper(ISODayParser);function ISODayParser(){var _this;_classCallCheck(this,ISODayParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",90),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["y","Y","u","q","Q","M","L","w","d","D","E","e","c","t","T"]),_this}return _createClass(ISODayParser,[{key:"parse",value:function(dateString,token,match){var valueCallback=function(value){return 0===value?7:value};switch(token){case"i":case"ii":return parseNDigits(token.length,dateString);case"io":return match.ordinalNumber(dateString,{unit:"day"});case"iii":return mapValue(match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"}),valueCallback);case"iiiii":return mapValue(match.day(dateString,{width:"narrow",context:"formatting"}),valueCallback);case"iiiiii":return mapValue(match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"}),valueCallback);default:return mapValue(match.day(dateString,{width:"wide",context:"formatting"})||match.day(dateString,{width:"abbreviated",context:"formatting"})||match.day(dateString,{width:"short",context:"formatting"})||match.day(dateString,{width:"narrow",context:"formatting"}),valueCallback)}}},{key:"validate",value:function(_date,value){return value>=1&&value<=7}},{key:"set",value:function(date,_flags,value){return date=function(dirtyDate,dirtyDay){requiredArgs(2,arguments);var day=toInteger(dirtyDay);day%7==0&&(day-=7);var date=toDate(dirtyDate),diff=((day%7+7)%7<1?7:0)+day-date.getUTCDay();return date.setUTCDate(date.getUTCDate()+diff),date}(date,value),date.setUTCHours(0,0,0,0),date}}]),ISODayParser}(),AMPMParser=function(){_inherits(AMPMParser,Parser);var _super=_createSuper(AMPMParser);function AMPMParser(){var _this;_classCallCheck(this,AMPMParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",80),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["b","B","H","k","t","T"]),_this}return _createClass(AMPMParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"a":case"aa":case"aaa":return match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"});case"aaaaa":return match.dayPeriod(dateString,{width:"narrow",context:"formatting"});default:return match.dayPeriod(dateString,{width:"wide",context:"formatting"})||match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"})}}},{key:"set",value:function(date,_flags,value){return date.setUTCHours(dayPeriodEnumToHours(value),0,0,0),date}}]),AMPMParser}(),AMPMMidnightParser=function(){_inherits(AMPMMidnightParser,Parser);var _super=_createSuper(AMPMMidnightParser);function AMPMMidnightParser(){var _this;_classCallCheck(this,AMPMMidnightParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",80),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["a","B","H","k","t","T"]),_this}return _createClass(AMPMMidnightParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"b":case"bb":case"bbb":return match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"});case"bbbbb":return match.dayPeriod(dateString,{width:"narrow",context:"formatting"});default:return match.dayPeriod(dateString,{width:"wide",context:"formatting"})||match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"})}}},{key:"set",value:function(date,_flags,value){return date.setUTCHours(dayPeriodEnumToHours(value),0,0,0),date}}]),AMPMMidnightParser}(),DayPeriodParser=function(){_inherits(DayPeriodParser,Parser);var _super=_createSuper(DayPeriodParser);function DayPeriodParser(){var _this;_classCallCheck(this,DayPeriodParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",80),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["a","b","t","T"]),_this}return _createClass(DayPeriodParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"B":case"BB":case"BBB":return match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"});case"BBBBB":return match.dayPeriod(dateString,{width:"narrow",context:"formatting"});default:return match.dayPeriod(dateString,{width:"wide",context:"formatting"})||match.dayPeriod(dateString,{width:"abbreviated",context:"formatting"})||match.dayPeriod(dateString,{width:"narrow",context:"formatting"})}}},{key:"set",value:function(date,_flags,value){return date.setUTCHours(dayPeriodEnumToHours(value),0,0,0),date}}]),DayPeriodParser}(),Hour1to12Parser=function(){_inherits(Hour1to12Parser,Parser);var _super=_createSuper(Hour1to12Parser);function Hour1to12Parser(){var _this;_classCallCheck(this,Hour1to12Parser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",70),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["H","K","k","t","T"]),_this}return _createClass(Hour1to12Parser,[{key:"parse",value:function(dateString,token,match){switch(token){case"h":return parseNumericPattern(numericPatterns_hour12h,dateString);case"ho":return match.ordinalNumber(dateString,{unit:"hour"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=1&&value<=12}},{key:"set",value:function(date,_flags,value){var isPM=date.getUTCHours()>=12;return isPM&&value<12?date.setUTCHours(value+12,0,0,0):isPM||12!==value?date.setUTCHours(value,0,0,0):date.setUTCHours(0,0,0,0),date}}]),Hour1to12Parser}(),Hour0to23Parser=function(){_inherits(Hour0to23Parser,Parser);var _super=_createSuper(Hour0to23Parser);function Hour0to23Parser(){var _this;_classCallCheck(this,Hour0to23Parser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",70),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["a","b","h","K","k","t","T"]),_this}return _createClass(Hour0to23Parser,[{key:"parse",value:function(dateString,token,match){switch(token){case"H":return parseNumericPattern(numericPatterns_hour23h,dateString);case"Ho":return match.ordinalNumber(dateString,{unit:"hour"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=0&&value<=23}},{key:"set",value:function(date,_flags,value){return date.setUTCHours(value,0,0,0),date}}]),Hour0to23Parser}(),Hour0To11Parser=function(){_inherits(Hour0To11Parser,Parser);var _super=_createSuper(Hour0To11Parser);function Hour0To11Parser(){var _this;_classCallCheck(this,Hour0To11Parser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",70),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["h","H","k","t","T"]),_this}return _createClass(Hour0To11Parser,[{key:"parse",value:function(dateString,token,match){switch(token){case"K":return parseNumericPattern(numericPatterns_hour11h,dateString);case"Ko":return match.ordinalNumber(dateString,{unit:"hour"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=0&&value<=11}},{key:"set",value:function(date,_flags,value){return date.getUTCHours()>=12&&value<12?date.setUTCHours(value+12,0,0,0):date.setUTCHours(value,0,0,0),date}}]),Hour0To11Parser}(),Hour1To24Parser=function(){_inherits(Hour1To24Parser,Parser);var _super=_createSuper(Hour1To24Parser);function Hour1To24Parser(){var _this;_classCallCheck(this,Hour1To24Parser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",70),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["a","b","h","H","K","t","T"]),_this}return _createClass(Hour1To24Parser,[{key:"parse",value:function(dateString,token,match){switch(token){case"k":return parseNumericPattern(numericPatterns_hour24h,dateString);case"ko":return match.ordinalNumber(dateString,{unit:"hour"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=1&&value<=24}},{key:"set",value:function(date,_flags,value){var hours=value<=24?value%24:value;return date.setUTCHours(hours,0,0,0),date}}]),Hour1To24Parser}(),MinuteParser=function(){_inherits(MinuteParser,Parser);var _super=_createSuper(MinuteParser);function MinuteParser(){var _this;_classCallCheck(this,MinuteParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",60),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["t","T"]),_this}return _createClass(MinuteParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"m":return parseNumericPattern(numericPatterns_minute,dateString);case"mo":return match.ordinalNumber(dateString,{unit:"minute"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=0&&value<=59}},{key:"set",value:function(date,_flags,value){return date.setUTCMinutes(value,0,0),date}}]),MinuteParser}(),SecondParser=function(){_inherits(SecondParser,Parser);var _super=_createSuper(SecondParser);function SecondParser(){var _this;_classCallCheck(this,SecondParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",50),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["t","T"]),_this}return _createClass(SecondParser,[{key:"parse",value:function(dateString,token,match){switch(token){case"s":return parseNumericPattern(numericPatterns_second,dateString);case"so":return match.ordinalNumber(dateString,{unit:"second"});default:return parseNDigits(token.length,dateString)}}},{key:"validate",value:function(_date,value){return value>=0&&value<=59}},{key:"set",value:function(date,_flags,value){return date.setUTCSeconds(value,0),date}}]),SecondParser}(),FractionOfSecondParser=function(){_inherits(FractionOfSecondParser,Parser);var _super=_createSuper(FractionOfSecondParser);function FractionOfSecondParser(){var _this;_classCallCheck(this,FractionOfSecondParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",30),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["t","T"]),_this}return _createClass(FractionOfSecondParser,[{key:"parse",value:function(dateString,token){return mapValue(parseNDigits(token.length,dateString),(function(value){return Math.floor(value*Math.pow(10,3-token.length))}))}},{key:"set",value:function(date,_flags,value){return date.setUTCMilliseconds(value),date}}]),FractionOfSecondParser}(),ISOTimezoneWithZParser=function(){_inherits(ISOTimezoneWithZParser,Parser);var _super=_createSuper(ISOTimezoneWithZParser);function ISOTimezoneWithZParser(){var _this;_classCallCheck(this,ISOTimezoneWithZParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",10),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["t","T","x"]),_this}return _createClass(ISOTimezoneWithZParser,[{key:"parse",value:function(dateString,token){switch(token){case"X":return parseTimezonePattern(timezonePatterns_basicOptionalMinutes,dateString);case"XX":return parseTimezonePattern(timezonePatterns_basic,dateString);case"XXXX":return parseTimezonePattern(timezonePatterns_basicOptionalSeconds,dateString);case"XXXXX":return parseTimezonePattern(timezonePatterns_extendedOptionalSeconds,dateString);default:return parseTimezonePattern(timezonePatterns_extended,dateString)}}},{key:"set",value:function(date,flags,value){return flags.timestampIsSet?date:new Date(date.getTime()-value)}}]),ISOTimezoneWithZParser}(),ISOTimezoneParser=function(){_inherits(ISOTimezoneParser,Parser);var _super=_createSuper(ISOTimezoneParser);function ISOTimezoneParser(){var _this;_classCallCheck(this,ISOTimezoneParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",10),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens",["t","T","X"]),_this}return _createClass(ISOTimezoneParser,[{key:"parse",value:function(dateString,token){switch(token){case"x":return parseTimezonePattern(timezonePatterns_basicOptionalMinutes,dateString);case"xx":return parseTimezonePattern(timezonePatterns_basic,dateString);case"xxxx":return parseTimezonePattern(timezonePatterns_basicOptionalSeconds,dateString);case"xxxxx":return parseTimezonePattern(timezonePatterns_extendedOptionalSeconds,dateString);default:return parseTimezonePattern(timezonePatterns_extended,dateString)}}},{key:"set",value:function(date,flags,value){return flags.timestampIsSet?date:new Date(date.getTime()-value)}}]),ISOTimezoneParser}(),TimestampSecondsParser=function(){_inherits(TimestampSecondsParser,Parser);var _super=_createSuper(TimestampSecondsParser);function TimestampSecondsParser(){var _this;_classCallCheck(this,TimestampSecondsParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",40),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens","*"),_this}return _createClass(TimestampSecondsParser,[{key:"parse",value:function(dateString){return parseAnyDigitsSigned(dateString)}},{key:"set",value:function(_date,_flags,value){return[new Date(1e3*value),{timestampIsSet:!0}]}}]),TimestampSecondsParser}(),TimestampMillisecondsParser=function(){_inherits(TimestampMillisecondsParser,Parser);var _super=_createSuper(TimestampMillisecondsParser);function TimestampMillisecondsParser(){var _this;_classCallCheck(this,TimestampMillisecondsParser);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return _defineProperty(_assertThisInitialized(_this=_super.call.apply(_super,[this].concat(args))),"priority",20),_defineProperty(_assertThisInitialized(_this),"incompatibleTokens","*"),_this}return _createClass(TimestampMillisecondsParser,[{key:"parse",value:function(dateString){return parseAnyDigitsSigned(dateString)}},{key:"set",value:function(_date,_flags,value){return[new Date(value),{timestampIsSet:!0}]}}]),TimestampMillisecondsParser}(),parsers={G:new EraParser,y:new YearParser,Y:new LocalWeekYearParser,R:new ISOWeekYearParser,u:new ExtendedYearParser,Q:new QuarterParser,q:new StandAloneQuarterParser,M:new MonthParser,L:new StandAloneMonthParser,w:new LocalWeekParser,I:new ISOWeekParser,d:new DateParser,D:new DayOfYearParser,E:new DayParser,e:new LocalDayParser,c:new StandAloneLocalDayParser,i:new ISODayParser,a:new AMPMParser,b:new AMPMMidnightParser,B:new DayPeriodParser,h:new Hour1to12Parser,H:new Hour0to23Parser,K:new Hour0To11Parser,k:new Hour1To24Parser,m:new MinuteParser,s:new SecondParser,S:new FractionOfSecondParser,X:new ISOTimezoneWithZParser,x:new ISOTimezoneParser,t:new TimestampSecondsParser,T:new TimestampMillisecondsParser},formattingTokensRegExp=/[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g,longFormattingTokensRegExp=/P+p+|P+|p+|''|'(''|[^'])+('|$)|./g,escapedStringRegExp=/^'([^]*?)'?$/,doubleQuoteRegExp=/''/g,notWhitespaceRegExp=/\S/,unescapedLatinCharacterRegExp=/[a-zA-Z]/;function parse(dirtyDateString,dirtyFormatString,dirtyReferenceDate,options){var _ref,_options$locale,_ref2,_ref3,_ref4,_options$firstWeekCon,_options$locale2,_options$locale2$opti,_defaultOptions$local,_defaultOptions$local2,_ref5,_ref6,_ref7,_options$weekStartsOn,_options$locale3,_options$locale3$opti,_defaultOptions$local3,_defaultOptions$local4;requiredArgs(3,arguments);var dateString=String(dirtyDateString),formatString=String(dirtyFormatString),defaultOptions=getDefaultOptions(),locale$1=null!==(_ref=null!==(_options$locale=null==options?void 0:options.locale)&&void 0!==_options$locale?_options$locale:defaultOptions.locale)&&void 0!==_ref?_ref:locale;if(!locale$1.match)throw new RangeError("locale must contain match property");var firstWeekContainsDate=toInteger(null!==(_ref2=null!==(_ref3=null!==(_ref4=null!==(_options$firstWeekCon=null==options?void 0:options.firstWeekContainsDate)&&void 0!==_options$firstWeekCon?_options$firstWeekCon:null==options||null===(_options$locale2=options.locale)||void 0===_options$locale2||null===(_options$locale2$opti=_options$locale2.options)||void 0===_options$locale2$opti?void 0:_options$locale2$opti.firstWeekContainsDate)&&void 0!==_ref4?_ref4:defaultOptions.firstWeekContainsDate)&&void 0!==_ref3?_ref3:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.firstWeekContainsDate)&&void 0!==_ref2?_ref2:1);if(!(firstWeekContainsDate>=1&&firstWeekContainsDate<=7))throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");var weekStartsOn=toInteger(null!==(_ref5=null!==(_ref6=null!==(_ref7=null!==(_options$weekStartsOn=null==options?void 0:options.weekStartsOn)&&void 0!==_options$weekStartsOn?_options$weekStartsOn:null==options||null===(_options$locale3=options.locale)||void 0===_options$locale3||null===(_options$locale3$opti=_options$locale3.options)||void 0===_options$locale3$opti?void 0:_options$locale3$opti.weekStartsOn)&&void 0!==_ref7?_ref7:defaultOptions.weekStartsOn)&&void 0!==_ref6?_ref6:null===(_defaultOptions$local3=defaultOptions.locale)||void 0===_defaultOptions$local3||null===(_defaultOptions$local4=_defaultOptions$local3.options)||void 0===_defaultOptions$local4?void 0:_defaultOptions$local4.weekStartsOn)&&void 0!==_ref5?_ref5:0);if(!(weekStartsOn>=0&&weekStartsOn<=6))throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");if(""===formatString)return""===dateString?toDate(dirtyReferenceDate):new Date(NaN);var _step,subFnOptions={firstWeekContainsDate:firstWeekContainsDate,weekStartsOn:weekStartsOn,locale:locale$1},setters=[new DateToSystemTimezoneSetter],tokens=formatString.match(longFormattingTokensRegExp).map((function(substring){var firstCharacter=substring[0];return firstCharacter in longFormatters?(0,longFormatters[firstCharacter])(substring,locale$1.formatLong):substring})).join("").match(formattingTokensRegExp),usedTokens=[],_iterator=_createForOfIteratorHelper(tokens);try{var _loop=function(){var token=_step.value;null!=options&&options.useAdditionalWeekYearTokens||!isProtectedWeekYearToken(token)||throwProtectedError(token,formatString,dirtyDateString),null!=options&&options.useAdditionalDayOfYearTokens||!isProtectedDayOfYearToken(token)||throwProtectedError(token,formatString,dirtyDateString);var firstCharacter=token[0],parser=parsers[firstCharacter];if(parser){var incompatibleTokens=parser.incompatibleTokens;if(Array.isArray(incompatibleTokens)){var incompatibleToken=usedTokens.find((function(usedToken){return incompatibleTokens.includes(usedToken.token)||usedToken.token===firstCharacter}));if(incompatibleToken)throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken,"` and `").concat(token,"` at the same time"))}else if("*"===parser.incompatibleTokens&&usedTokens.length>0)throw new RangeError("The format string mustn't contain `".concat(token,"` and any other token at the same time"));usedTokens.push({token:firstCharacter,fullToken:token});var parseResult=parser.run(dateString,token,locale$1.match,subFnOptions);if(!parseResult)return{v:new Date(NaN)};options.mxBuddhistCalendar&&["y","Y"].includes(firstCharacter)&&(parseResult.setter.value.year-=543),setters.push(parseResult.setter),dateString=parseResult.rest}else{if(firstCharacter.match(unescapedLatinCharacterRegExp))throw new RangeError("Format string contains an unescaped latin alphabet character `"+firstCharacter+"`");if("''"===token?token="'":"'"===firstCharacter&&(token=token.match(escapedStringRegExp)[1].replace(doubleQuoteRegExp,"'")),0!==dateString.indexOf(token))return{v:new Date(NaN)};dateString=dateString.slice(token.length)}};for(_iterator.s();!(_step=_iterator.n()).done;){var _ret=_loop();if("object"===_typeof(_ret))return _ret.v}}catch(err){_iterator.e(err)}finally{_iterator.f()}if(dateString.length>0&&notWhitespaceRegExp.test(dateString))return new Date(NaN);var uniquePrioritySetters=setters.map((function(setter){return setter.priority})).sort((function(a,b){return b-a})).filter((function(priority,index,array){return array.indexOf(priority)===index})).map((function(priority){return setters.filter((function(setter){return setter.priority===priority})).sort((function(a,b){return b.subPriority-a.subPriority}))})).map((function(setterArray){return setterArray[0]})),date=toDate(dirtyReferenceDate);if(isNaN(date.getTime()))return new Date(NaN);var _step2,utcDate=subMilliseconds(date,getTimezoneOffsetInMilliseconds(date)),flags={},_iterator2=_createForOfIteratorHelper(uniquePrioritySetters);try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var setter=_step2.value;if(!setter.validate(utcDate,subFnOptions))return new Date(NaN);var result=setter.set(utcDate,flags,subFnOptions);Array.isArray(result)?(utcDate=result[0],assign(flags,result[1])):utcDate=result}}catch(err){_iterator2.e(err)}finally{_iterator2.f()}return utcDate}function toDateFnsPattern(mendixPattern){return replaceSymbols(mendixPattern,[{existing:"yyy",replacement:"yyyy"},{existing:"E",replacement:"e"},{existing:"EE",replacement:"ee"},{existing:"YYY",replacement:"YYYY"},{existing:"Z",replacement:"XX"},{existing:"ZZ",replacement:"XX"},{existing:"ZZZ",replacement:"XX"},{existing:"ZZZZ",replacement:"zzzz"}])}function toMendixPattern(runtimePattern){return replaceSymbols(runtimePattern,[{existing:"GGGG",replacement:"GGG"},{existing:"GGGGG",replacement:"GGG"},{existing:"GGGGGG",replacement:"GGG"},{existing:"MMMMM",replacement:"MMMM"},{existing:"E",replacement:"EEE"},{existing:"EE",replacement:"EEE"},{existing:"EEEEE",replacement:"EEEE"},{existing:"EEEEEE",replacement:"EEEE"},{existing:"S",replacement:"SSS"},{existing:"SS",replacement:"SSS"},{existing:"SSSS",replacement:"'0'SSS"},{existing:"SSSSS",replacement:"'00'SSS"},{existing:"SSSSSS",replacement:"'000'SSS"},{existing:"W",replacement:"'W'"},{existing:"WW",replacement:"'WW'"},{existing:"WWW",replacement:"'WWW'"},{existing:"WWWW",replacement:"'WWWW'"},{existing:"WWWWW",replacement:"'WWWWW'"},{existing:"WWWWWW",replacement:"'WWWWWW'"},{existing:"F",replacement:"'F'"},{existing:"FF",replacement:"'FF'"},{existing:"FFF",replacement:"'FFF'"},{existing:"FFFF",replacement:"'FFFF'"},{existing:"FFFFF",replacement:"'FFFFF'"},{existing:"FFFFFF",replacement:"'FFFFFF'"},{existing:"Z",replacement:"'Z'"},{existing:"ZZ",replacement:"'ZZ'"},{existing:"ZZZ",replacement:"'ZZZ'"},{existing:"ZZZZ",replacement:"'ZZZZ'"},{existing:"ZZZZZ",replacement:"'ZZZZZ'"},{existing:"ZZZZZZ",replacement:"'ZZZZZZ'"},{existing:"z",replacement:"'z'"},{existing:"zz",replacement:"'zz'"},{existing:"zzz",replacement:"'zzz'"},{existing:"zzzz",replacement:"'zzzz'"},{existing:"zzzzz",replacement:"'zzzzz'"},{existing:"zzzzzz",replacement:"'zzzzzz'"},{existing:"X",replacement:"'X'"},{existing:"XX",replacement:"'XX'"},{existing:"XXX",replacement:"'XXX'"},{existing:"XXXX",replacement:"'XXXX'"},{existing:"XXXXX",replacement:"'XXXXX'"},{existing:"XXXXXX",replacement:"'XXXXXX'"}])}function replaceSymbols(haystack,symbols){const result=haystack.match(/''|'(?:''|[^'])+(?:'|$)|(.)\1*/g)??[];return symbols.reduce(((symbolGroups,{existing:existing,replacement:replacement})=>symbolGroups.map((value=>value===existing?replacement:value))),result).join("")}function shouldUseBuddhistCalendar(languageTag){return/th$/i.test(languageTag)}function preformatBuddhistCalendar(locale,date,pattern){const year=function(dirtyDate){return requiredArgs(1,arguments),toDate(dirtyDate).getFullYear()}(date)+543,weekYear=function(dirtyDate,options){var _ref,_ref2,_ref3,_options$firstWeekCon,_options$locale,_options$locale$optio,_defaultOptions$local,_defaultOptions$local2;requiredArgs(1,arguments);var date=toDate(dirtyDate),year=date.getFullYear(),defaultOptions=getDefaultOptions(),firstWeekContainsDate=toInteger(null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_options$firstWeekCon=null==options?void 0:options.firstWeekContainsDate)&&void 0!==_options$firstWeekCon?_options$firstWeekCon:null==options||null===(_options$locale=options.locale)||void 0===_options$locale||null===(_options$locale$optio=_options$locale.options)||void 0===_options$locale$optio?void 0:_options$locale$optio.firstWeekContainsDate)&&void 0!==_ref3?_ref3:defaultOptions.firstWeekContainsDate)&&void 0!==_ref2?_ref2:null===(_defaultOptions$local=defaultOptions.locale)||void 0===_defaultOptions$local||null===(_defaultOptions$local2=_defaultOptions$local.options)||void 0===_defaultOptions$local2?void 0:_defaultOptions$local2.firstWeekContainsDate)&&void 0!==_ref?_ref:1);if(!(firstWeekContainsDate>=1&&firstWeekContainsDate<=7))throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");var firstWeekOfNextYear=new Date(0);firstWeekOfNextYear.setFullYear(year+1,0,firstWeekContainsDate),firstWeekOfNextYear.setHours(0,0,0,0);var startOfNextYear=startOfWeek(firstWeekOfNextYear,options),firstWeekOfThisYear=new Date(0);firstWeekOfThisYear.setFullYear(year,0,firstWeekContainsDate),firstWeekOfThisYear.setHours(0,0,0,0);var startOfThisYear=startOfWeek(firstWeekOfThisYear,options);return date.getTime()>=startOfNextYear.getTime()?year+1:date.getTime()>=startOfThisYear.getTime()?year:year-1}(date,{locale:locale})+543;return replaceSymbols(pattern,[{existing:"yy",replacement:`'${twoDigit(year)}'`},{existing:"yyyy",replacement:`'${year}'`},{existing:"YY",replacement:`  ${twoDigit(weekYear)}'`},{existing:"YYYY",replacement:`'${weekYear}'`}])}function twoDigit(year){return year.toString().slice(-2)}function formatDate(date,formatterConfig){let pattern=toDateFnsPattern(getDateTimePattern(formatterConfig));if(shouldUseBuddhistCalendar(getLocale().languageTag)&&(pattern=preformatBuddhistCalendar(getDateFnsLocale(),date,pattern)),pattern.includes("u")){const{startIndex:startIndex,endIndex:endIndex,convertedPattern:convertedPattern}=convertDayOfWeekPattern(pattern),formattedDate=format(date,convertedPattern,getDateFnsOptions());return formattedDate.slice(0,startIndex)+"0".repeat(endIndex-startIndex)+formattedDate.slice(startIndex)}return format(date,pattern,getDateFnsOptions())}function parseDate(value,formatterConfig,fallbackDate=new Date){const datePattern=toDateFnsPattern(getDateTimePattern(formatterConfig)),options={...getDateFnsOptions(),mxBuddhistCalendar:shouldUseBuddhistCalendar(getLocale().languageTag)},twoDigitYearPattern=replaceSymbols(datePattern,[{existing:"yyyy",replacement:"yy"}]),patterns=[twoDigitYearPattern,datePattern,replaceNonBreakingSpaces(datePattern),replaceNonBreakingSpaces(twoDigitYearPattern)];for(const pattern of patterns){const{startIndex:startIndex,endIndex:endIndex,convertedPattern:convertedPattern}=convertDayOfWeekPattern(pattern),convertedPatternMatchingValue=value.slice(0,startIndex)+value.slice(endIndex);try{const date=parse(convertedPatternMatchingValue,convertedPattern,fallbackDate,options);if(!isNaN(date.getTime()))return date}catch{continue}}try{const timestamp=Date.parse(value);if(!isNaN(timestamp))return new Date(value)}catch{return}}function replaceNonBreakingSpaces(s){return s.replace(" "," ").replace(" "," ").replace(" "," ")}function getDateTimePattern(formatterConfig={type:"datetime"}){return"custom"!==formatterConfig.type?getLocale().patterns[formatterConfig.type]:formatterConfig.pattern}function getDateFormatPlaceholder(formatterConfig){return getDateTimePattern(formatterConfig).replace(/('.*?(?:'|$))|(\w)+/g,((match,group1,group2)=>group1?"''"===group1?"'":group1.replace(/'/g,""):"a"===group2?getLocale().dates.dayPeriods.join("/"):match.toLowerCase()))}function getDateFnsOptions(){return{useAdditionalDayOfYearTokens:!0,useAdditionalWeekYearTokens:!0,locale:getDateFnsLocale()}}function convertDayOfWeekPattern(pattern){return{startIndex:pattern.indexOf("u"),endIndex:pattern.lastIndexOf("u"),convertedPattern:pattern.replace(/u+/g,"i")}}export{addMilliseconds as a,getDefaultOptions as b,subMilliseconds as c,format as d,formatDate as f,getDateFormatPlaceholder as g,parseDate as p,startOfWeek as s,toMendixPattern as t};
