import{A as AssertionError,e as ensure,D as uniqueBy,z as partition,b as tuple}from"./D_wx3dK9.js";import{a as onlineData,g as getData,o as offlineData,w as wait}from"./BdJSoYCn.js";import{f as isMxObjectArray,p as getExpressionFunction,q as expressionVariableToRuntimeValue,v as anyToExpressionVariable,j as toNumber,w as evaluateFlowExpression}from"./C6y83v65.js";import Big$1,{Big}from"big.js";import"./B1284HK7.js";import"react";import{M as MxObject,l as localizeDate}from"./C65U15yB.js";import{L as LogManager,a as LogNode}from"./DecP5gSw.js";import{S as Stopwatch,D as DescribedError,C as ConnectionError}from"./2WW7glmp.js";import{a as toQueryFilter,g as gatherRuntimeArgumentsFor}from"./mRU8tr4_.js";import{g as getEntityMeta,O as ObjectLockManager,f as getAttributesMeta}from"./ChJoRR9k.js";import{k as attributeToClientValue}from"./rl_IZaGC.js";import{o as handleError}from"./DMKwwHAr.js";import{g as getUI}from"./DlmX1Pqa.js";import{O as ObjectValidation}from"./DGL6pswC.js";import{d as format}from"./DDlr49mf.js";import{n as newId}from"./B1iMrXCs.js";class FakePerformanceTracker{begin(){}end(){}}class WebPerformanceTracker{begin(name){performance.mark(name)}end(name){performance.measure(name,name)}}function isPerformanceTrackingEnabled(){return window?.MX_ENABLE_PERFORMANCE_TRACKING&&"undefined"!=typeof performance}function getNanoflow(nanoflowId){return nanoflowId()}var AggregateFunction;function getInstructionDescription(instruction){switch(instruction.type){case"nanoflowCall":return`Call nanoflow: ${getNanoflow(instruction.flow).name}`;case"microflowCall":return`Call microflow: ${instruction.operationId}`;case"javaScriptActionCall":return"string"==typeof instruction.action?`Call JavaScript Action: ${instruction.action}`:"Call JavaScript Action";case"openForm":return"Show page"+instruction.path;case"aggregate":return`Aggregate list $${instruction.inputVar}`;case"sortList":return`Sort list $${instruction.inputVar}`;case"filterListByExpression":case"filterList":return`Filter list $${instruction.inputVar}`;case"rangeFromList":return`Range from list $${instruction.inputVar}`;case"setVariable":return`Set variable $${instruction.outputVar}`;case"synchronize":const variables="specific"===instruction.syncType?`: ${instruction.variableNames.map((x=>`$${x}`)).join(", ")}`:"";return`Synchronize ${instruction.syncType} objects${variables}`;case"associationRetrieve":return`Retrieve $${instruction.inputVar}/${instruction.association}`;case"databaseRetrieve":return`Retrieve ${instruction.entity} from database`;case"createObject":return`Create object $${instruction.outputVar}`;case"changeObject":return`Change object $${instruction.inputVar}/${instruction.member}`;case"commitObjects":return`Commit object(s) $${instruction.inputVar}`;case"deleteObjects":return`Delete object(s) $${instruction.inputVar}`;case"rollbackObjects":return`Rollback object(s) $${instruction.inputVar}`;case"whileLoop":return"Loop (while)";case"listLoop":return`Loop list $${instruction.listVar}`;default:return instruction.type.charAt(0).toUpperCase()+instruction.type.slice(1)}}!function(AggregateFunction){AggregateFunction.Sum="Sum",AggregateFunction.Average="Average",AggregateFunction.Count="Count",AggregateFunction.Minimum="Minimum",AggregateFunction.Maximum="Maximum",AggregateFunction.All="All",AggregateFunction.Any="Any",AggregateFunction.Reduce="Reduce"}(AggregateFunction||(AggregateFunction={}));class AggregateExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="aggregate"}async execute(instruction,context){const inputList=context.getScope().get(instruction.inputVar);if(!isMxObjectArray(inputList))throw new AssertionError;const scope=context.getScope();if(instruction.operation!==AggregateFunction.Count)if(instruction.useExpression){const reducer=function(context,evaluateFlowExpression,inputList,expression,exposeCurrentResult){return async(resultOnEmpty,fun,initialValue=void 0)=>{if(0===inputList.length)return resultOnEmpty;const scope=context.getScope();let res=initialValue!==firstFlag?initialValue:void 0;try{initialValue===firstFlag&&(scope.set("currentObject",inputList[0]),exposeCurrentResult&&scope.set("currentResult",res),res=await evaluateFlowExpression(expression,scope,"primitive"));for(const obj of inputList){scope.set("currentObject",obj),exposeCurrentResult&&scope.set("currentResult",res);res=fun(res,await evaluateFlowExpression(expression,scope,"primitive"))}}finally{scope.set("currentObject",void 0),scope.set("currentResult",void 0)}return res}}(context,this.evaluateExp,inputList,ensure(instruction.expression),instruction.operation===AggregateFunction.Reduce),value=await async function(reducer,instruction,inputList,context,evaluateFlowExpression){switch(instruction.operation){case AggregateFunction.Sum:return reducer(Big(0),((a,b)=>a.plus(b)),Big(0));case AggregateFunction.Average:const sumResult=await reducer(void 0,((a,b)=>a.plus(b)),Big(0));if(void 0===sumResult)return;return sumResult.div(inputList.length);case AggregateFunction.Minimum:return reducer(void 0,((a,b)=>a.lt(b)?a:b),firstFlag);case AggregateFunction.Maximum:return reducer(void 0,((a,b)=>a.gt(b)?a:b),firstFlag);case AggregateFunction.All:return reducer(!0,((a,b)=>a&&b),!0);case AggregateFunction.Any:return reducer(!1,((a,b)=>Boolean(a)||Boolean(b)),!1);case AggregateFunction.Reduce:const scope=context.getScope(),init=await evaluateFlowExpression(ensure(instruction.initialExpression),scope,"primitive");return reducer(init,((_,a)=>a),init);default:return}}(reducer,instruction,inputList,context,this.evaluateExp);scope.set(instruction.outputVar,value)}else scope.set(instruction.outputVar,function(inputList,operation,member){const inputValues=inputList.map((obj=>obj.get2(member))).filter((val=>val instanceof Big));switch(operation){case AggregateFunction.Minimum:return 0===inputValues.length?void 0:inputValues.reduce(((curMin,curVal)=>curVal.lt(curMin)?curVal:curMin),ensure(inputValues[0]));case AggregateFunction.Maximum:return 0===inputValues.length?void 0:inputValues.reduce(((curMax,curVal)=>curVal.gt(curMax)?curVal:curMax),ensure(inputValues[0]));case AggregateFunction.Average:return 0===inputValues.length?void 0:sum(inputValues).div(inputValues.length);case AggregateFunction.Sum:return sum(inputValues);default:return}}(inputList,instruction.operation,ensure(instruction.member)));else scope.set(instruction.outputVar,new Big(inputList.length))}}function sum(values){return values.reduce(((sumValue,curValue)=>sumValue.plus(curValue)),new Big(0))}const firstFlag=Symbol("first");class CopyVariableExecutor{constructor(){this.instructionType="copyVariable"}async execute(instruction,context){const input=context.getScope().get(instruction.inputVar);context.getScope().set(instruction.outputVar,input)}}class FilterListByExpressionExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="filterListByExpression"}async execute(instruction,context){const input=context.getScope().get(instruction.inputVar);let result;const scope=context.getScope();try{if(!isMxObjectArray(input))throw new AssertionError;if(instruction.retrieveSingleObject)for(const obj of input){scope.set("currentObject",obj);if(await this.evaluateExp(instruction.expr,context.getScope(),"primitive")){result=obj;break}}else{result=[];for(const obj of input){scope.set("currentObject",obj);await this.evaluateExp(instruction.expr,context.getScope(),"primitive")&&result.push(obj)}}}finally{scope.set("currentObject",void 0)}scope.set(instruction.outputVar,result)}}const isEqual=getExpressionFunction("=");class FilterListExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="filterList"}async execute(instruction,context){const input=context.getScope().get(instruction.inputVar),expected=await this.evaluateExp(instruction.expectedValue,context.getScope(),"primitive");if(!isMxObjectArray(input))throw new AssertionError;function equalsExpected(obj){const value=obj.get2(instruction.attribute);return isEqual(value,expected)}instruction.retrieveSingleObject?context.getScope().set(instruction.outputVar,input.find(equalsExpected)):context.getScope().set(instruction.outputVar,input.filter(equalsExpected))}}class InheritanceSwitchExecutor{constructor(){this.instructionType="inheritanceSwitch"}async execute(instruction,context){const obj=context.getScope().get(instruction.inputVar);if(void 0===obj)return{goto:ensure(instruction.targets[""])};if(!(obj instanceof MxObject))throw new AssertionError;const target=[obj.getEntity(),...obj.getSuperEntities()].find((t=>t in instruction.targets));if(!target)throw new AssertionError;return{goto:ensure(instruction.targets[target])}}}function collectObjects(inputVar,context){const variable=context.getScope().get(inputVar);if(variable instanceof MxObject)return[variable];if(isMxObjectArray(variable)||void 0===variable)return variable;throw new AssertionError}class JavaScriptActionExecutor{constructor(evaluateExp,executeNanoflow,executeMicroflow){this.evaluateExp=evaluateExp,this.executeNanoflow=executeNanoflow,this.executeMicroflow=executeMicroflow,this.instructionType="javaScriptActionCall"}async execute(instruction,context){const resolvedParameters=await Promise.all(instruction.parameters.map((async param=>{switch(param.kind){case"nanoflowId":return this.createNanoflowWrapper(param.value,context);case"microflowId":return this.createMicroflowWrapper(param.value,context);default:return this.evaluateExp(param.value,context.getScope(),param.kind)}}))),action=await async function(jsActionId){return jsActionId()}(instruction.action),result=await action(...resolvedParameters);instruction.outputVar&&context.getScope().set(instruction.outputVar,anyToExpressionVariable(result))}createNanoflowWrapper(nanoflowId,context){if(void 0!==nanoflowId)return(args={})=>{const flatArgs=Object.keys(args).map((name=>({name:name,value:anyToExpressionVariable(args[name])})));return this.executeNanoflow(nanoflowId,flatArgs,context)}}createMicroflowWrapper(operationId,context){if(void 0!==operationId)return async(args={})=>{const microflowParameters=function(args){const result={};for(const key of Object.keys(args)){const value=args[key];if(null!=value)if("string"==typeof value||"boolean"==typeof value)result[key]={value:value};else if("number"==typeof value)result[key]={value:new Big$1(value).toString()};else if(value instanceof Big$1)result[key]={value:value.toString()};else if(value instanceof Date)result[key]={value:value.getTime()};else if(value instanceof MxObject)result[key]={guid:value.getGuid()};else{if(!Array.isArray(value))throw new AssertionError("Invalid value in 'anyToRuntimeArguments': "+value);result[key]={guids:value.map((v=>{if(v instanceof MxObject)return v.getGuid();throw new AssertionError("Invalid array element in 'anyToRuntimeArguments': "+v)}))}}}return result}(args);return this.executeMicroflow(operationId,microflowParameters,context.currentForm)}}}class JumpExecutor{constructor(){this.instructionType="jump"}async execute(instruction,_context){return{goto:instruction.target}}}class ListLoopExecutor{constructor(executeInstructions){this.executeInstructions=executeInstructions,this.instructionType="listLoop",this.currentIndexVariable="currentIndex"}async execute(instruction,context){const scope=context.getScope(),list=scope.get(instruction.listVar);if(!Array.isArray(list))throw new AssertionError;const parentCurrentIndex=scope.has(this.currentIndexVariable)?scope.get(this.currentIndexVariable):void 0;let currentIndex=new Big$1(0);for(const obj of list){if(scope.set(instruction.iteratorVar,obj),scope.set(this.currentIndexVariable,currentIndex),await this.executeInstructions(instruction.body,context))break;currentIndex=currentIndex.plus(1)}void 0!==parentCurrentIndex&&scope.set(this.currentIndexVariable,parentCurrentIndex)}}class MicroflowCallExecutor{constructor(evaluateFlowExpression,executeMicroflow){this.evaluateFlowExpression=evaluateFlowExpression,this.executeMicroflow=executeMicroflow,this.instructionType="microflowCall",this.logger=LogManager.get().getLogger(LogNode.Nanoflow)}async execute({operationId:operationId,parameters:parameters,outputVar:outputVar},context){const stopwatch=new Stopwatch;this.logger.debug(`[${context.executionId}] Starting microflow call ${operationId}.`);const microflowParameters=await async function(parameters,evaluateFlowExpression,context){const result={};for(const{name:name,value:value,kind:kind}of parameters){const expressionResult=await evaluateFlowExpression(value,context.getScope(),kind);if("object"===kind&&expressionResult instanceof MxObject)result[name]={guid:expressionResult.getGuid()};else if("list"===kind&&isMxObjectArray(expressionResult))result[name]={guids:expressionResult.map((mxobj=>mxobj.getGuid()))};else if("primitive"===kind){const runtimeValue=expressionVariableToRuntimeValue(expressionResult);null!==runtimeValue&&(result[name]={value:runtimeValue})}}return result}(parameters,this.evaluateFlowExpression,context),result=await this.executeMicroflow(operationId,microflowParameters,context.currentForm);void 0!==outputVar&&context.getScope().set(outputVar,result),this.logger.debug(`[${context.executionId}] Finished microflow call ${operationId} in ${stopwatch.measure()} milliseconds.`)}}class NanoflowCallExecutor{constructor(evaluateExpression,executeNanoflow){this.evaluateExpression=evaluateExpression,this.executeNanoflow=executeNanoflow,this.instructionType="nanoflowCall"}async execute({flow:flow,parameters:parameters,outputVar:outputVar},context){const args=await Promise.all(parameters.filter((parameter=>"type"in parameter.value)).map((async parameter=>({name:parameter.name,value:await this.evaluateExpression(parameter.value,context.getScope(),parameter.kind)})))),result=await this.executeNanoflow(flow,args,context);void 0!==outputVar&&context.getScope().set(outputVar,result)}}class AssociationRetrieveExecutor{constructor(){this.instructionType="associationRetrieve"}async execute(instruction,context){const{inputVar:inputVar,association:association,entity:entity,retrieveSingleObject:retrieveSingleObject,direction:direction,outputVar:outputVar,operationId:operationId}=instruction,obj=context.getScope().get(inputVar);if(void 0===obj)return void context.getScope().set(outputVar,retrieveSingleObject?void 0:[]);if(!(obj instanceof MxObject))throw new AssertionError;const mxobjs=mx.isOffline()?await async function(mxobj,path,entity,direction){return new Promise(((resolve,reject)=>{getData().get({guid:mxobj.getGuid(),path:path,entity:entity,direction:direction,callback:resolve,error:reject})}))}(obj,association,entity,direction):(await onlineData().retrieveByPathUsingOperationIdOrCache(obj.getGuid(),association,direction,entity,operationId)).mxObjects;context.getScope().set(outputVar,retrieveSingleObject?mxobjs[0]:mxobjs)}}class ChangeObjectExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="changeObject"}async execute(instruction,context){const obj=context.getScope().get(instruction.inputVar);if(void 0===obj)return;if(!(obj instanceof MxObject))throw new AssertionError;if(obj.isReadonlyAttr(instruction.member))throw new Error(`Cannot set $${instruction.inputVar}/${instruction.member} because it is read-only`);const exprValue=await this.evaluateExp(instruction.value,context.getScope(),"primitive");obj.set2(instruction.member,exprValue instanceof Big?exprValue.round(8):exprValue)}}class CommitObjectsExecutor{constructor(){this.instructionType="commitObjects"}async execute(instruction,context){const objectsToCommit=collectObjects(instruction.inputVar,context);if(void 0===objectsToCommit||0===objectsToCommit.length)return;const uniqueObjectToCommit=uniqueBy(objectsToCommit,(obj=>obj.getGuid())),entity=ensure(uniqueObjectToCommit[0]).getEntity();mx.isOffline(entity)?await new Promise(((resolve,reject)=>getData().commit({mxobjs:objectsToCommit,callback:resolve,error:reject}))):await onlineData().executeObjectAction(instruction.operationId,"commit",objectsToCommit)}}class CreateObjectExecutor{constructor(){this.instructionType="createObject"}async execute(instruction,context){let obj;obj=mx.isOffline(instruction.objectType)?await offlineData().create(instruction.objectType):await onlineData().createObject(instruction.objectType,instruction.operationId),context.getScope().set(instruction.outputVar,obj)}}class DatabaseRetrieveExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="databaseRetrieve"}async execute(instruction,context){const{entity:entity,constraints:constraints,limitExpr:limitExpr,offsetExpr:offsetExpr,takeFirst:takeFirst,sort:sort,outputVar:outputVar,operationId:operationId}=instruction,scope=context.getScope(),limit=limitExpr?await this.evaluateExp(limitExpr,scope,"primitive"):void 0,offset=offsetExpr?await this.evaluateExp(offsetExpr,scope,"primitive"):void 0,options={...offset?{offset:Number(offset)}:{},...limit?{amount:Number(limit)}:{},...sort?{sort:sort}:{}},{mxObjects:mxObjects}=mx.isOffline(entity)?await offlineData().retrieve(entity,constraints?toQueryFilter(constraints,(name=>scope.get(name))):void 0,options):await onlineData().retrieveByXPath(operationId,constraints?gatherRuntimeArgumentsFor(constraints,(name=>scope.get(name))):{},"",options,!1);scope.set(outputVar,takeFirst?mxObjects[0]:mxObjects)}}class DeleteObjectsExecutor{constructor(){this.instructionType="deleteObjects"}async execute(instruction,context){const variable=context.getScope().get(instruction.inputVar);let objectsToDelete=[];if(variable instanceof MxObject)objectsToDelete=[variable];else{if(!isMxObjectArray(variable)){if(void 0===variable)return;throw new AssertionError}if(0===variable.length)return;objectsToDelete=uniqueBy(variable,(obj=>obj.getGuid()))}const entity=ensure(objectsToDelete[0]).getEntity();mx.isOffline(entity)?await offlineData().delete(objectsToDelete):await onlineData().executeObjectAction(instruction.operationId,"delete",objectsToDelete)}}class RollbackObjectsExecutor{constructor(){this.instructionType="rollbackObjects"}async execute(instruction,context){const objectsToRollback=collectObjects(instruction.inputVar,context);if(void 0===objectsToRollback||0===objectsToRollback.length)return;const uniqueObjectToRollback=uniqueBy(objectsToRollback,(obj=>obj.getGuid())),entity=ensure(uniqueObjectToRollback[0]).getEntity();mx.isOffline(entity)?await new Promise(((resolve,reject)=>getData().rollback({mxobjs:objectsToRollback,callback:resolve,error:reject}))):await onlineData().executeObjectAction(instruction.operationId,"rollback",objectsToRollback)}}class ClearFromClientExecutor{constructor(){this.instructionType="clearFromClient"}async execute(instruction,_context){if(!mx.isOffline())return;const{entity:entity}=instruction;await offlineData().clearFromClient(entity)}}class SynchronizeExecutor{constructor(){this.instructionType="synchronize"}async execute(instruction,context){if(mx.isOffline())switch(instruction.syncType){case"all":await offlineData().runFullSynchronization();break;case"unsynchronized":const{dirtyObjects:dirtyObjects}=await offlineData().retrieveDirtyObjects(!0),deletesToBeSynced=await offlineData().retrieveDeletes();(dirtyObjects.length>0||Object.keys(deletesToBeSynced).length>0)&&await offlineData().selectiveSync(dirtyObjects,deletesToBeSynced);break;case"specific":const{variableNames:variableNames}=instruction,allObjects=variableNames.flatMap((name=>{const value=context.getScope().get(name);if(value instanceof MxObject||isMxObjectArray(value))return value;if(void 0===value)return[];throw new AssertionError}));allObjects.length>0&&await offlineData().selectiveSync(uniqueBy(allObjects,(obj=>obj.getGuid())))}}}class RangeFromListExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="rangeFromList"}async execute(instruction,context){const input=context.getScope().get(instruction.inputVar);if(!Array.isArray(input))throw new AssertionError;const offsetValue=toNumber(await this.evaluateExp(instruction.offset,context.getScope(),"primitive")),limitValue=toNumber(await this.evaluateExp(instruction.limit,context.getScope(),"primitive")),offset=offsetValue<=0?0:offsetValue,limit=limitValue<=0?Number.MAX_SAFE_INTEGER:limitValue;context.getScope().set(instruction.outputVar,input.slice(offset,offset+limit))}}class ReturnExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="return"}async execute(instruction,context){return{result:await this.evaluateExp(instruction.result,context.getScope(),instruction.resultKind)}}}class SetVariableExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="setVariable"}async execute(instruction,context){context.getScope().set(instruction.outputVar,await this.evaluateExp(instruction.value,context.getScope(),instruction.outputKind))}}class SortListExecutor{constructor(){this.instructionType="sortList"}async execute(instruction,context){const input=context.getScope().get(instruction.inputVar);if(!isMxObjectArray(input))throw new AssertionError;let arrCopy=input.slice();const meta=getEntityMeta(instruction.entity);instruction.items.slice().reverse().forEach((item=>{const dataType=meta?.attributes[item.attribute]?.type??"String",[validObjs,emptyObjs]=partition((arrItem=>{const attr=arrItem.get2(item.attribute);return""!==attr&&null!=attr}),arrCopy);switch(dataType){case"DateTime":validObjs.sort(applyOrdering(item.order,((a,b)=>attributeToClientValue(a.get2(item.attribute))-attributeToClientValue(b.get2(item.attribute)))));break;case"String":case"Enum":case"HashString":validObjs.sort(applyOrdering(item.order,((a,b)=>{const aAttr=a.get2(item.attribute).toLowerCase(),bAttr=b.get2(item.attribute).toLowerCase();return(aAttr>bAttr?1:0)-(bAttr>aAttr?1:0)})));break;case"AutoNumber":case"Long":case"Integer":case"Decimal":validObjs.sort(applyOrdering(item.order,((a,b)=>{const aAttr=a.get2(item.attribute),bAttr=b.get2(item.attribute);return aAttr.cmp(bAttr)})));break;case"Boolean":validObjs.sort(applyOrdering(item.order,((a,b)=>{const aAttr=a.get2(item.attribute);return aAttr===b.get2(item.attribute)?0:aAttr?1:-1})));break;default:throw new Error("Unsupported data type")}arrCopy=validObjs.concat(emptyObjs)})),context.getScope().set(instruction.outputVar,arrCopy)}}function applyOrdering(ordering,compareFn){return(a,b)=>{const result=compareFn(a,b);return"desc"===ordering?-1*result:result}}class SwitchExecutor{constructor(exprEvaluator){this.exprEvaluator=exprEvaluator,this.instructionType="switch"}async execute(instruction,context){const value=await this.exprEvaluator(instruction.condition,context.getScope(),"primitive"),valueString=void 0!==value?value.toString():"";if(!(valueString in instruction.targets))throw new AssertionError;return{goto:ensure(instruction.targets[valueString])}}}class FlowScope{constructor(){this.locks=new Map,this.map={},this.lockManager=ObjectLockManager.getInstance(),this.map.latestError=void 0}set(name,value){this.map[name]=value,value instanceof MxObject?this.lockObjects(name,[value]):isMxObjectArray(value)&&this.lockObjects(name,value)}has(name){return name in this.map}get(name){if(!(name in this.map))throw new AssertionError;const value=this.map[name];return value instanceof MxObject&&value.isUnavailable()?void 0:isMxObjectArray(value)?value.filter((v=>!v.isUnavailable())):value}all(){return Object.keys(this.map)}destroy(){this.locks.forEach((release=>release())),this.locks.clear()}lockObjects(name,objs){this.locks.get(name)?.(),this.locks.set(name,this.lockManager.lock(objs.map((o=>o.getGuid()))))}}class TryCatchExecutor{constructor(executeInstructions){this.executeInstructions=executeInstructions,this.instructionType="tryCatch"}async execute(instruction,context){try{return void await this.executeInstructions(instruction.body,context)}catch(e){return e instanceof Error?context.getScope().set("latestError",e.message):null!=e?context.getScope().set("latestError",String(e)):context.getScope().set("latestError",void 0),{goto:instruction.catchTarget}}}}class CloseFormExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="closeForm"}async execute(instruction,context){const numberOfPagesToClose=instruction.numberOfPagesToClose?toNumber(await this.evaluateExp(instruction.numberOfPagesToClose,context.getScope(),"primitive")):1;if(numberOfPagesToClose<1)throw new Error(`The number of pages to close evaluated to ${numberOfPagesToClose}. It must be at least 1.`);const{currentForm:currentForm}=context;if(void 0===currentForm)throw new DescribedError("Cannot close the current page. No open page found.");currentForm.closePage(numberOfPagesToClose).catch((e=>handleError(e)))}}class OpenFormExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="openForm"}async execute(instruction,context){const title=instruction.title?await this.evaluateExp(instruction.title,context.getScope(),"primitive")??"":void 0,formParameters=(await Promise.all(Object.entries(instruction.inputArgs??{}).map((([name,expr])=>this.evaluateExp(expr,context.getScope(),"object").then((value=>tuple(name,value?.getGuid()))))))).reduce(((prev,[name,guid])=>({...prev,[name]:guid})),{}),numberOfPagesToClose=instruction.numberOfPagesToClose?toNumber(await this.evaluateExp(instruction.numberOfPagesToClose,context.getScope(),"primitive")):0,ui=getUI();await ui.openForm2(instruction.path,formParameters,title,context.currentForm,instruction.params,numberOfPagesToClose)}}class ShowMessageExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="showMessage"}async execute(instruction,context){const expressionResult=await this.evaluateExp(instruction.message,context.getScope(),"primitive"),message=void 0===expressionResult?"":expressionResult;getUI().showMessage(instruction.messageType,message,instruction.blocking)}}class ShowValidationExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="showValidation"}async execute(instruction,context){const variable=context.getScope().get(instruction.inputVar);if(void 0===variable)throw new Error(`Cannot refresh $${instruction.inputVar} as it is empty`);if(!(variable instanceof MxObject))throw new AssertionError;const expressionResult=await this.evaluateExp(instruction.text,context.getScope(),"primitive"),validationText=void 0===expressionResult?"":expressionResult,existingValidations=function(scope,guid){const validationMap=scope[symbol]??(scope[symbol]={});return validationMap[guid]??(validationMap[guid]={})}(context.getScope(),variable.getGuid());existingValidations[instruction.member]=validationText;const ov=new ObjectValidation(variable.getGuid(),existingValidations);await getData().sendValidationUpdates([ov])}}const symbol=Symbol("validations");class WriteLogExecutor{constructor(evaluateExp){this.evaluateExp=evaluateExp,this.instructionType="writeLog"}async execute(instruction,context){const message=await this.evaluateExp(instruction.message,context.getScope(),"primitive");LogManager.get().getLogger(LogNode.Nanoflow).log(instruction.level,message)}}class WhileLoopExecutor{constructor(executeInstructions,exprEvaluator){this.executeInstructions=executeInstructions,this.exprEvaluator=exprEvaluator,this.instructionType="whileLoop",this.currentIndexVariable="currentIndex"}async execute(instruction,context){const scope=context.getScope(),parentCurrentIndex=scope.has(this.currentIndexVariable)?scope.get(this.currentIndexVariable):void 0;let currentIndex=Big$1(0);for(scope.set(this.currentIndexVariable,currentIndex);await this.exprEvaluator(instruction.condition,scope,"primitive")&&!await this.executeInstructions(instruction.body,context);)currentIndex=currentIndex.plus(1),scope.set(this.currentIndexVariable,currentIndex);void 0!==parentCurrentIndex&&scope.set(this.currentIndexVariable,parentCurrentIndex)}}class NanoflowDebugger{constructor(connection,getNanoflow,logManager=LogManager.get()){let breakpointsReady;this.connection=connection,this.getNanoflow=getNanoflow,this.breakpoints=new Map,this.debuggedNanoflows={},this.logger=logManager.getLogger(LogNode.NanoflowDebugger),this.breakpointsReadyPromise=new Promise((resolve=>{breakpointsReady=resolve})),connection.onInstruction("set_breakpoints",(instruction=>{this.breakpoints.clear();for(const{label:label,condition:condition}of instruction.breakpoints)this.breakpoints.set(label,condition);breakpointsReady()})),connection.onInstruction("debugger_step",(instruction=>{ensure(this.debuggedNanoflows[instruction.executionId]).handleInstruction(instruction)})),connection.onInstruction("get_debugger_variable",(({executionId:executionId,variableName:variableName,index:index})=>{const variable=ensure(this.debuggedNanoflows[executionId]).context.getScope().get(variableName);this.send({type:"debugger_variable",data:this.serializeVariableContent(variable,index)})})),connection.onConnect((()=>{Object.keys(this.debuggedNanoflows).forEach((executionId=>this.send({type:"paused_nanoflow",data:this.createPausedNanoflow(ensure(this.debuggedNanoflows[executionId]).context)})))}))}async waitForBreakpoints(){return this.breakpointsReadyPromise}async handleInstruction({context:context,instruction:instruction}){if(await this.shouldBreak(instruction,context)){const debuggerInstruction=await this.activateDebugger(instruction,context),debuggedNf=ensure(this.debuggedNanoflows[context.executionId]);switch(debuggerInstruction.mode){case"continue":debuggedNf.maxStackDepthToPause=-1/0;break;case"step_into":debuggedNf.maxStackDepthToPause=1/0;break;case"step_over":debuggedNf.maxStackDepthToPause=context.getStackSize();break;case"step_out":debuggedNf.maxStackDepthToPause=context.getStackSize()-1}}}handleNanoflowCompletion({executionId:executionId}){delete this.debuggedNanoflows[executionId]}async shouldBreak(instruction,context){if(void 0===instruction.label||"jump"===instruction.type)return!1;if(this.breakpoints.has(instruction.label)){const condition=this.breakpoints.get(instruction.label);if(!condition)return!0;try{return!0===await evaluateFlowExpression(condition,context.getScope(),"primitive")}catch(e){return this.logger.error(`Failed to evaluate breakpoint expression: ${e instanceof Error?e.message:e}`),!1}}const debuggedNanoflow=this.debuggedNanoflows[context.executionId];return void 0!==debuggedNanoflow&&context.getStackSize()<=debuggedNanoflow.maxStackDepthToPause}async activateDebugger(instruction,context){const nanoflow=this.getNanoflow(context.getCurrentNanoflowId());return this.debuggedNanoflows[context.executionId]={context:context,maxStackDepthToPause:1/0,nanoflow:nanoflow.name,objectId:instruction.label,handleInstruction:()=>{}},new Promise((resolve=>{ensure(this.debuggedNanoflows[context.executionId]).handleInstruction=resolve,this.send({type:"paused_nanoflow",data:this.createPausedNanoflow(context)})}))}createPausedNanoflow(context){const{executionId:executionId}=context,{nanoflow:nanoflow,objectId:objectId}=ensure(this.debuggedNanoflows[executionId]);return{nanoflow:nanoflow,objectId:objectId,executionId:executionId,variables:this.getVariables(context.getScope())}}getVariables(scope){const variables={};for(const name of scope.all().filter((n=>"latestError"!==n))){const variable=scope.get(name);switch(typeof variable){case"boolean":variables[name]={type:"boolean",value:variable};break;case"string":variables[name]={type:"string",value:variable};break;case"undefined":variables[name]={type:"null"};break;case"object":variable instanceof Date?variables[name]={type:"date_time",...formatDate(variable)}:variable instanceof Big?variables[name]={type:"decimal",value:variable.toString()}:Array.isArray(variable)?variables[name]={type:"list",size:variable.length}:variables[name]=this.serializeObject(variable,!1);break;default:this.logger.error("Unknown variable type: "+typeof variable),variables[name]={type:"unknown",value:variable}}}return variables}serializeVariableContent(variable,index){return variable instanceof MxObject?this.serializeObject(variable,!0):Array.isArray(variable)&&void 0===index?{objects:variable.map((obj=>this.serializeObject(obj,!1)))}:Array.isArray(variable)&&void 0!==index&&variable[index]instanceof MxObject?this.serializeObject(variable[index],!0):{type:"null"}}serializeObject(variable,createMembers){if(variable instanceof MxObject){const guid=variable.getGuid(),obj={type:"object",id:guid,entity:variable.getEntity(),state:getData().isNew(guid)?"INSTANTIATED":"NORMAL"};if(createMembers){const members={},attrs=getAttributesMeta(variable.getEntity()).filter((attrMeta=>variable.has(attrMeta.name)));for(const attr of attrs){const value=variable.get2(attr.name);switch(attr.type){case"AutoNumber":members[attr.name]={type:"auto_number",value:value};break;case"Binary":members[attr.name]={type:"binary"};break;case"Boolean":members[attr.name]={type:"boolean",value:value};break;case"DateTime":{const member={type:"date_time"};value&&Object.assign(member,formatDate(value)),members[attr.name]=member}break;case"Decimal":members[attr.name]={type:"decimal",value:value};break;case"Enum":members[attr.name]={type:"enum",value:value,enumeration_name:ensure(attr.enumeration)};break;case"HashString":members[attr.name]={type:"hash_string",value:value};break;case"Integer":members[attr.name]={type:"integer",value:value};break;case"Long":members[attr.name]={type:"long",value:value};break;case"ObjectReference":{const type=ensure(attr.referenceEntity),member={type:"reference"};value&&(member.value={type:String(type),object_id:value.toString()}),members[attr.name]=member}break;case"ObjectReferenceSet":{const type=ensure(attr.referenceEntity),member={type:"reference_set",value:[]};value&&(member.value=value.map((object_id=>({type:String(type),object_id:object_id})))),members[attr.name]=member}break;case"String":members[attr.name]={type:"string",value:value};break;default:this.logger.error(`Unknown attribute type: ${attr.type}`),members[attr.name]={type:"unknown",value:String(value)}}}return{...obj,members:members}}return obj}return{type:"null"}}send(message){this.connection.send(JSON.stringify(message))}}function formatDate(date){return{value:format(localizeDate(date),"yyyy-MM-dd HH:mm:ss.SSS"),session_time:format(date,"yyyy-MM-dd HH:mm:ss.SSS xxxx")}}class DescribedNanoflowError extends DescribedError{constructor(message,stack,nanoflowStack){super(`${message}\n\nNanoflow stack:\n${nanoflowStack}`),this.nanoflowStack=nanoflowStack,Object.setPrototypeOf(this,DescribedNanoflowError.prototype),this.description=message,this.stack=stack}}class FlowContext{constructor(currentForm,nanoflowId=void 0,scope=void 0,executionId=newId("flow"),depth=0,parentContext=void 0){this.currentForm=currentForm,this.nanoflowId=nanoflowId,this.scope=scope,this.executionId=executionId,this.depth=depth,this.parentContext=parentContext}getScope(){return this.scope}getCurrentNanoflowId(){return this.nanoflowId??this.parentContext?.getCurrentNanoflowId()}getStackSize(){return this.depth}getCurrentInstruction(){return this.currentInstruction}setCurrentInstruction(instruction){this.currentInstruction=instruction}getLeafContext(){return this.childContext?.getLeafContext()??this}getParentContext(){return this.parentContext}async insideNewStack(operation,nanoflowId){const scope=void 0!==nanoflowId?new FlowScope:this.scope;this.childContext=new FlowContext(this.currentForm,nanoflowId??this.nanoflowId,scope,this.executionId,this.depth+1,this);try{return await operation(this.childContext)}finally{void 0!==nanoflowId&&scope.destroy(),this.childContext=void 0}}}class NanoflowError extends Error{constructor(innerError,nanoflowStack){super(`${innerError instanceof Error?innerError.message:String(innerError)}\n\nNanoflow stack:\n${nanoflowStack}`),this.innerError=innerError,this.nanoflowStack=nanoflowStack,Object.setPrototypeOf(this,NanoflowError.prototype),innerError instanceof Error&&(this.stack=innerError.stack)}}function isReturn(value){return"object"==typeof value&&"result"in value}class NanoflowPerformanceTracker{constructor(){this.performanceTracker=isPerformanceTrackingEnabled()?new WebPerformanceTracker:new FakePerformanceTracker}startTracking(nanoflowEngine){nanoflowEngine.onNanoflowExecutionEvent("nanoflowStart",this.onNanoflowStart.bind(this)),nanoflowEngine.onNanoflowExecutionEvent("nanoflowEnd",this.onNanoflowEnd.bind(this)),nanoflowEngine.onNanoflowExecutionEvent("instructionStart",this.onInstructionStart.bind(this)),nanoflowEngine.onNanoflowExecutionEvent("instructionEnd",this.onInstructionEnd.bind(this))}onNanoflowStart({nanoflowId:nanoflowId}){const nanoflowName=NanoflowPerformanceTracker.getNanoflowName(nanoflowId);this.performanceTracker.begin(`Nanoflow: ${nanoflowName}`)}onNanoflowEnd({nanoflowId:nanoflowId}){const nanoflowName=NanoflowPerformanceTracker.getNanoflowName(nanoflowId);this.performanceTracker.end(`Nanoflow: ${nanoflowName}`)}onInstructionStart({instruction:instruction}){const instructionDescription=getInstructionDescription(instruction);this.performanceTracker.begin(instructionDescription)}onInstructionEnd({instruction:instruction}){const instructionDescription=getInstructionDescription(instruction);this.performanceTracker.end(instructionDescription)}static getNanoflowName(nanoflowId){if("string"==typeof nanoflowId)return nanoflowId;if("name"in nanoflowId)return nanoflowId.name;throw new AssertionError("Nanoflow could not be identified")}}function toMapEntry(flowExecutor){return[flowExecutor.instructionType,flowExecutor]}const nanoflowEngine=new class{constructor(lazyExecutors,getNanoflowFromRegistry,expressionEvaluator){this.getNanoflowFromRegistry=getNanoflowFromRegistry,this.expressionEvaluator=expressionEvaluator,this.executionEventHandlers={nanoflowStart:[],nanoflowEnd:[],instructionStart:[],instructionEnd:[]},this.runningNanoflows=new Array,this.logger=LogManager.get().getLogger(LogNode.Nanoflow);this.executors=lazyExecutors(((instructions,context)=>context.insideNewStack((newContext=>this.executeInstructions(instructions,newContext)))),this.executeInstructions.bind(this),this.executeNanoflow.bind(this),this.executeMicroflow.bind(this))}async execute(nanoflowId,args,currentForm){const context=new FlowContext(currentForm,nanoflowId),nanoflowName=this.getNanoflowFromRegistry(nanoflowId).name,stopwatch=new Stopwatch;this.logger.debug(`[${context.executionId}] Starting execution of nanoflow ${nanoflowName}.`),this.runningNanoflows.push(context),await this.raiseEvent("nanoflowStart",{nanoflowId:nanoflowId,executionId:context.executionId});try{return await wait(0),await this.executeNanoflow(nanoflowId,args,context)}finally{this.runningNanoflows.splice(this.runningNanoflows.indexOf(context),1),this.logger.debug(`[${context.executionId}] Finished execution of nanoflow ${nanoflowName}. Execution took ${stopwatch.measure()} milliseconds.`),await this.raiseEvent("nanoflowEnd",{nanoflowId:nanoflowId,executionId:context.executionId})}}onNanoflowExecutionEvent(type,handler){const handlers=this.executionEventHandlers[type];return handlers.push(handler),{unsubscribe(){const idx=handlers.indexOf(handler);idx>-1&&handlers.splice(idx,1)}}}generateCallStackOfExecutingNanoflows(){return this.runningNanoflows.map((context=>[this.getNanoflowFromRegistry(context.getCurrentNanoflowId()).name,this.generateCallStack(context)]))}generateCallStack(context){const nfStack=new Array;let currentContext=context.getLeafContext(),indent=0;for(;void 0!==currentContext?.getCurrentInstruction();)nfStack.push(`${indent>0?new Array(indent).fill(" ").join(""):""} "${getInstructionDescription(currentContext.getCurrentInstruction())}" in nanoflow "${this.getNanoflowFromRegistry(currentContext.getCurrentNanoflowId()).name}"`),currentContext=currentContext.getParentContext(),indent++;return nfStack.join("\n")}async raiseEvent(type,args){const handlers=this.executionEventHandlers[type];handlers.length>0&&await Promise.all(handlers.map((handler=>handler(args))))}getRunningNanoflows(){return[...this.runningNanoflows]}async executeMicroflow(operationId,microflowParameters,currentForm){return mx.isOffline()?offlineData().executeMicroflow(operationId,microflowParameters,currentForm):onlineData().executeMicroflow(operationId,microflowParameters,currentForm)}async executeNanoflow(nanoflowId,args,context){return context.insideNewStack((async newContext=>{const nanoflow=this.getNanoflowFromRegistry(nanoflowId),argMap=new Map(args.map((arg=>[arg.name,arg.value])));return await Promise.all(nanoflow.optionalParameters?.map((async param=>{if(!argMap.has(param.name)){const defaultValue=await this.expressionEvaluator(param.value,newContext.getScope(),param.kind);argMap.set(param.name,defaultValue)}}))??[]),argMap.forEach(((value,name)=>{newContext.getScope().set(name,value)})),this.executeInstructions(nanoflow.instructions,newContext)}),nanoflowId)}async executeInstructions(instructions,context){let index=0;for(;index<instructions.length;){const instruction=ensure(instructions[index]),executor=this.executors.get(instruction.type);if(void 0===executor)throw new AssertionError;let executorResult;await this.raiseEvent("instructionStart",{context:context,instruction:instruction}),context.setCurrentInstruction(instruction);try{executorResult=await executor.execute(instruction,context)}catch(e){throw e instanceof NanoflowError||e instanceof DescribedNanoflowError||e instanceof ConnectionError?e:e instanceof DescribedError?new DescribedNanoflowError(e.message,e.stack,this.generateCallStack(context)):new NanoflowError(e,this.generateCallStack(context))}finally{await this.raiseEvent("instructionEnd",{context:context,instruction:instruction})}if("object"==typeof(value=executorResult)&&"goto"in value){const goto=executorResult.goto;if(index=instructions.findIndex((i=>i.label===goto)),-1===index)throw new AssertionError}else{if(isReturn(executorResult))return executorResult.result;index++}}var value;throw new AssertionError}}(((executeInstructionsInNewStack,executeInstructions,executeNanoflow,executeMicroflow)=>new Map([toMapEntry(new JumpExecutor),toMapEntry(new SwitchExecutor(evaluateFlowExpression)),toMapEntry(new InheritanceSwitchExecutor),toMapEntry(new ListLoopExecutor(executeInstructionsInNewStack)),toMapEntry(new WhileLoopExecutor(executeInstructionsInNewStack,evaluateFlowExpression)),toMapEntry(new TryCatchExecutor(executeInstructions)),toMapEntry(new ReturnExecutor(evaluateFlowExpression)),toMapEntry(new CreateObjectExecutor),toMapEntry(new ClearFromClientExecutor),toMapEntry(new ChangeObjectExecutor(evaluateFlowExpression)),toMapEntry(new CommitObjectsExecutor),toMapEntry(new DeleteObjectsExecutor),toMapEntry(new RollbackObjectsExecutor),toMapEntry(new SetVariableExecutor(evaluateFlowExpression)),toMapEntry(new CopyVariableExecutor),toMapEntry(new OpenFormExecutor(evaluateFlowExpression)),toMapEntry(new CloseFormExecutor(evaluateFlowExpression)),toMapEntry(new ShowValidationExecutor(evaluateFlowExpression)),toMapEntry(new DatabaseRetrieveExecutor(evaluateFlowExpression)),toMapEntry(new AssociationRetrieveExecutor),toMapEntry(new WriteLogExecutor(evaluateFlowExpression)),toMapEntry(new JavaScriptActionExecutor(evaluateFlowExpression,executeNanoflow,executeMicroflow)),toMapEntry(new SynchronizeExecutor),toMapEntry(new FilterListExecutor(evaluateFlowExpression)),toMapEntry(new FilterListByExpressionExecutor(evaluateFlowExpression)),toMapEntry(new RangeFromListExecutor(evaluateFlowExpression)),toMapEntry(new SortListExecutor),toMapEntry(new AggregateExecutor(evaluateFlowExpression)),toMapEntry(new ShowMessageExecutor(evaluateFlowExpression)),toMapEntry(new NanoflowCallExecutor(evaluateFlowExpression,executeNanoflow)),toMapEntry(new MicroflowCallExecutor(evaluateFlowExpression,executeMicroflow))])),getNanoflow,evaluateFlowExpression);if(isPerformanceTrackingEnabled()){(new NanoflowPerformanceTracker).startTracking(nanoflowEngine)}let nanoflowDebugger;function initializeNanoflowDebugger(connection,logManager){if(void 0!==nanoflowDebugger)throw new AssertionError;nanoflowDebugger=new NanoflowDebugger(connection,getNanoflow,logManager),nanoflowEngine.onNanoflowExecutionEvent("instructionStart",nanoflowDebugger.handleInstruction.bind(nanoflowDebugger)),nanoflowEngine.onNanoflowExecutionEvent("nanoflowEnd",nanoflowDebugger.handleNanoflowCompletion.bind(nanoflowDebugger))}async function waitForNFDebuggerBreakpoints(){return Promise.race([ensure(nanoflowDebugger).waitForBreakpoints(),wait(500)])}export{DescribedNanoflowError as D,NanoflowError as N,initializeNanoflowDebugger as i,nanoflowEngine as n,waitForNFDebuggerBreakpoints as w};
