import{useLayoutEffect}from"react";import{e as ensure}from"./D_wx3dK9.js";import{i as isRightToLeft}from"./DsiqzbwR.js";import"big.js";import{g as getFocus,a as getHTMLElement,i as isNavigableElement,b as isHTMLElement}from"./BwKz6fHM.js";var NavigationKeys,NavigationCommand;!function(NavigationKeys){NavigationKeys[NavigationKeys.UpDown=0]="UpDown",NavigationKeys[NavigationKeys.LeftRight=1]="LeftRight"}(NavigationKeys||(NavigationKeys={})),function(NavigationCommand){NavigationCommand[NavigationCommand.FORWARD=0]="FORWARD",NavigationCommand[NavigationCommand.BACKWARD=1]="BACKWARD"}(NavigationCommand||(NavigationCommand={}));class RovingTabIndex{constructor(keys,container,childQuery=findNavigableDescendants){this.children=[],this.currentIndex=-1,this.focused=!1,this.updating=!1,this.shiftingFocus=!1,this.mutationObserver=new MutationObserver(this.onMutation.bind(this)),this.keys=keys,this.container=container,this.childQuery=childQuery,this.keyListener=this.createKeyListener(),this.focusInListener=this.createFocusInListener(),this.focusOutListener=this.createFocusOutListener(),this.addListeners(),this.handleMutation()}onMutation(_records){this.handleMutation()}handleMutation(){const children=(elements=this.childQuery(this.container),Array.isArray(elements)?elements:Array.from(elements).filter((e=>e instanceof HTMLElement))).filter((c=>!c.hasAttribute("data-roving-inactive")));var elements;this.doWithoutMutations((()=>this.updateChildren(children)))}setChildQuery(childQuery=findNavigableDescendants){this.childQuery=childQuery}setOnActiveRowChange(callback){this.onActiveRowChange=callback}setContainer(newContainer){this.container!==newContainer&&(this.removeListeners(),this.container=newContainer,this.addListeners(),this.handleMutation())}updateChildren(newChildren){const oldCurrent=this.getCurrentElement();if(function(oldChildren,newChildren){if(a=oldChildren,b=newChildren,a.length===b.length&&a.every(((e,i)=>e===b[i])))return!1;var a,b;const oldSet=new Set;return oldChildren.forEach((v=>oldSet.add(v))),newChildren.forEach((v=>{oldSet.delete(v)||v.setAttribute("data-roving-tabindex","")})),oldSet.forEach((v=>unmanageElement(v))),!0}(this.children,newChildren)&&(this.children=newChildren.slice()),oldCurrent){const newIndex=newChildren.indexOf(oldCurrent);if(this.setCurrentIndex(-1!==newIndex?newIndex:this.findValidIndex(!1,0)),this.focused){const newCurrent=this.getCurrentElement();setTimeout((()=>this.restoreFocus(oldCurrent!==newCurrent)),0)}}else this.updateTabIndices();this.updateState()}restoreFocus(force){if(this.shiftingFocus&&!force)return;const active=getFocus(),current=this.getCurrentElement();(force||!active||current&&current!==active&&current.contains(active))&&this.focusCurrentElement()}updateState(){const current=this.getCurrentElement();current&&isInteractive(current)||(this.setCurrentIndex(this.findValidIndex()),this.focused&&this.focusCurrentElement())}destroy(){this.mutationObserver.disconnect(),this.removeListeners(),this.children.forEach(unmanageElement)}addListeners(){this.container.addEventListener("keydown",this.keyListener),this.container.addEventListener("focusin",this.focusInListener),this.container.addEventListener("focusout",this.focusOutListener)}removeListeners(){this.container.removeEventListener("keydown",this.keyListener),this.container.removeEventListener("focusin",this.focusInListener),this.container.removeEventListener("focusout",this.focusOutListener)}doWithoutMutations(callback){const wasUpdating=this.updating;wasUpdating||(this.updating=!0,this.mutationObserver.disconnect()),callback(),wasUpdating||(this.mutationObserver.observe(this.container,{childList:!0,attributes:!0,subtree:!0}),this.updating=!1)}createKeyListener(){return e=>{const command=this.getNavigationCommand(e);if(null!==command){e.preventDefault();const reverse=command.valueOf()===NavigationCommand.BACKWARD.valueOf();this.setCurrentIndex(this.findValidIndex(reverse)),this.focusCurrentElement()}}}createFocusInListener(){return e=>{const target=getHTMLElement(ensure(e.target));let newIndex=-1,current=target;for(;current&&(newIndex=this.children.indexOf(current),-1===newIndex);)current=current.parentElement;-1!==newIndex&&this.setCurrentIndex(newIndex),target&&target!==current&&!isNavigableElement(target)&&window.setTimeout((()=>this.focusCurrentElement()),0),this.focused=!0}}createFocusOutListener(){return e=>{const current=this.getCurrentElement(),relatedTarget=getHTMLElement(ensure(e.relatedTarget??document.activeElement));this.shiftingFocus=!0,relatedTarget&&this.container.contains(relatedTarget)||window.setTimeout((()=>{this.focused=!1}),0),ensure(e.target)===current&&window.setTimeout((()=>{isInteractive(current)&&null!==current.parentNode||this.doWithoutMutations((()=>{this.updateState(),this.focusCurrentElement()}))}),0),window.setTimeout((()=>{this.shiftingFocus=!1}),0)}}getNavigationCommand(e){switch(this.keys){case NavigationKeys.UpDown:switch(e.key){case"ArrowUp":case"Up":return NavigationCommand.BACKWARD;case"ArrowDown":case"Down":return NavigationCommand.FORWARD}break;case NavigationKeys.LeftRight:{const rtl=isRightToLeft();switch(e.key){case"ArrowLeft":case"Left":return rtl?NavigationCommand.FORWARD:NavigationCommand.BACKWARD;case"ArrowRight":case"Right":return rtl?NavigationCommand.BACKWARD:NavigationCommand.FORWARD}break}}return null}setCurrentIndex(index){this.currentIndex=index,this.updateTabIndices(),this.onActiveRowChange&&this.onActiveRowChange(index)}focusCurrentElement(){const current=this.getCurrentElement();current&&current.focus()}updateTabIndices(){this.doWithoutMutations((()=>{this.children.forEach(((c,i)=>c.setAttribute("tabindex",i===this.currentIndex?"0":"-1")))}))}findValidIndex(reverse=!1,offset=1,startIndex=this.currentIndex){const newIndex=reverse?findLastIndexInArray(this.children,isInteractive,startIndex-offset):findFirstIndexInArray(this.children,isInteractive,startIndex+offset);return-1!==newIndex?newIndex:reverse?findFirstIndexInArray(this.children,isInteractive):findLastIndexInArray(this.children,isInteractive)}getCurrentElement(){return-1!==this.currentIndex?this.children[this.currentIndex]:null}}function unmanageElement(e){e.removeAttribute("tabindex"),e.removeAttribute("data-roving-tabindex")}function findFirstIndexInArray(elements,predicate,startIndex=0){const index=elements.slice(startIndex).findIndex(predicate);return-1===index?-1:index+startIndex}function findLastIndexInArray(elements,predicate,startIndex=elements.length-1){const index=elements.slice(0,startIndex+1).reverse().findIndex(predicate);return-1===index?-1:startIndex-index}function findNavigableDescendants(element,output=[]){for(let i=0,len=element.children.length;i<len;i++){const child=element.children.item(i);isHTMLElement(child)&&((child.hasAttribute("data-roving-tabindex")||isNavigableElement(child))&&output.push(child),findNavigableDescendants(child,output))}return output}function isInteractive(element){return function(element){const computedStyle=window.getComputedStyle(element);return"visible"===computedStyle.visibility&&"none"!==computedStyle.display}(element)&&function(element){return!element.disabled}(element)}function useRovingTabIndex(elementRef,navigationKeys,childQuery){useLayoutEffect((()=>{const rovingTabIndex=new RovingTabIndex(navigationKeys,ensure(elementRef.current),childQuery);return()=>rovingTabIndex.destroy()}),[elementRef,navigationKeys,childQuery])}export{NavigationKeys as N,useRovingTabIndex as u};
