import{g as getSession}from"./Cta-OvjQ.js";import{A as AssertionError,q as indexByKey,i as isJson,d as unique,E as grouped,e as ensure,r as repeat,m as mapValues,F as concat,D as uniqueBy}from"./D_wx3dK9.js";import{f as getAttributesMeta,S as SystemAttribute,y as computeSupermostEntityWithAttribute,h as deriveEntityId,g as getEntityMeta,z as isReferenceAttribute,p as publish}from"./ChJoRR9k.js";import{b as getMicroflowInfo,c as withFinally,g as getData}from"./BdJSoYCn.js";import{L as LogManager,a as LogNode}from"./DecP5gSw.js";import{C as ConnectionError,e as retrieveByIds,V as ValidationError,H as HandledError}from"./2WW7glmp.js";import{Big}from"big.js";import{i as isRuntimeGuid,g as getByGuid}from"./BJNnJLMR.js";import{toUserScopedName}from"./tablePrefix.js";import{O as ObjectValidation}from"./DGL6pswC.js";import{o as handleError}from"./DMKwwHAr.js";import{g as getUI}from"./DlmX1Pqa.js";import{M as MxObject}from"./C65U15yB.js";const METADATA_TABLE="_guidToTable",TOMBSTONE_TABLE="_tombstoneTable",GUID_COLUMN="guid",TABLE_NAME_COLUMN="tableName",READONLY_COLUMN="readonlyAttrs",SYNC_ID_COLUMN="syncId",METADATA_COLUMNS=["guid","tableName","readonlyAttrs","syncId"],DB_META_TABLE="_db_meta",DB_NAME_COLUMN="name",DB_VALUE_COLUMN="value",DB_VERSION_KEY="version",DB_COUNTER_KEY="cnt",DB_OFFLINE_METADATA_KEY="offline_metadata",ASSOCIATION_TABLE="_associationTable",PARENT_GUID_COLUMN="parentGuid",CHILD_GUID_COLUMN="childGuid",ASSOCIATION_NAME_COLUMN="associationName",CHANGED_DATE_COLUMN="changedDate",HAS_CONTENTS_COLUMN="HasContents";function createGetDbMetaValue(key){return['SELECT value FROM "_db_meta" WHERE "name" = ?',[key]]}function createUpdateDbMetaValue(key,value){return['UPDATE "_db_meta" SET "value" = ? WHERE name = ?',[value,key]]}function createUpdateCounterValue(count){return[`UPDATE "_db_meta" SET "value" = "value" + ${count} WHERE name = ?`,["cnt"]]}function toSafeKey(key){return key.replace(".","$")}function fromSafeKey(key){return key.replace("$",".")}function toSafeAlias(alias){return alias?.replace(".","$")}function attributeToSql(value){if(void 0===value)return null;if(value instanceof Big)return bigToSql(value);if(value instanceof Date)return Number(value);if("boolean"==typeof value)return function(x){return x?1:0}(value);if(Array.isArray(value))throw new AssertionError;return value}function sqlToRuntime(value,type){if(null===value)return null;switch(type){case"DateTime":return value;case"Boolean":return Boolean(value);case"Decimal":case"Integer":case"Long":return function(x){const sign=x.startsWith("-")?"-":"",meaningfulDigits=x.replace(/^-?0*/,"");return sign+(""!==meaningfulDigits?meaningfulDigits:"0")}(value);case"ObjectReferenceSet":return""===value?null:value;default:return String(value)}}function runtimeToSql(value,type){switch(type){case"AutoNumber":case"Binary":case"HashString":case"Enum":case"ObjectReference":case"ObjectReferenceSet":case"String":return null!=value?String(value):null;case"DateTime":return null!=value?Number(value):null;case"Boolean":return Number(value);case"Decimal":case"Integer":case"Long":return function(x){if(null==x)return null;return bigToSql(new Big(x))}(value);default:throw new AssertionError}}function bigToSql(x){const nrOfZeroes=20-Math.max(0,x.e)-1;return(x.s<0?"-":"")+new Array(nrOfZeroes+1).join("0")+x.abs().toFixed()}function getRequestData(objectCache,guidsToSend){const requestChanges={};guidsToSend.filter((guid=>objectCache.hasChanges(guid))).forEach((guid=>{requestChanges[guid]=objectCache.getChanges(guid)}));const requestJson=guidsToSend.filter((guid=>objectCache.has(guid))).map((guid=>objectCache.getObject(guid))).filter((mxobj=>!mxobj.isPersistable()||objectCache.isNew(mxobj.getGuid()))).map((mxobj=>mxobj.jsonData));return[requestChanges,requestJson]}function getImplicitMicroflowParameters(){const session=getSession();return[session.getUserId(),session.getSessionObjectId()]}class LabeledGraph{constructor(){this.labels=[],this.labelMap={},this.graph=[]}addEdge(fromLabel,toLabel){const fromIdx=this.getOrCreateLabelIndex(fromLabel),toIdx=this.getOrCreateLabelIndex(toLabel),destinationIndices=this.graph[fromIdx];destinationIndices.includes(toIdx)||destinationIndices.push(toIdx)}neighborsOf(label){const idx=this.getOrCreateLabelIndex(label);return this.graph[idx].map((neighborIdx=>this.indexToLabel(neighborIdx)))}reachableLabels(sourceLabels){const sourceIndices=sourceLabels.map((label=>this.getOrCreateLabelIndex(label)));return function(graph,start){const visited=new Array(graph.length);!function visitEdges(edges){for(const idx of edges){if(idx<0||idx>=visited.length)throw new Error(`graph: index ${idx} out of bounds in graph of size ${graph.length}`);visited[idx]||(visited[idx]=!0,visitEdges(graph[idx]))}}(start);const result=[];for(let i=0;i<visited.length;++i)visited[i]&&result.push(i);return result}(this.graph,sourceIndices).map((idx=>this.indexToLabel(idx)))}indexToLabel(idx){return this.labels[idx]}getOrCreateLabelIndex(label){if(label in this.labelMap)return this.labelMap[label];this.labels.push(label),this.graph.push([]);const newIdx=this.labels.length-1;return this.labelMap[label]=newIdx,newIdx}}function findReachableGuidsToRetain(mxObjs,rootGuids){return buildRetainmentGraph(mxObjs,rootGuids).reachableLabels(Array.from(rootGuids))}function findReachableGuidsForRequest(mxObjs,startGuids,associationsToFollow){const objectMap=indexByKey((mxObj=>mxObj.getGuid()))(mxObjs),associations=null!=associationsToFollow?function(mxObjs,associationsToFollow){const associations=[];return mxObjs.forEach((mxObj=>{associationsToFollow.forEach((asf=>{if(!mxObj.has(asf.association))return;const associationOwner=computeSupermostEntityWithAttribute(mxObj.getEntity(),asf.association),selectorEntity=mxObj.getSelectorEntity(asf.association);asf.fromEntity===associationOwner&&getAllReferences(mxObj,asf.association).forEach((refGuid=>associations.push({from:mxObj.getGuid(),to:refGuid}))),asf.fromEntity===selectorEntity&&getAllReferences(mxObj,asf.association).forEach((refGuid=>associations.push({from:refGuid,to:mxObj.getGuid()})))}))})),associations}(mxObjs,associationsToFollow):getAllAssociations(mxObjs);return createGraph(associations).reachableLabels(startGuids).filter((l=>objectMap[l]))}function findChangedReachableGuidsForRequest(objectCache,mxObjs,startGuids){const objectMap=indexByKey((mxObj=>mxObj.getGuid()))(mxObjs),associations=function(objectCache,mxObjs){const associations=[],referenceAttributesEntityMap=getReferenceAttributesEntityMap(mxObjs);return mxObjs.forEach((mxObj=>{referenceAttributesEntityMap.get(mxObj.getEntity()).forEach((association=>{mxObj.has(association)&&Object.prototype.hasOwnProperty.call(objectCache.getChanges(mxObj.getGuid()),association)&&getAllReferences(mxObj,association).forEach((refGuid=>{objectCache.isNew(refGuid)&&associations.push({from:mxObj.getGuid(),to:refGuid}),objectCache.getObject(refGuid)?.has(association)&&associations.push({to:mxObj.getGuid(),from:refGuid})}))}))})),associations}(objectCache,mxObjs);return createGraph(associations).reachableLabels(startGuids).filter((l=>objectMap[l]))}function findDeletableReachableGuidsForRequest(mxObjs,startGuids){const objectMap=indexByKey((mxObj=>mxObj.getGuid()))(mxObjs),associations=function(mxObjs){const associations=[],referenceAttributesEntityMap=getReferenceAttributesEntityMap(mxObjs);return mxObjs.forEach((mxObj=>{referenceAttributesEntityMap.get(mxObj.getEntity()).forEach((association=>{const deleteBehavior=mxObj.metaData.deleteBehavior;deleteBehavior?.[association]?.sendChildren&&getAllReferences(mxObj,association).forEach((refGuid=>associations.push({from:mxObj.getGuid(),to:refGuid}))),(mxObj.has(association)||deleteBehavior?.[association]?.sendParents)&&getAllReferences(mxObj,association).forEach((refGuid=>associations.push({from:refGuid,to:mxObj.getGuid()})))}))})),associations}(mxObjs);return createGraph(associations).reachableLabels(startGuids).filter((l=>objectMap[l]))}function buildRetainmentGraph(mxObjs,rootGuids){mxObjs=mxObjs.filter((mxObj=>!mxObj.isPersistable()||mxObj.hasChanges()||mxObj.isNew()||rootGuids.has(mxObj.getGuid())));const objectMap=indexByKey((mxObj=>mxObj.getGuid()))(mxObjs);return createGraph(getAllAssociations(mxObjs).filter((({from:from,to:to})=>isRetained(from)&&isRetained(to))));function isRetained(guid){return rootGuids.has(guid)||guid in objectMap}}function getAllAssociations(mxObjs){const associations=[],referenceAttributesEntityMap=getReferenceAttributesEntityMap(mxObjs);return mxObjs.forEach((mxObj=>{referenceAttributesEntityMap.get(mxObj.getEntity()).forEach((association=>{mxObj.has(association)&&getAllReferences(mxObj,association).forEach((refGuid=>associations.push({from:refGuid,to:mxObj.getGuid()},{from:mxObj.getGuid(),to:refGuid})))}))})),associations}function getReferenceAttributesEntityMap(mxObjs){const referenceAttributesEntityMap=new Map;for(const mxObj of mxObjs)referenceAttributesEntityMap.has(mxObj.getEntity())||referenceAttributesEntityMap.set(mxObj.getEntity(),getAttributesMeta(mxObj.getEntity()).filter((attr=>("ObjectReference"===attr.type||"ObjectReferenceSet"===attr.type)&&attr.name!==SystemAttribute.Owner&&attr.name!==SystemAttribute.ChangedBy)).map((association=>association.name)));return referenceAttributesEntityMap}function getAllReferences(mxObj,attr){return mxObj.getReferences(attr).concat(mxObj.getOriginalReferences(attr))}function createGraph(associations){const labeledGraph=new LabeledGraph;return associations.forEach((({from:from,to:to})=>labeledGraph.addEdge(from,to))),labeledGraph}function getRequestDataForMicroflow(objectCache,operationId,mfGuids){const microflowInfo=getMicroflowInfo(operationId),guidsToSend=findReachableGuidsForRequest(objectCache.getAllObjects(),mfGuids,microflowInfo?.followedAssociations);return mfGuids.filter((guid=>!guidsToSend.includes(guid))).forEach((guid=>guidsToSend.push(guid))),getRequestData(objectCache,guidsToSend)}const objectIdCache=new Map,OBJECT_ID_BITS_BI=BigInt(48),MAX_OBJECT_NR=65535,OBJECT_ID_MASK=BigInt(MAX_OBJECT_NR);function createMendixGuid(entity){if(void 0===entity.maxObjectId)throw new AssertionError(`Can't create a Mendix guid for "${entity.name}"`);const entityId=entity.entityId??deriveEntityId(entity.maxObjectId),objectId=objectIdCache.get(entity.name)??getObjectId(entity.maxObjectId);if(objectId>MAX_OBJECT_NR)throw new AssertionError(`Max object ID exceeds allowed amount for ${entity.name}.`);objectIdCache.set(entity.name,objectId-1);return(BigInt(entityId)<<OBJECT_ID_BITS_BI|BigInt(objectId)).toString()}function dehydrateObjectIdCache(){const obj={};return objectIdCache.forEach(((val,entity)=>obj[entity]=val.toString())),obj}function hydrateObjectIdCache(dehydratedCache){Object.entries(dehydratedCache).forEach((([entity,id])=>{objectIdCache.set(entity,getObjectId(id))}))}function getObjectId(id){return Number(BigInt(id)&OBJECT_ID_MASK)}function actionMatcher(...actions){const actionsToCheck=0===actions.length?[void 0]:actions;return request=>{const currentAction=actions.length>0&&isJson(request.body)?request.body.action:void 0;return actionsToCheck.includes(currentAction)}}function createRetryMiddleware(retries,...actions){return createRetryMiddlewarePredicate(retries,actionMatcher(...actions))}function createRetryMiddlewarePredicate(retries,predicate){return async(request,next)=>{let attempts=retries;const logger=LogManager.get().getLogger(LogNode.Network);try{return await next(request)}catch(e){return async function retry(e){const shouldRetry=e instanceof ConnectionError&&attempts-- >0;if(shouldRetry){const method=request.init.method?.toUpperCase();logger.trace(`Retrying ${method} ${request.url}. Attempts left: ${attempts}`)}return shouldRetry&&predicate(request)?next(request).catch(retry):Promise.reject(e)}(e)}}}MAX_OBJECT_NR.toString();class GuidMapping{constructor(){this.guidMap={}}add(from,to){this.guidMap[from]=to}has(from){return from in this.guidMap}remove(key){delete this.guidMap[key]}map(guidOrGuids){return Array.isArray(guidOrGuids)?guidOrGuids.map(this.mapGuid.bind(this)):this.mapGuid(guidOrGuids)}mapChange(change,entityMeta){const mappedChange={};return Object.entries(change).forEach((([attr,entry])=>{if(void 0!==entry.value){const value="ObjectReference"===entityMeta.attributes[attr]?.type&&null!=entry.value?this.map(entry.value):entry.value;mappedChange[attr]={...entry,value:value}}else mappedChange[attr]={...entry}})),mappedChange}mapMxObjectJSON(obj){const meta=getEntityMeta(obj.objectType),attributes={};return Object.entries(obj.attributes).forEach((([attr,value])=>{isReferenceAttribute(meta,attr)?attributes[attr]={...value,value:this.map(value.value)}:attributes[attr]=value})),{...obj,guid:this.map(obj.guid),attributes:attributes}}import(...mappings){mappings.forEach((mapping=>Object.entries(mapping.guidMap).forEach((([key,value])=>this.add(key,value)))))}entries(){return Object.entries(this.guidMap)}testClear(){Object.keys(this.guidMap).forEach((key=>delete this.guidMap[key]))}reverseCopyTo(guidMapping){Object.keys(this.guidMap).forEach((from=>guidMapping.add(this.map(from),from)))}mapGuid(guid){return this.guidMap[guid]??guid}}class OfflineToRuntimeGuidMapping extends GuidMapping{add(offlineGuid,runtimeGuid){if(isRuntimeGuid(offlineGuid)||!isRuntimeGuid(runtimeGuid))throw new AssertionError;super.add(offlineGuid,runtimeGuid)}reverse(){const map=new RuntimeToOfflineGuidMapping;return super.reverseCopyTo(map),map}}class RuntimeToOfflineGuidMapping extends GuidMapping{add(runtimeGuid,offlineGuid){if(!isRuntimeGuid(runtimeGuid)||isRuntimeGuid(offlineGuid))throw new AssertionError;super.add(runtimeGuid,offlineGuid)}reverse(){const map=new OfflineToRuntimeGuidMapping;return super.reverseCopyTo(map),map}}const syncedObjsRuntimeToOfflineMap=new RuntimeToOfflineGuidMapping;function getRuntimeGuid(offlineGuid){return syncedObjsRuntimeToOfflineMap.reverse().map(offlineGuid)}const SMALL_CHUNK_SIZE=5;function createChunkedQuery(parameters,createSql,fillRemainingWith){if(0===parameters.length)return[];const singleItemSize=Array.isArray(parameters[0])?parameters[0].length:1,groupSize=Math.min(20,Math.floor(999/singleItemSize));if(0===groupSize)throw new AssertionError("The amount of parameters is out of bounds, exceeding the maximum chunk size");return function createChunks(groupSizes,params){const size=groupSizes.shift(),[groupedParams,remainingGroup]=function(params,size,isLastSizeGroup){const groupedParams=grouped(params,size),lastGroup=groupedParams.pop();if(isLastSizeGroup&&void 0!==fillRemainingWith&&lastGroup.length>0)for(;lastGroup.length<size;)lastGroup.push(fillRemainingWith);return lastGroup.length===size?[[...groupedParams,lastGroup],[]]:[groupedParams,lastGroup]}(params,size,0===groupSizes.length),result=[];groupedParams.length>0&&result.push([createSql(size),groupedParams.map((ps=>ps.flat()))]);remainingGroup.length>0&&(0===groupSizes.length?result.push([createSql(remainingGroup.length),[remainingGroup.flat()]]):result.push(...createChunks(groupSizes,remainingGroup)));return result}(unique([groupSize,SMALL_CHUNK_SIZE].filter((s=>s<=groupSize))),parameters)}class AliasGenerator{constructor(){this.map=new Map}generateAlias(name){const count=this.map.get(name)??0;return this.map.set(name,count+1),`${name}_${count}`}}function toSqlFilter(filter,tableName,isEntityQuery=!0){const result=generateSqlFilter(filter,tableName,new AliasGenerator);return(result.joins??[]).length>0?{type:"int",expr:[`${tableName}.[guid] IN (`,`SELECT ${tableName}.[guid]`,` FROM "${isEntityQuery?toUserScopedName(tableName):tableName}" as ${tableName} `,result.joins?.join(" ")??"",` WHERE ${result.expr}`,")"].join(""),params:result.params}:result}function generateSqlFilter(filter,tableName,aliasGenerator){switch(filter.type){case"attribute":if("ObjectReference"===filter.attributeType&&"guid"!==filter.attribute||"ObjectReferenceSet"===filter.attributeType){const[associationJoin,reference]=getAssociationJoin(tableName,aliasGenerator,filter.attribute);return{type:"string",expr:`${reference}`,joins:[associationJoin],params:[]}}return{type:"Boolean"===filter.attributeType||"DateTime"===filter.attributeType?"int":"string",expr:`${toSafeAlias(filter.context)??tableName}.[${"id"!==filter.attribute?toSafeKey(filter.attribute):"guid"}]`,params:[]};case"value":if(void 0===filter.value)return{type:"null",expr:"NULL",params:[]};if(Array.isArray(filter.value)){const value=filter.value.map((v=>filter.isGuid?getRuntimeGuid(v):attributeToSql(v)));return{type:value.length>0&&"number"==typeof value[0]?"int":"string",expr:`(${value.map((()=>"?")).join(", ")})`,params:value}}const value=filter.isGuid?getRuntimeGuid(filter.value):attributeToSql(filter.value);return{type:"number"==typeof value?"int":"string",expr:"?",params:[value]};case"function":const args=filter.parameters.map((p=>generateSqlFilter(p,tableName,aliasGenerator))),joinsFromArgs=args.flatMap((a=>a.joins??[]));switch(filter.name){case"true":return ONE;case"false":return ZERO;case"not":{const arg1=toIntOrStringResult(ensure(args[0]));return{type:"int",expr:`(not ${arg1.expr})`,params:arg1.params,joins:joinsFromArgs}}case"or":case"and":{const fixedArgs=args.map(toIntOrStringResult);return{type:"int",expr:"("+fixedArgs.map((a=>a.expr)).join(` ${filter.name} `)+")",params:combineParams(...fixedArgs),joins:joinsFromArgs}}case"=":case"!=":case">":case">=":case"<":case"<=":{let[arg1,arg2]=args.some((a=>"int"===a.type))?args.map(castAsInt):args;const operation="="===filter.name?"is":"!="===filter.name?"is not":filter.name;return arg1=ensure(arg1),arg2=ensure(arg2),{type:"int",expr:`(${arg1.expr} ${operation} ${arg2.expr})`,params:combineParams(arg1,arg2),joins:joinsFromArgs}}case"contains":case"starts-with":case"ends-with":{const arg1=ensure(args[0]),arg2=ensure(args[1]);if("null"===arg2.type)return ONE;if("null"===arg1.type)return ZERO;const expected=`replace(replace(replace(${arg2.expr}, '${escapeChar="~"}', '${escapeChar+escapeChar}'), '%', '${escapeChar+"%"}'), '_', '${escapeChar+"_"}')`,like="starts-with"===filter.name?`${expected} || '%'`:"ends-with"===filter.name?`'%' || ${expected}`:`'%' || ${expected} || '%'`;return{type:"int",expr:`(${arg1.expr} like ${like} escape '~')`,params:arg1.params.concat(arg2.params),joins:joinsFromArgs}}case"length":case"string-length":const arg1=ensure(args[0]);return"null"===arg1.type?ZERO:{type:"int",expr:`length(${arg1.expr})`,params:arg1.params,joins:joinsFromArgs};case"in":const attribute=ensure(args[0]),values=ensure(args[1]);return{type:"string",expr:`(${attribute.expr} in (${new Array(values.params.length).fill("?").join(",")}))`,params:values.params,joins:joinsFromArgs};default:throw new AssertionError(`Operator ${filter.name} is not yet supported`)}case"association":return generateSqlFilter({type:"attribute",attribute:filter.associationPath.split("/")[0],attributeType:"Reference"===filter.associationType?"ObjectReference":"ObjectReferenceSet"},tableName,aliasGenerator);case"relatedEntity":const[associationJoin,reference]=getAssociationJoin(tableName,aliasGenerator,filter.left.attribute,filter.right.attribute);if(void 0===filter.next)return{...TRUE,joins:[associationJoin]};const rightEntities=[filter.rightEntity,...ensure(getEntityMeta(filter.rightEntity)).specializations];if(1===rightEntities.length)return function(filter,aliasGenerator,associationJoin,associationReference){const subqueryTableName=toUserScopedName(toSafeKey(filter.rightEntity)),subqueryTableAlias=toSafeAlias(filter.rightEntityAlias),subqueryFilter=generateSqlFilter(filter.next,subqueryTableAlias,aliasGenerator);return{...subqueryFilter,joins:[associationJoin,`LEFT JOIN "${subqueryTableName}" AS ${subqueryTableAlias} ON ${subqueryTableAlias}.[guid] = ${associationReference}`].concat(subqueryFilter.joins??[])}}(filter,aliasGenerator,associationJoin,reference);const expressions=rightEntities.map((rightEntity=>function(filter,rightEntity,aliasGenerator,associationReference){const subqueryTableName=toUserScopedName(toSafeKey(rightEntity)),subqueryTableAlias=toSafeAlias(filter.rightEntityAlias),subqueryFilter=generateSqlFilter(filter.next,subqueryTableAlias,aliasGenerator);return{type:"int",expr:[`${associationReference} IN`,`(SELECT ${subqueryTableAlias}.[guid]`,`FROM "${subqueryTableName}" as ${subqueryTableAlias}`,...subqueryFilter.joins??[],`WHERE ${subqueryFilter.expr})`].join(" "),params:subqueryFilter.params}}(filter,rightEntity,aliasGenerator,reference)));return{type:"int",expr:`(${expressions.map((e=>e.expr)).join(" OR ")})`,joins:[associationJoin],params:expressions.flatMap((e=>e.params))}}var escapeChar}function getAssociationJoin(tableName,aliasGenerator,attrLeft,attrRight){const associationTableAlias=aliasGenerator.generateAlias("_associationTable"),[name,left,right]=function(attrLeft,attrRight){if("guid"===attrLeft){if(void 0===attrRight)throw new Error("Can't get association details for guid attribute");return[attrRight,"childGuid","parentGuid"]}return[attrLeft,"parentGuid","childGuid"]}(attrLeft,attrRight);return[`LEFT JOIN "${toUserScopedName("_associationTable")}" AS ${associationTableAlias} ON ${associationTableAlias}.[${left}] = ${tableName}.[guid] AND ${associationTableAlias}.[associationName] = '${name}'`,`${associationTableAlias}.[${right}]`]}const ONE={type:"int",expr:"1",params:[]},ZERO={type:"int",expr:"0",params:[]},TRUE={type:"int",expr:"1=1",params:[]};function toIntOrStringResult(result){return"null"===result.type?ZERO:result}function castAsInt(result){return"string"===result.type?{type:"int",expr:`cast(${result.expr} as integer)`,params:result.params}:result}function combineParams(...args){return[].concat(...args.map((a=>a.params)))}function convertToSpecializationFilter(generalization,specialization,filter){if(generalization===specialization)return filter;switch(filter?.type){case"attribute":return{type:"attribute",attribute:filter.attribute,attributeType:filter.attributeType,context:replaceContext(generalization,specialization,filter.context)};case"association":return{type:"association",associationPath:filter.associationPath,associationType:filter.associationType,context:replaceContext(generalization,specialization,filter.context)};case"relatedEntity":return{type:"relatedEntity",left:convertToSpecializationFilter(generalization,specialization,filter.left),rightEntity:replaceEntity(generalization,specialization,filter.rightEntity),rightEntityAlias:replaceContext(generalization,specialization,filter.rightEntityAlias),right:convertToSpecializationFilter(generalization,specialization,filter.right),next:convertToSpecializationFilter(generalization,specialization,filter.next)};case"function":return{type:"function",name:filter.name,parameters:filter.parameters.map((p=>convertToSpecializationFilter(generalization,specialization,p)))};case"value":case void 0:return filter}}function replaceContext(generalization,specialization,context){return context?.startsWith(generalization)?`${specialization}${context.slice(generalization.length)}`:context}function replaceEntity(generalization,specialization,entity){return entity===generalization?specialization:entity}const QueryFilters=new class{equals(attribute,value,attributeType="String"){return{type:"function",name:"=",parameters:[{type:"attribute",attribute:attribute,attributeType:attributeType},{type:"value",value:value,isGuid:!1}]}}in(attribute,values,attributeType="String"){return{type:"function",name:"in",parameters:[{type:"attribute",attribute:attribute,attributeType:attributeType},{type:"value",value:values,isGuid:!1}]}}};function createUpdateSqlQuery(table,updates,queryFilter,isEntityQuery=!0){if(0===Object.keys(updates).length)throw new AssertionError("No updates specified.");const params=[],updateStrings=[];updates.forEach((({column:column,value:value,type:type})=>{updateStrings.push(`[${toSafeKey(column)}] = ?`),params.push(runtimeToSql(value,type))}));const safeTable=toSafeKey(table);let whereExpr="";if(void 0!==queryFilter){const{type:type,expr:expr,params:filterParams}=toSqlFilter(queryFilter,safeTable,isEntityQuery);"null"!==type&&(whereExpr=`WHERE ${expr}`,params.push(...filterParams))}return[`UPDATE "${toUserScopedName(safeTable)}" as ${safeTable} SET ${updateStrings.join(", ")} ${whereExpr}`,[...params]]}function createGetEntitiesSql(guids){return 0===guids.length?[]:createChunkedQuery(guids,(size=>`SELECT "guid", "tableName" FROM "${toUserScopedName("_guidToTable")}" WHERE "guid" IN (${repeat(size,(()=>"?")).join(", ")})`),"")}function createGetDirtyObjectsMetadataSql(excludedEntities=new Set){const excludeCondition=excludedEntities.size>0?` AND "tableName" NOT IN (${Array.from(excludedEntities).map((e=>`'${e}'`)).join(", ")})`:"";return[`SELECT "guid", "tableName" FROM "${toUserScopedName("_guidToTable")}" WHERE "syncId" IS NOT NULL${excludeCondition}`,[]]}function createGetSyncIdsSqlQueries(guids){return createChunkedQuery(guids,(size=>`SELECT "guid", "syncId" FROM "${toUserScopedName("_guidToTable")}" WHERE "guid" IN (${repeat(size,(()=>"?")).join(", ")})`),"")}function createClearDirtyGuidsSqlQueries(guids){if(0===guids.length)throw new AssertionError("No guids specified");return createChunkedQuery(guids,(size=>createUpdateSqlQuery("_guidToTable",[{column:"syncId",value:null,type:"String"}],QueryFilters.in("guid",repeat(size,(()=>""))))[0]),"").map((([sql,params])=>[sql,params.map((paramChunk=>[null,...paramChunk]))]))}function createCheckTableExistSqlQuery(tableName){return["SELECT COUNT(name) as cnt FROM sqlite_master WHERE type='table' AND name=?",[tableName]]}function createDeleteEntitiesMetaSqlQueries(entities){return createChunkedQuery(entities,(size=>`DELETE FROM "${toUserScopedName("_guidToTable")}" WHERE "tableName" IN (${repeat(size,(()=>"?")).join(", ")})`))}function getEntityAssociationsReferringTo(targetEntity,entities){const targetEntityWithSupers=new Set([targetEntity,...getEntityMeta(targetEntity)?.generalizations??[]]);return Object.assign({},...entities.map((entity=>{const meta=getEntityMeta(entity),associationsReferencingObjectType=Object.values(meta?.attributes??{}).filter((attrMeta=>attrMeta.referenceEntity&&targetEntityWithSupers.has(attrMeta.referenceEntity))).map((attrMeta=>attrMeta.name));return associationsReferencingObjectType.length>0?{[entity]:associationsReferencingObjectType}:{}})))}const memoized={};async function memoizeConcurrent(key,computation){const keyStr=JSON.stringify(key);return keyStr in memoized?memoized[keyStr]:memoized[keyStr]=withFinally(computation(key),(()=>{delete memoized[keyStr]}))}function createMemoizedCache(genFn){const cache=Object.create(null);return(key,...args)=>(key in cache||(cache[key]=genFn(key,...args)),cache[key])}const clone=objectToClone=>{if(null===objectToClone||"object"!=typeof objectToClone)return objectToClone;const objectClone=Array.isArray(objectToClone)?[]:{};return Object.keys(objectToClone).forEach((prop=>objectClone[prop]=clone(objectToClone[prop]))),objectClone};async function executeNoImpactInstructions(instructions){const ui=getUI();for(const instruction of instructions??[])switch(instruction.type){case"logout":mx.logout();break;case"show_login":ui.showLogin();break;case"download_file":const obj=await getByGuid(instruction.args.FileDocumentGuid);ui.downloadFile({mxobject:ensure(obj),target:instruction.args.Target});break;case"text_message":ui.showMessage(instruction.args.MessageType,instruction.args.MessageContent,instruction.args.MessageBlock)}}function gatherUpdates(objectCache,json){const changedAttrs=Object.entries(json.changes??{}).map((([guid,objChanges])=>Object.keys(objChanges).map((attr=>({guid:guid,attr:attr}))))),resetAttrs=Object.entries(json.resets??{}).map((([guid,attributes])=>attributes.map((attr=>({guid:guid,attr:attr}))))),attrsChangedByObjects=(json.objects??[]).map((objectJson=>{const obj=objectCache.getObject(objectJson.guid);return null!==obj?function(cachedObj,incomingJson){const incomingObj=MxObject.fromJson(incomingJson);return getAttributesMeta(incomingJson.objectType).map((attrMeta=>attrMeta.name)).filter((attr=>!function(lhsObj,rhsObj,attr){if(lhsObj.isReadonlyAttr(attr)!==rhsObj.isReadonlyAttr(attr))return!1;if(lhsObj.isReference(attr)){if(attr===SystemAttribute.ChangedBy||attr===SystemAttribute.Owner)return!0;return lhsObj.getOriginalReferences(attr).sort(((a,b)=>a.localeCompare(b))).join(",")===rhsObj.getOriginalReferences(attr).sort(((a,b)=>a.localeCompare(b))).join(",")}const lhsValue=lhsObj.getOriginalValue(attr),rhsValue=rhsObj.getOriginalValue(attr);return lhsValue===rhsValue||null!=lhsValue&&null!=rhsValue&&lhsValue.valueOf()===rhsValue.valueOf()}(cachedObj,incomingObj,attr)))}(obj,objectJson).map((attr=>({guid:objectJson.guid,attr:attr}))):[]})),refreshedGuids=unique(concat((json.instructions??[]).map(getRefreshGuids)).concat(json.deletes??[])),attrUpdates=uniqueBy([changedAttrs,resetAttrs,attrsChangedByObjects].flat(2),(x=>`${x.guid}:${x.attr}`)).map((({guid:guid,attr:attr})=>({guid:guid,attr:attr}))).filter((({guid:guid})=>!refreshedGuids.includes(guid)&&objectCache.has(guid))),objUpdates=refreshedGuids.filter((guid=>objectCache.has(guid))).map((guid=>({guid:guid}))),entityUpdates=unique(concat((json.instructions??[]).map((i=>"refresh_class"===i.type?i.args.classnames:[])))).map((entity=>({entity:entity})));return concat([attrUpdates,objUpdates,entityUpdates])}function getRefreshGuids(i){return"refresh_object_list"===i.type?i.args.ObjectIds:[]}async function handleRuntimeSuccess(objectCache,lockManager,json,options){return handleRuntimeSuccessResponse(objectCache,lockManager,json,gatherUpdates(objectCache,json),options)}async function handleRuntimeSuccessResponse(objectCache,lockManager,json,updates,options){const release=function(lockManager,{objects:objects=[],committedObjectsOmitted:committedObjectsOmitted=!1,commits:commits=[]}){const objectGuids=objects.map((o=>o.guid)),omittedGuids=committedObjectsOmitted?commits.filter((guid=>!objects.some((obj=>obj.guid===guid)))):[];return lockManager.lock(objectGuids.concat(omittedGuids))}(lockManager,json);try{await async function(objectCache,lockManager,{objects:objects=[],changes:changes={},newpersistable:newpersistable=[],commits:commits=[],deletes:deletes=[],resets:resets={},committedObjectsOmitted:committedObjectsOmitted=!1}){objectCache.removeChanges(resets),objectCache.addChanges(changes);const creates=objects.filter((objJson=>isUncached(objJson))).filter((objJson=>isPersistable(objJson)?newpersistable.includes(objJson.guid):!commits.includes(objJson.guid))).map((obj=>obj.guid));if(objectCache.onCreate(creates),objectCache.onDelete(deletes),objectCache.onCommit(commits),objectCache.setMxObjects(objects),committedObjectsOmitted){const committedGuidsInStaleCache=commits.filter((guid=>objectCache.has(guid)&&!objects.some((obj=>obj.guid===guid))));if(committedGuidsInStaleCache.length>0){const json=await retrieveByIds(committedGuidsInStaleCache,{});await handleRuntimeSuccess(objectCache,lockManager,json)}}function isUncached(jsonObj){return!objectCache.has(jsonObj.guid)}function isPersistable(jsonObj){return Boolean(getEntityMeta(jsonObj.objectType)?.isPersistable)}}(objectCache,lockManager,json);const closeInstructions=(json.instructions??[]).filter((i=>"close"===i.type)),openInstructions=(json.instructions??[]).filter((i=>"open_form"===i.type)),suspendClosePageUpdate=openInstructions.some((i=>"content"===i.args.FormTarget));if(function(instructions,targetForm,suspendClosePageUpdate){if(0===instructions.length||!targetForm)return;const numberOfPagesToClose=instructions.reduce(((totalPagesToClose,currentInstruction)=>totalPagesToClose+currentInstruction.args.NumberOfPagesToClose),0);if(numberOfPagesToClose<1)throw new AssertionError(`The number of pages to close evaluated to ${numberOfPagesToClose}. It must be at least 1.`);targetForm.setSuspend(!0),targetForm.closePage(numberOfPagesToClose,!0,suspendClosePageUpdate).finally((()=>{targetForm.setSuspend(!1)})).catch((error=>{handleError(error)}))}(closeInstructions,options?.targetForm,suspendClosePageUpdate),await publish(...updates),await async function(instructions,targetForm){const openFormPromises=[],lastOpenPageInstruction=[...instructions].reverse().find((i=>"content"===i.args.FormTarget));for(const instruction of instructions){const location=instruction.args.FormTarget,pageUpdateSuspended="content"===location&&instruction!==lastOpenPageInstruction,ui=getUI();openFormPromises.push(ui.openForm2(instruction.args.FormPath,mapValues(instruction.args.FormParameters,(v=>v??void 0)),instruction.args.FormTitle,targetForm,{location:location,url:instruction.args.FormUrl,queryString:instruction.args.QueryString,width:instruction.args.FormWidth,height:instruction.args.FormHeight,resizable:instruction.args.FormResizable,pageUpdateSuspended:pageUpdateSuspended,preferUnderlyingModalOverLastFocusedElement:!0}))}await Promise.all(openFormPromises)}(openInstructions),await executeNoImpactInstructions(json.instructions),await handleValidations(json.datavalidation),!options?.autoRelease)return release}catch{options?.autoRelease||release()}finally{options?.autoRelease&&release()}}async function handleRuntimeError(objectCache,e,onValidation){if(e instanceof ValidationError){const json=e.original,updates=gatherUpdates(objectCache,json).filter((u=>!("attr"in u)));await publish(...updates),await executeNoImpactInstructions(json.instructions),await handleValidations(json.datavalidation,onValidation)}}async function handleValidations(datavalidations,onValidation){const validations=ObjectValidation.fromResponse(datavalidations??[]);await getData().sendValidationUpdates(validations),validations.length>0&&onValidation&&onValidation(validations)}class SynchronizationError extends HandledError{constructor(message="Could temporarily not synchronize data. Please try again later."){super(message),Object.setPrototypeOf(this,SynchronizationError.prototype)}}class NotImplementedError extends Error{constructor(what=""){super("Not implemented"+(""!==what?": "+what:"")),Object.setPrototypeOf(this,NotImplementedError.prototype)}}class _DataBackend{getByGuid(guids,filter){return Promise.reject(new NotImplementedError("getByGuid"))}getByPath(guid,path,entity,direction){return Promise.reject(new NotImplementedError("getByPath"))}getByXPath(xpath,filter,wantCount){return Promise.reject(new NotImplementedError("getByXPath"))}action(params,context,targetForm,async,onValidation){return Promise.reject(new NotImplementedError("action"))}create(entity){return Promise.reject(new NotImplementedError("create"))}commit(guids,context,targetForm,onValidation){return Promise.reject(new NotImplementedError("commit"))}rollback(guids){return Promise.reject(new NotImplementedError("rollback"))}remove(guids){return Promise.reject(new NotImplementedError("remove"))}validate(guids){return Promise.reject(new NotImplementedError("validate"))}saveDocument(guid,name,params,blob){return Promise.reject(new NotImplementedError("saveDocument"))}getDocumentUrl(guid,changedDate,isThumb){throw new NotImplementedError("getDocumentUrl")}getImageUrl(url){return Promise.reject(new NotImplementedError("getImageUrl"))}cleanup(){return Promise.reject(new NotImplementedError("cleanup"))}}export{METADATA_COLUMNS as $,ASSOCIATION_NAME_COLUMN as A,findDeletableReachableGuidsForRequest as B,CHILD_GUID_COLUMN as C,DB_VALUE_COLUMN as D,findChangedReachableGuidsForRequest as E,handleRuntimeError as F,GUID_COLUMN as G,dehydrateObjectIdCache as H,hydrateObjectIdCache as I,handleRuntimeSuccess as J,findReachableGuidsToRetain as K,createRetryMiddleware as L,METADATA_TABLE as M,DB_VERSION_KEY as N,OfflineToRuntimeGuidMapping as O,PARENT_GUID_COLUMN as P,DB_OFFLINE_METADATA_KEY as Q,RuntimeToOfflineGuidMapping as R,SYNC_ID_COLUMN as S,TABLE_NAME_COLUMN as T,TOMBSTONE_TABLE as U,HAS_CONTENTS_COLUMN as V,CHANGED_DATE_COLUMN as W,DB_NAME_COLUMN as X,READONLY_COLUMN as Y,runtimeToSql as Z,_DataBackend as _,DB_META_TABLE as a,toSqlFilter as a0,fromSafeKey as a1,sqlToRuntime as a2,createUpdateDbMetaValue as a3,createClearDirtyGuidsSqlQueries as a4,createDeleteEntitiesMetaSqlQueries as a5,createUpdateSqlQuery as a6,QueryFilters as a7,createGetDirtyObjectsMetadataSql as a8,convertToSpecializationFilter as a9,createGetEntitiesSql as aa,createGetSyncIdsSqlQueries as ab,NotImplementedError as ac,buildRetainmentGraph as ad,createGetDbMetaValue as b,createUpdateCounterValue as c,ASSOCIATION_TABLE as d,DB_COUNTER_KEY as e,createChunkedQuery as f,createCheckTableExistSqlQuery as g,createMemoizedCache as h,clone as i,getEntityAssociationsReferringTo as j,gatherUpdates as k,getRequestDataForMicroflow as l,getImplicitMicroflowParameters as m,handleRuntimeSuccessResponse as n,executeNoImpactInstructions as o,handleValidations as p,SynchronizationError as q,createMendixGuid as r,syncedObjsRuntimeToOfflineMap as s,toSafeKey as t,actionMatcher as u,createRetryMiddlewarePredicate as v,getRuntimeGuid as w,memoizeConcurrent as x,getRequestData as y,findReachableGuidsForRequest as z};
