import{q as indexByKey,e as ensure,A as AssertionError}from"./D_wx3dK9.js";import{g as getEntityMeta,f as getAttributesMeta,i as isSystemAttribute,S as SystemAttribute,h as deriveEntityId}from"./ChJoRR9k.js";import{n as newId}from"./B1iMrXCs.js";import{g as getSession}from"./Cta-OvjQ.js";import{g as getData,o as offlineData}from"./BdJSoYCn.js";function createChange(json){const meta=ensure(getEntityMeta(json.objectType)),changeEntries=Object.entries(json.attributes).filter((([attrKey,attr])=>meta.attributes[attrKey]?.isSyncable&&!attr.readonly)).map((([attrKey,attr])=>({[attrKey]:{value:attr.value}})));return Object.assign({},...changeEntries)}const SYNC_DURATION_WARNING_THRESHOLD=6e4;function createOfflineGuid(){return"GUID:"+newId()}function isRuntimeGuid(internalGuid){return!internalGuid.startsWith("GUID:")}const indexMxObjectJsonsByGuid=indexByKey((obj=>obj.guid)),indexMxObjectsByGuid=indexByKey((obj=>obj.getGuid()));function createChangeFromIncompatibleObjectsJson(json){const changeEntries=Object.keys(json.attributes).map((attr=>({[attr]:{value:json.attributes[attr]?.value}})));return Object.assign({},...changeEntries)}function isFileDocumentWithContentNonMetaCheck(objectJson){const{attributes:attributes}=objectJson;return["FileID","HasContents","Size"].every((attr=>attr in attributes))&&attributes.HasContents?.value}function getIncompatibleEntities(oldMetadata,newMetadata){const oldMetadataEntityAttributes=extractEntityAttributesMap(oldMetadata),newMetadataEntityAttributes=extractEntityAttributesMap(newMetadata),incompatibleEntities=[];for(const[oldEntity,oldAttributeTypeMap]of oldMetadataEntityAttributes){if(!newMetadataEntityAttributes.has(oldEntity)){incompatibleEntities.push(oldEntity);continue}const newAttrsTypesMap=newMetadataEntityAttributes.get(oldEntity);for(const[oldAttrName,oldAttrType]of oldAttributeTypeMap){const newAttrType=newAttrsTypesMap.get(oldAttrName);if(newAttrType&&newAttrType!==oldAttrType){incompatibleEntities.push(oldEntity);break}}}return new Set(incompatibleEntities);function extractEntityAttributesMap(metadata){return new Map(metadata.map((meta=>[meta.objectType,new Map(Object.entries(meta.attributes).map((([attrName,{type:type}])=>[attrName,type])))])))}}async function getByGuids(guids){return new Promise(((resolve,reject)=>getData().get({guids:guids,callback:resolve,error:reject})))}async function getByGuid(guid){return new Promise(((resolve,reject)=>getData().get({guid:guid,callback(obj){resolve(obj??void 0)},error:reject})))}const DEFAULT_ATTRIBUTE_VALUES={String:null,Integer:null,Long:null,Decimal:null,Enum:null,HashString:null,ObjectReference:null,ObjectReferenceSet:[],DateTime:null,Boolean:!1,AutoNumber:"0",Binary:null,EnumSet:null};function createMxObjectJSON(guid,entityMeta){const json={guid:guid,objectType:entityMeta.name,attributes:{}};return getAttributesMeta(entityMeta.name).forEach((attrMeta=>{const value=!entityMeta.isPersistable&&isSystemAttribute(attrMeta.name)?function(attr){switch(attr){case SystemAttribute.Owner:case SystemAttribute.ChangedBy:return getSession().getUserId();case SystemAttribute.CreatedDate:case SystemAttribute.ChangedDate:return Date.now()}}(attrMeta.name):void 0===attrMeta.defaultValue?DEFAULT_ATTRIBUTE_VALUES[attrMeta.type]:"DateTime"===attrMeta.type&&"[%CurrentDateTime%]"===attrMeta.defaultValue?(new Date).getTime():attrMeta.defaultValue;json.attributes[attrMeta.name]={value:value,readonly:attrMeta.isAlwaysReadOnly}})),json}function getCachedObjectsByPath(guid,direction,path,objectCache){let cachedObjects=[],uncachedGuids=[];const association=getAssociationStep(path);if("reverse"===direction)cachedObjects=objectCache.getAllObjects().filter((mxobj=>mxobj.getReferences(association).includes(guid)));else{const rootMxObj=objectCache.getObject(guid);rootMxObj&&({cachedObjects:cachedObjects,uncachedGuids:uncachedGuids}=getRefsObjects(rootMxObj,objectCache,association))}return{cachedObjects:cachedObjects,uncachedGuids:uncachedGuids}}function getRefsObjects(rootMxObj,objectCache,association){const refGuids=rootMxObj.getReferences(association);return{cachedObjects:refGuids.map((refGuid=>objectCache.getObject(refGuid))).filter((mxobj=>null!==mxobj)),uncachedGuids:refGuids.filter((refGuid=>!objectCache.has(refGuid)))}}function getAssociationStep(path){const steps=path.split("/");return 1===steps.length?path:steps[0]}function deriveEntityUnchecked(id){const entityId=deriveEntityId(id),entity=getEntityMeta(entityId);return entity?.name}function deriveEntity(id){const entity=deriveEntityUnchecked(id);if(void 0===entity)throw new AssertionError(`Can't find entity for guid '${id}'`);return entity}function isObjectOffline(id){if(isRuntimeGuid(id)){const entity=deriveEntityUnchecked(id);return void 0!==entity&&mx.isOffline(entity)}return!0}function isOffline(entity){return getSession().isOffline()&&!(entity&&offlineData().hasOnlineSyncMode(entity))}export{SYNC_DURATION_WARNING_THRESHOLD as S,getByGuids as a,isFileDocumentWithContentNonMetaCheck as b,createChange as c,createChangeFromIncompatibleObjectsJson as d,indexMxObjectsByGuid as e,indexMxObjectJsonsByGuid as f,getByGuid as g,deriveEntity as h,isRuntimeGuid as i,createOfflineGuid as j,createMxObjectJSON as k,getAssociationStep as l,getCachedObjectsByPath as m,getRefsObjects as n,isOffline as o,isObjectOffline as p,getIncompatibleEntities as q,deriveEntityUnchecked as r};
