"use strict";

import { PlatformPressable } from '@react-navigation/elements';
import { DrawerActions, useNavigation } from '@react-navigation/native';
import { Image, Platform, StyleSheet } from 'react-native';
import toggleDrawerIcon from './assets/toggle-drawer-icon.png';
import { jsx as _jsx } from "react/jsx-runtime";
export function DrawerToggleButton({
  tintColor,
  accessibilityLabel = 'Show navigation menu',
  ...rest
}) {
  const navigation = useNavigation();
  return /*#__PURE__*/_jsx(PlatformPressable, {
    ...rest,
    accessibilityLabel: accessibilityLabel,
    android_ripple: {
      borderless: true
    },
    onPress: () => navigation.dispatch(DrawerActions.toggleDrawer()),
    style: styles.touchable,
    hitSlop: Platform.select({
      ios: undefined,
      default: {
        top: 16,
        right: 16,
        bottom: 16,
        left: 16
      }
    }),
    children: /*#__PURE__*/_jsx(Image, {
      resizeMode: "contain",
      source: toggleDrawerIcon,
      fadeDuration: 0,
      tintColor: tintColor,
      style: styles.icon
    })
  });
}
const styles = StyleSheet.create({
  icon: {
    height: 24,
    width: 24,
    marginVertical: 8,
    marginHorizontal: 13
  },
  touchable: {
    // Roundness for iPad hover effect
    borderRadius: 10
  }
});
//# sourceMappingURL=DrawerToggleButton.js.map