"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawerToggleButton = DrawerToggleButton;
var _elements = require("@react-navigation/elements");
var _native = require("@react-navigation/native");
var _reactNative = require("react-native");
var _toggleDrawerIcon = _interopRequireDefault(require("./assets/toggle-drawer-icon.png"));
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DrawerToggleButton({
  tintColor,
  accessibilityLabel = 'Show navigation menu',
  ...rest
}) {
  const navigation = (0, _native.useNavigation)();
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_elements.PlatformPressable, {
    ...rest,
    accessibilityLabel: accessibilityLabel,
    android_ripple: {
      borderless: true
    },
    onPress: () => navigation.dispatch(_native.DrawerActions.toggleDrawer()),
    style: styles.touchable,
    hitSlop: _reactNative.Platform.select({
      ios: undefined,
      default: {
        top: 16,
        right: 16,
        bottom: 16,
        left: 16
      }
    }),
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Image, {
      resizeMode: "contain",
      source: _toggleDrawerIcon.default,
      fadeDuration: 0,
      tintColor: tintColor,
      style: styles.icon
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  icon: {
    height: 24,
    width: 24,
    marginVertical: 8,
    marginHorizontal: 13
  },
  touchable: {
    // Roundness for iPad hover effect
    borderRadius: 10
  }
});
//# sourceMappingURL=DrawerToggleButton.js.map