"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawerItemList = DrawerItemList;
var _native = require("@react-navigation/native");
var React = _interopRequireWildcard(require("react"));
var _DrawerItem = require("./DrawerItem.js");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component that renders the navigation list in the drawer.
 */
function DrawerItemList({
  state,
  navigation,
  descriptors
}) {
  const {
    buildHref
  } = (0, _native.useLinkBuilder)();
  const focusedRoute = state.routes[state.index];
  const focusedDescriptor = descriptors[focusedRoute.key];
  const focusedOptions = focusedDescriptor.options;
  const {
    drawerActiveTintColor,
    drawerInactiveTintColor,
    drawerActiveBackgroundColor,
    drawerInactiveBackgroundColor
  } = focusedOptions;
  return state.routes.map((route, i) => {
    const focused = i === state.index;
    const onPress = () => {
      const event = navigation.emit({
        type: 'drawerItemPress',
        target: route.key,
        canPreventDefault: true
      });
      if (!event.defaultPrevented) {
        navigation.dispatch({
          ...(focused ? _native.DrawerActions.closeDrawer() : _native.CommonActions.navigate(route)),
          target: state.key
        });
      }
    };
    const {
      title,
      drawerLabel,
      drawerIcon,
      drawerLabelStyle,
      drawerItemStyle,
      drawerAllowFontScaling
    } = descriptors[route.key].options;
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(_DrawerItem.DrawerItem, {
      route: route,
      href: buildHref(route.name, route.params),
      label: drawerLabel !== undefined ? drawerLabel : title !== undefined ? title : route.name,
      icon: drawerIcon,
      focused: focused,
      activeTintColor: drawerActiveTintColor,
      inactiveTintColor: drawerInactiveTintColor,
      activeBackgroundColor: drawerActiveBackgroundColor,
      inactiveBackgroundColor: drawerInactiveBackgroundColor,
      allowFontScaling: drawerAllowFontScaling,
      labelStyle: drawerLabelStyle,
      style: drawerItemStyle,
      onPress: onPress
    }, route.key);
  });
}
//# sourceMappingURL=DrawerItemList.js.map