"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawerItem = DrawerItem;
var _elements = require("@react-navigation/elements");
var _native = require("@react-navigation/native");
var _color = _interopRequireDefault(require("color"));
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A component used to show an action item with an icon and a label in a navigation drawer.
 */
function DrawerItem(props) {
  const {
    colors,
    fonts
  } = (0, _native.useTheme)();
  const {
    href,
    icon,
    label,
    labelStyle,
    focused = false,
    allowFontScaling,
    // eslint-disable-next-line @eslint-react/no-unstable-default-props
    activeTintColor = colors.primary,
    // eslint-disable-next-line @eslint-react/no-unstable-default-props
    inactiveTintColor = (0, _color.default)(colors.text).alpha(0.68).rgb().string(),
    // eslint-disable-next-line @eslint-react/no-unstable-default-props
    activeBackgroundColor = (0, _color.default)(activeTintColor).alpha(0.12).rgb().string(),
    inactiveBackgroundColor = 'transparent',
    style,
    onPress,
    pressColor,
    pressOpacity = 1,
    testID,
    accessibilityLabel,
    ...rest
  } = props;
  const {
    borderRadius = 56
  } = _reactNative.StyleSheet.flatten(style || {});
  const color = focused ? activeTintColor : inactiveTintColor;
  const backgroundColor = focused ? activeBackgroundColor : inactiveBackgroundColor;
  const iconNode = icon ? icon({
    size: 24,
    focused,
    color
  }) : null;
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    collapsable: false,
    ...rest,
    style: [styles.container, {
      borderRadius,
      backgroundColor
    }, style],
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_elements.PlatformPressable, {
      testID: testID,
      onPress: onPress,
      accessibilityLabel: accessibilityLabel,
      accessibilityRole: "button",
      accessibilityState: {
        selected: focused
      },
      pressColor: pressColor,
      pressOpacity: pressOpacity,
      hoverEffect: {
        color
      },
      href: href,
      children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
        style: [styles.wrapper, {
          borderRadius
        }],
        children: [iconNode, /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [styles.label, {
            marginStart: iconNode ? 12 : 0
          }],
          children: typeof label === 'string' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_elements.Text, {
            numberOfLines: 1,
            allowFontScaling: allowFontScaling,
            style: [styles.labelText, {
              color
            }, fonts.medium, labelStyle],
            children: label
          }) : label({
            color,
            focused
          })
        })]
      })
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  container: {
    overflow: 'hidden'
  },
  wrapper: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 11,
    paddingStart: 16,
    paddingEnd: 24
  },
  label: {
    marginEnd: 12,
    marginVertical: 4,
    flex: 1
  },
  labelText: {
    lineHeight: 24,
    textAlignVertical: 'center'
  }
});
//# sourceMappingURL=DrawerItem.js.map