"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawerContentScrollView = void 0;
var _native = require("@react-navigation/native");
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _DrawerPositionContext = require("../utils/DrawerPositionContext.js");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SPACING = 12;
function DrawerContentScrollViewInner({
  contentContainerStyle,
  style,
  children,
  ...rest
}, ref) {
  const drawerPosition = React.useContext(_DrawerPositionContext.DrawerPositionContext);
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const {
    direction
  } = (0, _native.useLocale)();
  const isRight = direction === 'rtl' ? drawerPosition === 'left' : drawerPosition === 'right';
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.ScrollView, {
    ...rest,
    ref: ref,
    contentContainerStyle: [{
      paddingTop: SPACING + insets.top,
      paddingBottom: SPACING + insets.bottom,
      paddingStart: SPACING + (!isRight ? insets.left : 0),
      paddingEnd: SPACING + (isRight ? insets.right : 0)
    }, contentContainerStyle],
    style: [styles.container, style],
    children: children
  });
}
const DrawerContentScrollView = exports.DrawerContentScrollView = /*#__PURE__*/React.forwardRef(DrawerContentScrollViewInner);
const styles = _reactNative.StyleSheet.create({
  container: {
    flex: 1
  }
});
//# sourceMappingURL=DrawerContentScrollView.js.map