"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationIndependentTree = NavigationIndependentTree;
var React = _interopRequireWildcard(require("react"));
var _NavigationContext = require("./NavigationContext.js");
var _NavigationIndependentTreeContext = require("./NavigationIndependentTreeContext.js");
var _NavigationRouteContext = require("./NavigationRouteContext.js");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component to make the child navigation container independent of parent containers.
 */
function NavigationIndependentTree({
  children
}) {
  return (
    /*#__PURE__*/
    // We need to clear any existing contexts for nested independent container to work correctly
    (0, _jsxRuntime.jsx)(_NavigationRouteContext.NavigationRouteContext.Provider, {
      value: undefined,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_NavigationContext.NavigationContext.Provider, {
        value: undefined,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_NavigationIndependentTreeContext.NavigationIndependentTreeContext.Provider, {
          value: true,
          children: children
        })
      })
    })
  );
}
//# sourceMappingURL=NavigationIndependentTree.js.map