type StorageOptions = {
    location?: string;
    encryptionKey?: string;
};
/**
 * Creates a new async-storage api compatible instance.
 * The encryption key is only used when compiled against the SQLCipher version of op-sqlite.
 */
export declare class Storage {
    private db;
    constructor(options: StorageOptions);
    getItem(key: string): Promise<string | undefined>;
    getItemSync(key: string): string | undefined;
    setItem(key: string, value: string): Promise<void>;
    setItemSync(key: string, value: string): void;
    removeItem(key: string): Promise<void>;
    removeItemSync(key: string): void;
    clear(): Promise<void>;
    clearSync(): void;
    getAllKeys(): any[];
}
export {};
//# sourceMappingURL=Storage.d.ts.map