CREATE MEMORY TABLE PUBLIC."mendixsystem$entity"("id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"entity_name" VARCHAR(511) COLLATE SQL_TEXT_UCC NOT NULL,"table_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"superentity_id" VARCHAR(255) COLLATE SQL_TEXT_UCC)
CREATE INDEX "idx_mendixsystem$entity_entity_name" ON PUBLIC."mendixsystem$entity"("entity_name")
CREATE MEMORY TABLE PUBLIC."mendixsystem$attribute"("id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"entity_id" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"attribute_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"column_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"type" INTEGER NOT NULL,"length" INTEGER,"default_value" VARCHAR(2147483647) COLLATE SQL_TEXT_UCC,"is_auto_number" BOOLEAN NOT NULL)
CREATE MEMORY TABLE PUBLIC."mendixsystem$index"("id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"table_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"index_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL)
CREATE MEMORY TABLE PUBLIC."mendixsystem$index_column"("index_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"column_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"sort_order" BOOLEAN NOT NULL,"ordinal" INTEGER NOT NULL,PRIMARY KEY("index_id","column_id"))
CREATE MEMORY TABLE PUBLIC."mendixsystem$association"("id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"association_name" VARCHAR(511) COLLATE SQL_TEXT_UCC NOT NULL,"table_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"parent_entity_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"child_entity_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"parent_column_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"child_column_name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"pk_index_name" VARCHAR(255) COLLATE SQL_TEXT_UCC,"index_name" VARCHAR(255) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."mendixsystem$version"("versionnumber" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"lastsyncdate" TIMESTAMP NOT NULL,"preanalysismigrationversionnumber" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"modelversionnumber" VARCHAR(255) COLLATE SQL_TEXT_UCC,"sprintrprojectname" VARCHAR(511) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."mendixsystem$sequence"("name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"attribute_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"start_value" BIGINT NOT NULL,"current_value" BIGINT)
CREATE INDEX "idx_mendixsystem$sequence_name" ON PUBLIC."mendixsystem$sequence"("name")
CREATE MEMORY TABLE PUBLIC."mendixsystem$entityidentifier"("id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"short_id" SMALLINT,"object_sequence" BIGINT)
CREATE INDEX "idx_mendixsystem$entityidentifier_short_id" ON PUBLIC."mendixsystem$entityidentifier"("short_id")
CREATE MEMORY TABLE PUBLIC."mendixsystem$properties"("key" VARCHAR(200) COLLATE SQL_TEXT_UCC NOT NULL PRIMARY KEY,"value" VARCHAR(200) COLLATE SQL_TEXT_UCC NOT NULL)
CREATE MEMORY TABLE PUBLIC."mendixsystem$unique_constraint"("name" VARCHAR(255) COLLATE SQL_TEXT_UCC NOT NULL,"table_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,"column_id" VARCHAR(36) COLLATE SQL_TEXT_UCC NOT NULL,PRIMARY KEY("name","column_id"))
CREATE MEMORY TABLE PUBLIC."system$filedocument"("id" BIGINT NOT NULL PRIMARY KEY,"__uuid__" VARCHAR(36) COLLATE SQL_TEXT_UCC,"deleteafterdownload" BOOLEAN,"changeddate" TIMESTAMP,"contents" VARBINARY(16777216),"createddate" TIMESTAMP,"size" BIGINT,"hascontents" BOOLEAN,"fileid" BIGINT,"__filename__" BIGINT,"name" VARCHAR(400) COLLATE SQL_TEXT_UCC,"submetaobjectname" VARCHAR(255) COLLATE SQL_TEXT_UCC,"system$owner" BIGINT,"system$changedby" BIGINT)
CREATE INDEX "idx_system$filedocument_fileid_asc" ON PUBLIC."system$filedocument"("fileid","id")
CREATE INDEX "idx_system$filedocument_size_asc" ON PUBLIC."system$filedocument"("size","id")
CREATE INDEX "idx_system$filedocument_submetaobjectname_asc" ON PUBLIC."system$filedocument"("submetaobjectname","id")
CREATE INDEX "idx_system$filedocument_system$owner" ON PUBLIC."system$filedocument"("system$owner","id")
CREATE INDEX "idx_system$filedocument_system$changedby" ON PUBLIC."system$filedocument"("system$changedby","id")
CREATE MEMORY TABLE PUBLIC."system$user"("id" BIGINT NOT NULL PRIMARY KEY,"changeddate" TIMESTAMP,"active" BOOLEAN,"createddate" TIMESTAMP,"lastlogin" TIMESTAMP,"webserviceuser" BOOLEAN,"isanonymous" BOOLEAN,"failedlogins" INTEGER,"blocked" BOOLEAN,"name" VARCHAR(100) COLLATE SQL_TEXT_UCC,"password" VARCHAR(200) COLLATE SQL_TEXT_UCC,"system$changedby" BIGINT,"system$owner" BIGINT,CONSTRAINT "uniq_system$user_name" UNIQUE("name"))
CREATE INDEX "idx_system$user_name_asc" ON PUBLIC."system$user"("name","id")
CREATE INDEX "idx_system$user_system$changedby" ON PUBLIC."system$user"("system$changedby","id")
CREATE INDEX "idx_system$user_system$owner" ON PUBLIC."system$user"("system$owner","id")
CREATE MEMORY TABLE PUBLIC."system$user_timezone"("system$userid" BIGINT NOT NULL,"system$timezoneid" BIGINT NOT NULL,PRIMARY KEY("system$userid","system$timezoneid"),CONSTRAINT "uniq_system$user_timezone_system$userid" UNIQUE("system$userid"))
CREATE INDEX "idx_system$user_timezone_system$timezone_system$user" ON PUBLIC."system$user_timezone"("system$timezoneid","system$userid")
CREATE MEMORY TABLE PUBLIC."system$userroles"("system$userid" BIGINT NOT NULL,"system$userroleid" BIGINT NOT NULL,PRIMARY KEY("system$userid","system$userroleid"))
CREATE INDEX "idx_system$userroles_system$userrole_system$user" ON PUBLIC."system$userroles"("system$userroleid","system$userid")
CREATE MEMORY TABLE PUBLIC."system$user_language"("system$userid" BIGINT NOT NULL,"system$languageid" BIGINT NOT NULL,PRIMARY KEY("system$userid","system$languageid"),CONSTRAINT "uniq_system$user_language_system$userid" UNIQUE("system$userid"))
CREATE INDEX "idx_system$user_language_system$language_system$user" ON PUBLIC."system$user_language"("system$languageid","system$userid")
CREATE MEMORY TABLE PUBLIC."system$xasinstance"("id" BIGINT NOT NULL PRIMARY KEY,"xasid" VARCHAR(50) COLLATE SQL_TEXT_UCC,"createddate" TIMESTAMP,"lastupdate" TIMESTAMP,"allowednumberofconcurrentusers" INTEGER,"customername" VARCHAR(200) COLLATE SQL_TEXT_UCC,"partnername" VARCHAR(200) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$thumbnail"("id" BIGINT NOT NULL PRIMARY KEY)
CREATE MEMORY TABLE PUBLIC."system$thumbnail_image"("system$thumbnailid" BIGINT NOT NULL,"system$imageid" BIGINT NOT NULL,PRIMARY KEY("system$thumbnailid","system$imageid"),CONSTRAINT "uniq_system$thumbnail_image_system$imageid" UNIQUE("system$imageid"),CONSTRAINT "uniq_system$thumbnail_image_system$thumbnailid" UNIQUE("system$thumbnailid"))
CREATE INDEX "idx_system$thumbnail_image_system$image_system$thumbnail" ON PUBLIC."system$thumbnail_image"("system$imageid","system$thumbnailid")
CREATE MEMORY TABLE PUBLIC."system$backgroundjob"("id" BIGINT NOT NULL PRIMARY KEY,"endtime" TIMESTAMP,"starttime" TIMESTAMP,"successful" BOOLEAN,"jobid" BIGINT,"result" VARCHAR(2147483647) COLLATE SQL_TEXT_UCC)
CREATE INDEX "idx_system$backgroundjob_jobid_asc" ON PUBLIC."system$backgroundjob"("jobid","id")
CREATE MEMORY TABLE PUBLIC."system$backgroundjob_xasinstance"("system$backgroundjobid" BIGINT NOT NULL,"system$xasinstanceid" BIGINT NOT NULL,PRIMARY KEY("system$backgroundjobid","system$xasinstanceid"),CONSTRAINT "uniq_system$backgroundjob_xasinstance_system$backgroundjobid" UNIQUE("system$backgroundjobid"))
CREATE INDEX "idx_system$backgroundjob_xasinstance_system$xasinstance_system$backgroundjob" ON PUBLIC."system$backgroundjob_xasinstance"("system$xasinstanceid","system$backgroundjobid")
CREATE MEMORY TABLE PUBLIC."system$backgroundjob_session"("system$backgroundjobid" BIGINT NOT NULL,"system$sessionid" BIGINT NOT NULL,PRIMARY KEY("system$backgroundjobid","system$sessionid"),CONSTRAINT "uniq_system$backgroundjob_session_system$backgroundjobid" UNIQUE("system$backgroundjobid"))
CREATE INDEX "idx_system$backgroundjob_session_system$session_system$backgroundjob" ON PUBLIC."system$backgroundjob_session"("system$sessionid","system$backgroundjobid")
CREATE MEMORY TABLE PUBLIC."system$scheduledeventinformation"("id" BIGINT NOT NULL PRIMARY KEY,"status" VARCHAR(9) COLLATE SQL_TEXT_UCC,"description" VARCHAR(2147483647) COLLATE SQL_TEXT_UCC,"endtime" TIMESTAMP,"starttime" TIMESTAMP,"name" VARCHAR(200) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$privatefiledocument"("id" BIGINT NOT NULL PRIMARY KEY)
CREATE MEMORY TABLE PUBLIC."system$userreportinfo"("id" BIGINT NOT NULL PRIMARY KEY,"hash" VARCHAR(64) COLLATE SQL_TEXT_UCC,"usertype" VARCHAR(8) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$userreportinfo_user"("system$userreportinfoid" BIGINT NOT NULL,"system$userid" BIGINT NOT NULL,PRIMARY KEY("system$userreportinfoid","system$userid"),CONSTRAINT "uniq_system$userreportinfo_user_system$userreportinfoid" UNIQUE("system$userreportinfoid"))
CREATE INDEX "idx_system$userreportinfo_user_system$user_system$userreportinfo" ON PUBLIC."system$userreportinfo_user"("system$userid","system$userreportinfoid")
CREATE MEMORY TABLE PUBLIC."system$timezone"("id" BIGINT NOT NULL PRIMARY KEY,"description" VARCHAR(100) COLLATE SQL_TEXT_UCC,"rawoffset" INTEGER,"code" VARCHAR(50) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$userrole"("id" BIGINT NOT NULL PRIMARY KEY,"modelguid" VARCHAR(36) COLLATE SQL_TEXT_UCC,"description" VARCHAR(1000) COLLATE SQL_TEXT_UCC,"name" VARCHAR(100) COLLATE SQL_TEXT_UCC)
CREATE INDEX "idx_system$userrole_name_asc" ON PUBLIC."system$userrole"("name","id")
CREATE MEMORY TABLE PUBLIC."system$grantableroles"("system$userroleid1" BIGINT NOT NULL,"system$userroleid2" BIGINT NOT NULL,PRIMARY KEY("system$userroleid1","system$userroleid2"))
CREATE INDEX "idx_system$grantableroles_system$userrole_system$userrole" ON PUBLIC."system$grantableroles"("system$userroleid2","system$userroleid1")
CREATE MEMORY TABLE PUBLIC."system$session"("id" BIGINT NOT NULL PRIMARY KEY,"readonlyhashkey" VARCHAR(36) COLLATE SQL_TEXT_UCC,"createddate" TIMESTAMP,"csrftoken" VARCHAR(36) COLLATE SQL_TEXT_UCC,"lastactive" TIMESTAMP,"sessionid" VARCHAR(50) COLLATE SQL_TEXT_UCC)
CREATE INDEX "idx_system$session_sessionid_asc" ON PUBLIC."system$session"("sessionid","id")
CREATE MEMORY TABLE PUBLIC."system$session_user"("system$sessionid" BIGINT NOT NULL,"system$userid" BIGINT NOT NULL,PRIMARY KEY("system$sessionid","system$userid"),CONSTRAINT "uniq_system$session_user_system$sessionid" UNIQUE("system$sessionid"))
CREATE INDEX "idx_system$session_user_system$user_system$session" ON PUBLIC."system$session_user"("system$userid","system$sessionid")
CREATE MEMORY TABLE PUBLIC."system$tokeninformation"("id" BIGINT NOT NULL PRIMARY KEY,"expirydate" TIMESTAMP,"useragent" VARCHAR(2147483647) COLLATE SQL_TEXT_UCC,"token" VARCHAR(200) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$tokeninformation_user"("system$tokeninformationid" BIGINT NOT NULL,"system$userid" BIGINT NOT NULL,PRIMARY KEY("system$tokeninformationid","system$userid"),CONSTRAINT "uniq_system$tokeninformation_user_system$tokeninformationid" UNIQUE("system$tokeninformationid"))
CREATE INDEX "idx_system$tokeninformation_user_system$user_system$tokeninformation" ON PUBLIC."system$tokeninformation_user"("system$userid","system$tokeninformationid")
CREATE MEMORY TABLE PUBLIC."system$image"("id" BIGINT NOT NULL PRIMARY KEY,"publicthumbnailpath" VARCHAR(500) COLLATE SQL_TEXT_UCC)
CREATE MEMORY TABLE PUBLIC."system$autocommitentry"("id" BIGINT NOT NULL PRIMARY KEY,"createddate" TIMESTAMP,"objectid" BIGINT,"sessionid" VARCHAR(36) COLLATE SQL_TEXT_UCC)
CREATE INDEX "idx_system$autocommitentry_sessionid_asc_objectid_asc" ON PUBLIC."system$autocommitentry"("sessionid","objectid","id")
CREATE MEMORY TABLE PUBLIC."system$language"("id" BIGINT NOT NULL PRIMARY KEY,"description" VARCHAR(200) COLLATE SQL_TEXT_UCC,"code" VARCHAR(20) COLLATE SQL_TEXT_UCC)
