/**
 * @callback eventHandler
 * @param {object} event Message event data 
 */

/**
 * Registers a message listener that notifies the frontend of messages comming in from Studio Pro 
 * @param {eventHandler} eventHandler A callback function that is supposed to fire as soon a message comes in
 */
function registerMessageListener(eventHandler) {
    if (window.chrome?.webview) {
        window.chrome.webview.addEventListener("message", (event) => eventHandler(event.data))
        sendMessage("MessageListenerRegistered")
    } else if (window.webkit?.messageHandlers.studioPro) {
        window.WKPostMessage = (json) => {
            const wkMessage = JSON.parse(json)
            eventHandler(wkMessage)
        }
        sendMessage("MessageListenerRegistered")
    }
}

/**
 * Sends a message through to StudioPro ignoring the platform we're using at the moment
 * @param {string} message Message text
 * @param {object} [data] Object containing message's data 
 */
function sendMessage(message, data) {
    if (window.chrome?.webview) {
        window.chrome.webview.postMessage({ message, data })
    } else if (window.webkit?.messageHandlers.studioPro) {
        window.webkit.messageHandlers.studioPro.postMessage(JSON.stringify({ message, data }))
    }
}