/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.v3.processes.HealthCheckType;
import org.cloudfoundry.operations.applications.ApplicationManifestUtilsCommon;
import org.cloudfoundry.operations.applications.ManifestV3;
import org.cloudfoundry.operations.applications.ManifestV3Application;
import org.cloudfoundry.operations.applications.ManifestV3Process;
import org.cloudfoundry.operations.applications.ManifestV3Service;
import org.cloudfoundry.operations.applications.ManifestV3Sidecar;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import reactor.core.Exceptions;

public final class ApplicationManifestUtilsV3
extends ApplicationManifestUtilsCommon {
    private static final Yaml YAML;
    private static final Pattern FIND_VARIABLE_REGEX;

    private ApplicationManifestUtilsV3() {
    }

    public static ManifestV3 read(Path path) {
        return ApplicationManifestUtilsV3.doRead(path.toAbsolutePath(), Collections.emptyMap());
    }

    public static ManifestV3 read(Path path, Path variablesPath) {
        Map<String, String> variables = ApplicationManifestUtilsV3.deserialize(variablesPath.toAbsolutePath()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        return ApplicationManifestUtilsV3.doRead(path.toAbsolutePath(), variables);
    }

    public static void write(Path path, ManifestV3 manifest) {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ApplicationManifestUtilsV3.write(out, manifest);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void write(OutputStream out, ManifestV3 manifest) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out);){
            YAML.dump(ApplicationManifestUtilsV3.toYaml(manifest), (Writer)writer);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static ManifestV3 doRead(Path path, Map<String, String> variables) {
        Map<String, Object> root = ApplicationManifestUtilsV3.deserialize(path);
        ManifestV3.Builder builder = ManifestV3.builder();
        ApplicationManifestUtilsV3.asInteger(root, "version", variables, builder::version);
        ManifestV3Application template = ApplicationManifestUtilsV3.getTemplate(path, root, variables);
        Optional.ofNullable(root.get("applications")).map(value -> ((List)value).stream()).orElseGet(Stream::empty).map(application -> {
            String name = ApplicationManifestUtilsV3.getName(application);
            return ApplicationManifestUtilsV3.toApplicationManifest(application, variables, ManifestV3Application.builder().from(template), path).name(name).build();
        }).forEach(builder::application);
        return builder.build();
    }

    private static ManifestV3Application getTemplate(Path path, Map<String, Object> root, Map<String, String> variables) {
        return ApplicationManifestUtilsV3.toApplicationManifest(root, variables, ManifestV3Application.builder(), path).name("template").build();
    }

    private static ManifestV3Application.Builder toApplicationManifest(Map<String, Object> application, Map<String, String> variables, ManifestV3Application.Builder builder, Path root) {
        ApplicationManifestUtilsV3.toApplicationManifestCommon(application, variables, builder, root);
        ApplicationManifestUtilsV3.asList(application, "processes", variables, raw -> ApplicationManifestUtilsV3.getProcess((Map)raw, variables), builder::processe);
        ApplicationManifestUtilsV3.asList(application, "services", variables, raw -> ApplicationManifestUtilsV3.getService(raw, variables), builder::service);
        ApplicationManifestUtilsV3.asList(application, "sidecars", variables, raw -> ApplicationManifestUtilsV3.getSidecar((Map)raw, variables), builder::sidecar);
        ApplicationManifestUtilsV3.as(application, "labels", variables, Map.class::cast, builder::labels);
        ApplicationManifestUtilsV3.as(application, "annotations", variables, Map.class::cast, builder::annotations);
        ApplicationManifestUtilsV3.asBoolean(application, "default-route", variables, builder::defaultRoute);
        return builder;
    }

    private static ManifestV3Sidecar getSidecar(Map<String, Object> raw, Map<String, String> variables) {
        ManifestV3Sidecar.Builder builder = ManifestV3Sidecar.builder();
        ApplicationManifestUtilsV3.asString(raw, "name", variables, builder::name);
        ApplicationManifestUtilsV3.asString(raw, "command", variables, builder::command);
        ApplicationManifestUtilsV3.asListOfString(raw, "process_types", variables, builder::processType);
        ApplicationManifestUtilsV3.asInteger(raw, "memory", variables, builder::memory);
        return builder.build();
    }

    private static ManifestV3Process getProcess(Map<String, Object> raw, Map<String, String> variables) {
        ManifestV3Process.Builder builder = ManifestV3Process.builder();
        ApplicationManifestUtilsV3.asString(raw, "type", variables, builder::type);
        ApplicationManifestUtilsV3.asString(raw, "command", variables, builder::command);
        ApplicationManifestUtilsV3.asString(raw, "disk", variables, builder::disk);
        ApplicationManifestUtilsV3.asString(raw, "health-check-http-endpoint", variables, builder::healthCheckHttpEndpoint);
        ApplicationManifestUtilsV3.asInteger(raw, "health-check-invocation-timeout", variables, builder::healthCheckInvocationTimeout);
        ApplicationManifestUtilsV3.as(raw, "health-check-type", variables, s -> HealthCheckType.from((String)((String)s)), builder::healthCheckType);
        ApplicationManifestUtilsV3.asInteger(raw, "instances", variables, builder::instances);
        ApplicationManifestUtilsV3.asString(raw, "memory", variables, builder::memory);
        ApplicationManifestUtilsV3.asInteger(raw, "timeout", variables, builder::timeout);
        return builder.build();
    }

    private static ManifestV3Service getService(Object raw, Map<String, String> variables) {
        ManifestV3Service.Builder builder = ManifestV3Service.builder();
        if (raw instanceof String) {
            builder.name((String)raw);
        } else if (raw instanceof Map) {
            Map map = (Map)raw;
            ApplicationManifestUtilsV3.asString(map, "name", variables, builder::name);
            ApplicationManifestUtilsV3.asString(map, "bindingName", variables, builder::bindingName);
            builder.parameters(map.get("parameters"));
        }
        return builder.build();
    }

    private static Map<String, Object> toYaml(ManifestV3 manifest) {
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        yaml.put("version", manifest.getVersion());
        yaml.put("applications", ApplicationManifestUtilsV3.convertCollection(manifest.getApplications(), ApplicationManifestUtilsV3::toApplicationYaml));
        return yaml;
    }

    private static Map<String, Object> toApplicationYaml(ManifestV3Application application) {
        Map<String, Object> yaml = ApplicationManifestUtilsCommon.toApplicationYaml(application);
        ApplicationManifestUtilsV3.putIfPresent(yaml, "processes", ApplicationManifestUtilsV3.convertCollection(application.getProcesses(), ApplicationManifestUtilsV3::toProcessYaml));
        ApplicationManifestUtilsV3.putIfPresent(yaml, "default-route", application.getDefaultRoute());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "services", ApplicationManifestUtilsV3.convertCollection(application.getServices(), ApplicationManifestUtilsV3::toServiceYaml));
        ApplicationManifestUtilsV3.putIfPresent(yaml, "sidecars", ApplicationManifestUtilsV3.convertCollection(application.getSidecars(), ApplicationManifestUtilsV3::toSidecarsYaml));
        ApplicationManifestUtilsV3.putIfPresent(yaml, "labels", application.getLabels());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "annotations", application.getAnnotations());
        return yaml;
    }

    private static Map<String, Object> toSidecarsYaml(ManifestV3Sidecar sidecar) {
        if (sidecar == null) {
            return null;
        }
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtilsV3.putIfPresent(yaml, "name", sidecar.getName());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "command", sidecar.getCommand());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "process_types", sidecar.getProcessTypes());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "memory", sidecar.getMemory());
        return yaml;
    }

    private static Map<String, Object> toServiceYaml(ManifestV3Service service) {
        if (service == null) {
            return null;
        }
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtilsV3.putIfPresent(yaml, "name", service.getName());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "binding_name", service.getBindingName());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "parameters", service.getParameters());
        return yaml;
    }

    private static Map<String, Object> toProcessYaml(ManifestV3Process process) {
        if (process == null) {
            return null;
        }
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtilsV3.putIfPresent(yaml, "type", process.getType());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "command", process.getCommand());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "disk_quota", process.getDisk());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "health-check-http-endpoint", process.getHealthCheckHttpEndpoint());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "health-check-invocation-timeout", process.getHealthCheckInvocationTimeout());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "health-check-type", process.getHealthCheckType());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "instances", process.getInstances());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "memory", process.getMemory());
        ApplicationManifestUtilsV3.putIfPresent(yaml, "timeout", process.getTimeout());
        return yaml;
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setExplicitStart(true);
        YAML = new Yaml(dumperOptions);
        FIND_VARIABLE_REGEX = Pattern.compile("\\(\\(([a-zA-Z]\\w+)\\)\\)");
    }
}

