/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationManifestUtilsCommon;
import reactor.core.Exceptions;

public final class ApplicationManifestUtils
extends ApplicationManifestUtilsCommon {
    private ApplicationManifestUtils() {
    }

    public static List<ApplicationManifest> read(Path path) {
        return ApplicationManifestUtils.doRead(path.toAbsolutePath(), Collections.emptyMap());
    }

    public static List<ApplicationManifest> read(Path path, Path variablesPath) {
        Map<String, String> variables = ApplicationManifestUtils.deserialize(variablesPath.toAbsolutePath()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        return ApplicationManifestUtils.doRead(path.toAbsolutePath(), variables);
    }

    public static void write(Path path, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(path, Arrays.asList(applicationManifests));
    }

    public static void write(Path path, List<ApplicationManifest> applicationManifests) {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ApplicationManifestUtils.write(out, applicationManifests);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void write(OutputStream out, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(out, Arrays.asList(applicationManifests));
    }

    public static void write(OutputStream out, List<ApplicationManifest> applicationManifests) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out);){
            YAML.dump(Collections.singletonMap("applications", applicationManifests.stream().map(ApplicationManifestUtils::toYaml).collect(Collectors.toList())), (Writer)writer);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static ApplicationManifest getTemplate(Path path, Map<String, Object> root, Map<String, String> variables) {
        return ApplicationManifestUtils.toApplicationManifest(root, variables, ApplicationManifest.builder(), path).name("template").build();
    }

    private static ApplicationManifest.Builder toApplicationManifest(Map<String, Object> application, Map<String, String> variables, ApplicationManifest.Builder builder, Path root) {
        ApplicationManifestUtils.toApplicationManifestCommon(application, variables, builder, root);
        ApplicationManifestUtils.asListOfString(application, "services", variables, builder::service);
        return builder;
    }

    private static Map<String, Object> toYaml(ApplicationManifest applicationManifest) {
        Map<String, Object> yaml = ApplicationManifestUtilsCommon.toApplicationYaml(applicationManifest);
        ApplicationManifestUtils.putIfPresent(yaml, "services", applicationManifest.getServices());
        return yaml;
    }

    private static List<ApplicationManifest> doRead(Path path, Map<String, String> variables) {
        Map<String, Object> root = ApplicationManifestUtils.deserialize(path);
        ApplicationManifest template = ApplicationManifestUtils.getTemplate(path, root, variables);
        return Optional.ofNullable(root.get("applications")).map(value -> ((List)value).stream()).orElseGet(Stream::empty).map(application -> {
            String name = ApplicationManifestUtils.getName(application);
            return ApplicationManifestUtils.toApplicationManifest(application, variables, ApplicationManifest.builder().from(template), path).name(name).build();
        }).collect(Collectors.toList());
    }
}

