/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.lib.commands;

import com.mendix.cf.lib.MxCfCredentials;
import com.mendix.cf.lib.MxCfException;
import com.mendix.cf.lib.commands.MxCfLogin;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.SetEnvironmentVariableApplicationRequest;

public class MxCfPushMDA {
    private static final String DEVELOPMENT_MODE = "DEVELOPMENT_MODE";
    private static final String ADMIN_PASSWORD = "ADMIN_PASSWORD";
    private static final Logger logger = LogManager.getLogger(MxCfPushMDA.class);
    private String appName;
    private MxCfCredentials endpoint;
    private Path mdaFilePath;
    private String organization;
    private String space;
    private String mendixAdminPassword;
    private String buildpack;

    public MxCfPushMDA(String appName, String mendixAdminPassword, MxCfCredentials endpoint, String org, String space, String buildpack, Path mdaFilePath) {
        this.appName = appName;
        this.endpoint = endpoint;
        this.mdaFilePath = mdaFilePath;
        this.organization = org;
        this.space = space;
        this.mendixAdminPassword = mendixAdminPassword;
        this.buildpack = buildpack;
    }

    public void executeCommand() throws MxCfException {
        logger.info("Executing push: " + this.endpoint.toString());
        MxCfLogin login = new MxCfLogin();
        login.loginToCloudFoundry(this.endpoint);
        DefaultCloudFoundryOperations operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)login.getClient()).organization(this.organization).space(this.space).build();
        GetApplicationRequest request = GetApplicationRequest.builder().name(this.appName).build();
        operations.applications().get(request).block();
        this.pushMda(operations);
    }

    private void pushMda(DefaultCloudFoundryOperations operations) {
        SetEnvironmentVariableApplicationRequest setPasswdEnvRequest = SetEnvironmentVariableApplicationRequest.builder().name(this.appName).variableName(ADMIN_PASSWORD).variableValue(this.mendixAdminPassword).build();
        SetEnvironmentVariableApplicationRequest setModeEnvRequest = SetEnvironmentVariableApplicationRequest.builder().name(this.appName).variableName(DEVELOPMENT_MODE).variableValue("true").build();
        operations.applications().setEnvironmentVariable(setPasswdEnvRequest).then(operations.applications().setEnvironmentVariable(setModeEnvRequest)).block();
        PushApplicationRequest pushRequest = PushApplicationRequest.builder().name(this.appName).buildpack(this.buildpack).path(this.mdaFilePath).build();
        operations.applications().push(pushRequest).block();
    }
}

