/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.lib.commands;

import com.mendix.cf.lib.MxCfCredentials;
import com.mendix.cf.lib.MxCfOrganization;
import com.mendix.cf.lib.MxCfSpace;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.organizations.OrganizationDetail;
import org.cloudfoundry.operations.organizations.OrganizationInfoRequest;
import org.cloudfoundry.operations.organizations.OrganizationSummary;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.spaces.GetSpaceRequest;
import org.cloudfoundry.operations.spaces.SpaceDetail;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;

public class MxCfLogin {
    private static final Logger logger = LogManager.getLogger(MxCfLogin.class);
    private ReactorCloudFoundryClient client;

    public ReactorCloudFoundryClient getClient() {
        return this.client;
    }

    public void loginToCloudFoundry(MxCfCredentials endpoint) {
        logger.entry(new Object[]{"loginToCloudFoundry"});
        DefaultConnectionContext connectionContext = DefaultConnectionContext.builder().apiHost(endpoint.getURL()).build();
        PasswordGrantTokenProvider tokenProvider = PasswordGrantTokenProvider.builder().password(endpoint.getPassword()).username(endpoint.getUsername()).build();
        this.client = ReactorCloudFoundryClient.builder().connectionContext((ConnectionContext)connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
    }

    public List<MxCfOrganization> getOrganizations() {
        DefaultCloudFoundryOperations operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)this.client).build();
        ArrayList<MxCfOrganization> result = new ArrayList<MxCfOrganization>();
        Organizations organizations = operations.organizations();
        Iterable orgSummaries = organizations.list().toIterable();
        for (OrganizationSummary summary : orgSummaries) {
            MxCfOrganization org = new MxCfOrganization(summary.getName());
            OrganizationDetail detail = this.getOrganizationDetail(organizations, summary);
            for (SpaceDetail space : this.getSpaces(detail)) {
                MxCfSpace spc = new MxCfSpace(space.getName());
                for (String app : this.getApps(space)) {
                    spc.getApplications().add(app);
                }
                org.getSpaces().add(spc);
            }
            result.add(org);
        }
        return result;
    }

    private OrganizationDetail getOrganizationDetail(Organizations organizations, OrganizationSummary organization) {
        OrganizationInfoRequest request = OrganizationInfoRequest.builder().name(organization.getName()).build();
        return (OrganizationDetail)organizations.get(request).flux().toIterable().iterator().next();
    }

    private List<SpaceDetail> getSpaces(OrganizationDetail organization) {
        DefaultCloudFoundryOperations operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)this.client).organization(organization.getName()).build();
        ArrayList<SpaceDetail> result = new ArrayList<SpaceDetail>();
        for (String space : organization.getSpaces()) {
            result.add(this.getSpaceDetail(operations, space));
        }
        return result;
    }

    private SpaceDetail getSpaceDetail(DefaultCloudFoundryOperations operations, String space) {
        GetSpaceRequest request = GetSpaceRequest.builder().name(space).build();
        return (SpaceDetail)operations.spaces().get(request).flux().toIterable().iterator().next();
    }

    private List<String> getApps(SpaceDetail space) {
        return space.getApplications();
    }

    public List<String> getDomains() {
        DefaultCloudFoundryOperations operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)this.client).build();
        return (List)operations.domains().list().map(d -> d.getName()).collectList().block();
    }
}

