/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.lib.commands;

import com.mendix.cf.lib.MxCfCredentials;
import com.mendix.cf.lib.MxCfException;
import com.mendix.cf.lib.commands.MxCfLogin;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.PushApplicationRequest;

public class MxCfCreateApp {
    private static final Logger logger = LogManager.getLogger(MxCfCreateApp.class);
    private String appName;
    private MxCfCredentials endpoint;
    private String organization;
    private String space;
    private String domain;
    private String buildpack;
    private String error;
    private Path mdaFilePath;

    public MxCfCreateApp(String appName, MxCfCredentials endpoint, String org, String space, String domain, String buildpack, Path mdaFilePath) {
        this.appName = appName;
        this.endpoint = endpoint;
        this.organization = org;
        this.space = space;
        this.domain = domain;
        this.buildpack = buildpack;
        this.mdaFilePath = mdaFilePath;
    }

    public void executeCommand() throws MxCfException {
        logger.info("Executing createApp: " + this.endpoint.toString() + " app: " + this.appName);
        MxCfLogin login = new MxCfLogin();
        login.loginToCloudFoundry(this.endpoint);
        DefaultCloudFoundryOperations operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)login.getClient()).organization(this.organization).space(this.space).build();
        PushApplicationRequest pushRequest = PushApplicationRequest.builder().name(this.appName).host(this.appName).domain(this.domain).noStart(Boolean.valueOf(true)).buildpack(this.buildpack).path(this.mdaFilePath).memory(Integer.valueOf(512)).build();
        this.error = "";
        operations.applications().push(pushRequest).doOnError(t -> this.onCreateAppError(operations, (Throwable)t)).block();
        if (this.error != "") {
            throw new MxCfException(this.error);
        }
    }

    private void onCreateAppError(DefaultCloudFoundryOperations operations, Throwable t) {
        if (t.getMessage() != null && t.getMessage().startsWith("The host is taken")) {
            DeleteApplicationRequest deleteRequest = DeleteApplicationRequest.builder().name(this.appName).build();
            operations.applications().delete(deleteRequest).block();
        }
        this.error = t.getMessage();
    }
}

