/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonUtil {
    private static final Logger logger = LogManager.getLogger(JsonUtil.class);

    public static JsonNode readJsonFromString(String in) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(in);
    }

    public static String getPropertyValue(JsonNode node, String propertyName) {
        JsonNode value = node.get(propertyName);
        if (value != null && value.getNodeType() == JsonNodeType.STRING) {
            return value.asText();
        }
        return null;
    }

    public static List<String> getPropertyValueAsArray(JsonNode node, String propertyName) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode value = node.get(propertyName);
        if (value != null && value.getNodeType() == JsonNodeType.ARRAY) {
            ArrayNode array = (ArrayNode)value;
            for (JsonNode jsonNode : array) {
                result.add(jsonNode.asText());
            }
        }
        return result;
    }

    public static JsonNode parseJson(InputStream inputStream) {
        try {
            return JsonUtil.readJson(inputStream);
        }
        catch (JsonProcessingException e) {
            logger.info("JsonProcessingException : " + e.getMessage());
            throw new IllegalArgumentException("Unable to process JSON.", e);
        }
        catch (IOException e) {
            logger.info("IOException: " + e.getMessage());
            throw new IllegalArgumentException("IOException while reading JSON from input stream.", e);
        }
    }

    static JsonNode readJson(InputStream in) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(in);
    }
}

